/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInsertDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlColumnListCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        SqlExpression expression;
        PsiFile file;
        if (parameters == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
            return;
        }
        PsiElement prevSibling = position.getParent().getPrevSibling();
        if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlCommonTokens.SQL_PERIOD) {
            return;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlColumnListCompletionProvider.suggestTableColumnListAtOnce(position, dialect, result2);
        SqlAsExpression aliasDefinition = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlAsExpression.class);
        if (aliasDefinition != null && SqlCodeCompletionSettings.getInstance().isSuggestAliasNames() && PsiTreeUtil.isContextAncestor((PsiElement)aliasDefinition.getNameElement(), (PsiElement)position, (boolean)false) && (expression = aliasDefinition.getExpression()) != null) {
            for (String name : SqlNamesGenerator.suggestAliasNames(expression)) {
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(name, false, true, SqlInsertHandlers.TEMPLATE_SAFE_INSERT_HANDLER, ContainerUtil.emptyList()), (double)10.0));
            }
        }
    }

    @NotNull
    private static JBIterable<? extends DasColumn> getColumnsForTableReference(SqlReferenceExpression tableReference) {
        DasTable resolve = SqlCompletionContributor.retrieveTable((PsiElement)tableReference);
        if (resolve != null) {
            JBIterable jBIterable = DasUtil.getColumns((DasObject)resolve);
            if (jBIterable == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        SqlTableType tableType = SqlCompletionContributor.retrieveTableTypeForVariable((PsiElement)tableReference);
        if (tableType == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        ArrayList columns = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < tableType.getColumnCount(); ++i2) {
            PsiElement columnElement = tableType.getColumnElement(i2);
            if (!(columnElement instanceof DasColumn)) continue;
            columns.add((DasColumn)columnElement);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)columns);
        if (jBIterable == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private static List<SqlReferenceExpression> getReferenceList(@NotNull PsiElement position) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(6);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) != null) {
            List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(columnsList);
            if (list == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        SqlReferenceExpression refExp = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
        if (refExp == null || refExp.getParent() == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)refExp.getParent(), SqlReferenceExpression.class);
        if (list == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static JBIterable<? extends DasColumn> getColumns(@NotNull PsiElement position) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(10);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) != null) {
            JBIterable<? extends DasColumn> jBIterable = SqlColumnListCompletionProvider.getColumnsForTableReference(columnsList.getTableReference());
            if (jBIterable == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        JBIterable<? extends DasColumn> jBIterable = SqlColumnListCompletionProvider.getColumnsForTableReference(SqlColumnListCompletionProvider.getTableReferenceFromMergeStatement(position));
        if (jBIterable == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    private static SqlReferenceExpression getTableReferenceFromMergeStatement(@NotNull PsiElement position) {
        SqlInsertDmlInstructionImpl insert;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(13);
        }
        if ((insert = (SqlInsertDmlInstructionImpl)PsiTreeUtil.getParentOfType((PsiElement)position, SqlInsertDmlInstructionImpl.class)) == null) {
            return null;
        }
        SqlMergeStatement merge = (SqlMergeStatement)PsiTreeUtil.getParentOfType((PsiElement)insert, SqlMergeStatement.class);
        if (merge == null) {
            return null;
        }
        return (SqlReferenceExpression)SqlImplUtil.sqlTraverser((PsiElement)merge).filter(SqlReferenceExpression.class).filter(r -> r.getReferenceElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE).first();
    }

    private static void suggestTableColumnListAtOnce(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect, @NotNull CompletionResultSet result2) {
        List<SqlReferenceExpression> colRefs;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(14);
        }
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(16);
        }
        if ((colRefs = SqlColumnListCompletionProvider.getReferenceList(position)).size() != 1) {
            return;
        }
        boolean canQualify = SqlCompletionUtil.canQualify((PsiElement)colRefs.get(0));
        boolean lowerPriority = SqlColumnListCompletionProvider.shouldPlaceAfterColumns(position);
        JBIterable<? extends DasColumn> columns = SqlColumnListCompletionProvider.getColumns(position);
        Condition notAuto = info -> !DasUtil.isAuto((DasColumn)info);
        Condition notComputed = info -> !DasUtil.isComputed((DasColumn)info);
        Condition noDefault = info -> StringUtil.isEmpty((String)info.getDefault());
        if (dialect.getDbms().isMysql()) {
            SqlColumnListCompletionProvider.processMultiColumnVariants(dialect.getDatabaseDialect(), result2, canQualify, lowerPriority, columns.filter(notComputed).toList(), columns.filter(notAuto).toList(), columns.filter(notAuto).filter(noDefault).toList());
        } else {
            SqlColumnListCompletionProvider.processMultiColumnVariants(dialect.getDatabaseDialect(), result2, canQualify, lowerPriority, columns.filter(notAuto).toList(), columns.filter(notAuto).filter(noDefault).toList());
        }
    }

    private static boolean shouldPlaceAfterColumns(@NotNull PsiElement position) {
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)position, SqlValuesExpression.class, (boolean)true, (Class[])new Class[]{SqlInsertDmlInstructionImpl.class}) != null || PsiTreeUtil.getParentOfType((PsiElement)position, SqlOnTargetClauseImpl.class, (boolean)true, (Class[])new Class[]{SqlCreateIndexStatement.class}) != null;
    }

    private static void processMultiColumnVariants(@NotNull DatabaseDialectEx dialect, @NotNull CompletionResultSet result2, boolean canQualify, boolean lowerPriority, List<? extends DasColumn> ... multiColumns) {
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(19);
        }
        LinkedHashSet sorted = ContainerUtil.newLinkedHashSet((Object[])multiColumns);
        sorted.forEach(c2 -> {
            if (dialect == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(23);
            }
            if (result2 == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(24);
            }
            SqlColumnListCompletionProvider.processColumns(dialect, c2, result2, canQualify, lowerPriority);
        });
    }

    private static void processColumns(@NotNull DatabaseDialectEx dialect, @NotNull Iterable<? extends DasColumn> columns, @NotNull CompletionResultSet result2, boolean canQualify, boolean lowerPriority) {
        LookupElement all;
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(20);
        }
        if (columns == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(22);
        }
        if ((all = SqlCompletionUtil.createAllColumnsLookupElement(columns, dialect, lowerPriority ? 5 : 99, true, canQualify, ContainerUtil.emptyList())) != null) {
            result2.addElement(all);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlColumnListCompletionProvider";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlColumnListCompletionProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsForTableReference";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTableReferenceFromMergeStatement";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestTableColumnListAtOnce";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldPlaceAfterColumns";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMultiColumnVariants";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processColumns";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMultiColumnVariants$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

