/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SqlModelBuilderUtils {
    public static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModelOnPooledThread(@NotNull Project project, DasModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        if (project == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(0);
        }
        if (texts == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(1);
        }
        Ref res2 = Ref.create();
        DbUIUtil.invokeOnPooledThreadSync(() -> {
            if (project == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(6);
            }
            if (texts == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(7);
            }
            DbImplUtil.performSrcOperation(model, null, false, () -> {
                if (project == null) {
                    SqlModelBuilderUtils.$$$reportNull$$$0(8);
                }
                if (texts == null) {
                    SqlModelBuilderUtils.$$$reportNull$$$0(9);
                }
                ReadAction.run(() -> {
                    if (project == null) {
                        SqlModelBuilderUtils.$$$reportNull$$$0(10);
                    }
                    if (texts == null) {
                        SqlModelBuilderUtils.$$$reportNull$$$0(11);
                    }
                    res2.set(SqlModelBuilderUtils.fillModel(project, (BasicModModel)model, saveSources, useReadOnlyPsi, texts));
                });
            });
        });
        return (Map)res2.get();
    }

    private static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModel(@NotNull Project project, @NotNull BasicModModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        PsiErrorElement error2;
        if (project == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(2);
        }
        if (model == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(3);
        }
        if (texts == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(4);
        }
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(model.getDbms());
        List files = JBIterable.of((Object[])texts).map(text2 -> {
            if (project == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(5);
            }
            return useReadOnlyPsi ? SqlPsiFacade.getInstance((Project)project).createROFile(sqlDialect, (CharSequence)text2) : (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlDialect, (CharSequence)text2);
        }).toList();
        if (!useReadOnlyPsi && (error2 = (PsiErrorElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)files)).filter(PsiErrorElement.class).first()) != null) {
            throw new AssertionError((Object)(error2.getContainingFile().getName() + ": " + error2.getErrorDescription()));
        }
        SqlModelBuilder builder = new SqlModelBuilder(project, model, ContainerUtil.newHashMap());
        builder.begin(saveSources);
        builder.introspect(files, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/database/SqlModelBuilderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillModelOnPooledThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fillModel$3";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fillModelOnPooledThread$2";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

