/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base.psi;

import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlFunctionBodyInjector
implements MultiHostInjector {
    private static Map<String, Language> ourTestInterceptor;

    public static void setTestInterceptor(@Nullable Map<String, Language> testInterceptor) {
        ourTestInterceptor = testInterceptor;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return;
        }
        if (!this.canApply(context)) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        Pair<Language, String> pair = this.calcBodyLanguage(context);
        if (pair == null) {
            return;
        }
        Language language = (Language)pair.first;
        String extension = (String)pair.second;
        if (language == null) {
            return;
        }
        if (extension == null) {
            registrar.startInjecting(language);
        } else {
            registrar.startInjecting(language, extension);
        }
        Pair<String, String> prefixSuffix = this.getPrefixSuffix(language);
        String prefix = null;
        String suffix = null;
        if (prefixSuffix != null) {
            prefix = (String)prefixSuffix.first;
            suffix = (String)prefixSuffix.second;
        }
        registrar.addPlace(prefix, suffix, host, ElementManipulators.getValueTextRange((PsiElement)host));
        registrar.doneInjecting();
    }

    protected abstract boolean canApply(PsiElement var1);

    @Nullable
    protected abstract Pair<Language, String> calcBodyLanguage(@NotNull PsiElement var1);

    @Nullable
    protected abstract Pair<String, String> getPrefixSuffix(Language var1);

    @Nullable
    protected Pair<Language, String> getLangBySpec(@Nullable String text2) {
        return SqlFunctionBodyInjector.getLangBySpecInner(text2);
    }

    @Nullable
    protected static Pair<Language, String> getLangBySpecInner(@Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        text2 = Case.LOWER.apply(text2);
        String languageId = null;
        String extension = text2;
        if (text2.contains("python")) {
            languageId = "Python";
            extension = "py";
        } else {
            switch (text2) {
                case "v8": {
                    languageId = "JS";
                    extension = "js";
                    break;
                }
                case "java": {
                    languageId = "JAVA";
                    extension = "java";
                    break;
                }
                case "r": {
                    languageId = "R";
                    extension = "r";
                    break;
                }
                case "lua": {
                    languageId = "Lua";
                    extension = "lua";
                    break;
                }
                case "ruby": {
                    languageId = "ruby";
                    extension = "rb";
                    break;
                }
                case "javascript": {
                    languageId = "JavaScript";
                    extension = "js";
                }
            }
        }
        Language language = ourTestInterceptor != null ? ourTestInterceptor.get(languageId) : Language.findLanguageByID((String)languageId);
        return languageId == null ? SqlFunctionBodyInjector.findLanguage(text2, extension) : Pair.create((Object)language, (Object)extension);
    }

    @Nullable
    static Pair<Language, String> findLanguage(String name, String extension) {
        FileTypeManager typeManager = FileTypeManager.getInstance();
        FileType fileType = typeManager.getFileTypeByExtension(name);
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = typeManager.getFileTypeByExtension(extension);
        }
        if (fileType instanceof LanguageFileType) {
            return Pair.create((Object)((LanguageFileType)fileType).getLanguage(), (Object)extension);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "registrar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/dialects/base/psi/SqlFunctionBodyInjector";
        objectArray[2] = "getLanguagesToInject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

