/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.dialects.cassandra.psi.CassArrayLiteral;
import com.intellij.sql.dialects.cassandra.psi.CassSetOrMapLiteral;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CassCollectionLiteral
extends SqlLiteralExpressionImpl {
    public CassCollectionLiteral(@NotNull IElementType elementType) {
        if (elementType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            CassCollectionLiteral.$$$reportNull$$$0(1);
        }
        if (state == null) {
            CassCollectionLiteral.$$$reportNull$$$0(2);
        }
        if (place == null) {
            CassCollectionLiteral.$$$reportNull$$$0(3);
        }
        if (!this.isInsideLiteral(place)) {
            return true;
        }
        SqlTableType sqlTableType = (SqlTableType)ObjectUtils.tryCast((Object)this.getExpectedSqlType(), SqlTableType.class);
        if (sqlTableType == null) {
            return false;
        }
        SqlImplUtil.processDeclarationsInType(sqlTableType, processor, state, place);
        return false;
    }

    protected boolean isInsideLiteral(PsiElement place) {
        PsiElement parent2 = place.getParent();
        return parent2 == this;
    }

    @NotNull
    public SqlType getExpectedSqlType() {
        PsiElement parent2 = this.getParent();
        SqlSetAssignment setAssignment = null;
        if (parent2 instanceof SqlSetAssignment) {
            setAssignment = (SqlSetAssignment)parent2;
            parent2 = setAssignment.getParent();
        }
        if (parent2 instanceof CassSetOrMapLiteral) {
            SqlType sqlType = this.getExpectedTypeInSetOrMapLiteral((CassSetOrMapLiteral)parent2, setAssignment);
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(4);
            }
            return sqlType;
        }
        if (parent2 instanceof CassArrayLiteral && setAssignment == null) {
            SqlType sqlType = this.getExpectedTypeInArrayLiteral((CassArrayLiteral)parent2);
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(5);
            }
            return sqlType;
        }
        if (parent2 instanceof SqlParenthesizedExpression) {
            String colName = this.getExpectedTypeNameInParenExpr();
            if (colName != null) {
                SqlType sqlType = this.getExpectedTypeInDmlInstruction(colName);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(6);
                }
                return sqlType;
            }
        } else if (parent2 instanceof SqlSetClause && setAssignment != null) {
            String name = setAssignment.getLValue().getName();
            if (name != null) {
                SqlType sqlType = this.getExpectedTypeInDmlInstruction(name);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(7);
                }
                return sqlType;
            }
        } else if (parent2 instanceof SqlBinaryExpression) {
            SqlExpression lOperand = ((SqlBinaryExpression)parent2).getLOperand();
            if (!(lOperand instanceof SqlReferenceExpression)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(8);
                }
                return sqlPrimitiveType;
            }
            String colName = lOperand.getName();
            if (colName == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(9);
                }
                return sqlPrimitiveType;
            }
            if (this.getParentOfType(SqlDmlInstructionImpl.class) != null) {
                SqlType sqlType = this.getExpectedTypeInDmlInstruction(colName);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(10);
                }
                return sqlType;
            }
            SqlType sqlType = this.getExpectedTypeInTableExpression(colName);
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(11);
            }
            return sqlType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(12);
        }
        return sqlPrimitiveType;
    }

    private <T extends PsiElement> T getParentOfType(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CassCollectionLiteral.$$$reportNull$$$0(13);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this, aClass);
    }

    @NotNull
    private SqlType getExpectedTypeInSetOrMapLiteral(@NotNull CassSetOrMapLiteral parent2, @Nullable SqlSetAssignment setAssignment) {
        SqlType parentLiteralType;
        if (parent2 == null) {
            CassCollectionLiteral.$$$reportNull$$$0(14);
        }
        if ((parentLiteralType = parent2.getExpectedSqlType()) instanceof SqlParametrizedType && ((SqlParametrizedType)parentLiteralType).getTypeParametersCount() > 0) {
            String specification = parentLiteralType.getDataType().getSpecification();
            SqlParametrizedType parametrizedType = (SqlParametrizedType)parentLiteralType;
            if (StringUtil.startsWithIgnoreCase((String)specification, (String)"map<")) {
                if (setAssignment == null) {
                    SqlType sqlType = parametrizedType.getTypeParameter(0);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(15);
                    }
                    return sqlType;
                }
                if (setAssignment.getLValue() == this) {
                    SqlType sqlType = parametrizedType.getTypeParameter(0);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(16);
                    }
                    return sqlType;
                }
                if (setAssignment.getRValue() == this && parametrizedType.getTypeParametersCount() > 1) {
                    SqlType sqlType = parametrizedType.getTypeParameter(1);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(17);
                    }
                    return sqlType;
                }
            } else if (parentLiteralType.getCategory() == SqlType.Category.SETOF) {
                SqlType sqlType = parametrizedType.getTypeParameter(0);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(18);
                }
                return sqlType;
            }
        } else if (parentLiteralType instanceof SqlTableType && setAssignment != null) {
            SqlTableType tableType = (SqlTableType)parentLiteralType;
            String columnName = setAssignment.getLValue().getName();
            if (columnName == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(19);
                }
                return sqlPrimitiveType;
            }
            SqlType sqlType = CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(20);
            }
            return sqlType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(21);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private SqlType getExpectedTypeInArrayLiteral(@NotNull CassArrayLiteral parent2) {
        SqlType parentLiteralType;
        if (parent2 == null) {
            CassCollectionLiteral.$$$reportNull$$$0(22);
        }
        if ((parentLiteralType = parent2.getExpectedSqlType()) instanceof SqlParametrizedType && ((SqlParametrizedType)parentLiteralType).getTypeParametersCount() > 0) {
            String specification = parentLiteralType.getDataType().getSpecification();
            SqlParametrizedType parametrizedType = (SqlParametrizedType)parentLiteralType;
            if (parentLiteralType.getCategory() == SqlType.Category.ARRAY) {
                SqlType sqlType = parametrizedType.getTypeParameter(0);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(23);
                }
                return sqlType;
            }
            if (StringUtil.startsWithIgnoreCase((String)specification, (String)"tuple<")) {
                List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent2, SqlExpression.class);
                for (int i2 = 0; i2 < expressions.size(); ++i2) {
                    if (expressions.get(i2) != this) continue;
                    if (i2 < parametrizedType.getTypeParametersCount()) {
                        SqlType sqlType = parametrizedType.getTypeParameter(i2);
                        if (sqlType == null) {
                            CassCollectionLiteral.$$$reportNull$$$0(24);
                        }
                        return sqlType;
                    }
                    SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                    if (sqlPrimitiveType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(25);
                    }
                    return sqlPrimitiveType;
                }
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(26);
        }
        return sqlPrimitiveType;
    }

    @Nullable
    private String getExpectedTypeNameInParenExpr() {
        SqlExpressionList list = SqlValuesParameterInfoHandler.findExpressions((PsiElement)this);
        if (list == null) {
            return null;
        }
        int offset = this.getStartOffset();
        int index2 = SqlValuesParameterInfoHandler.getCurrentParameterIndex(list, offset);
        SqlDmlInstruction instruction = this.getParentOfType(SqlDmlInstruction.class);
        if (instruction == null || index2 < 0) {
            return null;
        }
        SqlTableType tableType = instruction.getTargetType();
        if (index2 >= tableType.getColumnCount()) {
            return null;
        }
        return tableType.getColumnName(index2);
    }

    @NotNull
    private SqlType getExpectedTypeInDmlInstruction(@NotNull String columnName) {
        SqlDmlInstructionImpl instruction;
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(27);
        }
        if ((instruction = this.getParentOfType(SqlDmlInstructionImpl.class)) == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(28);
            }
            return sqlPrimitiveType;
        }
        SqlTableType tableType = instruction.getTargetType();
        if (tableType == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(29);
            }
            return sqlPrimitiveType;
        }
        SqlType sqlType = CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
        if (sqlType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(30);
        }
        return sqlType;
    }

    @NotNull
    private SqlType getExpectedTypeInTableExpression(@NotNull String columnName) {
        SqlTableExpression tableExpression;
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(31);
        }
        if ((tableExpression = this.getParentOfType(SqlTableExpression.class)) == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(32);
            }
            return sqlPrimitiveType;
        }
        SqlTableType tableType = tableExpression.getSqlType();
        SqlType sqlType = CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
        if (sqlType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(33);
        }
        return sqlType;
    }

    @NotNull
    private static SqlType getExpectedSqlType(@NotNull SqlTableType parentType, @NotNull String columnName) {
        if (parentType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(34);
        }
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(35);
        }
        for (int i2 = 0; i2 < parentType.getColumnCount(); ++i2) {
            if (!columnName.equals(parentType.getColumnName(i2))) continue;
            SqlType sqlType = CassCollectionLiteral.unwrapFrozenType(parentType.getColumnType(i2));
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(36);
            }
            return sqlType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(37);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private static SqlType unwrapFrozenType(SqlType type) {
        if (!(type instanceof SqlParametrizedType)) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(38);
            }
            return sqlType;
        }
        String specification = type.getDataType().getSpecification();
        if (!StringUtil.startsWithIgnoreCase((String)specification, (String)"frozen<")) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(39);
            }
            return sqlType;
        }
        SqlParametrizedType parametrizedType = (SqlParametrizedType)type;
        if (parametrizedType.getTypeParametersCount() < 1) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(40);
            }
            return sqlType;
        }
        SqlType typeParameter = parametrizedType.getTypeParameter(0);
        SqlType sqlType = CassCollectionLiteral.unwrapFrozenType(typeParameter);
        if (sqlType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(41);
        }
        return sqlType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassCollectionLiteral";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassCollectionLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedSqlType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInSetOrMapLiteral";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInArrayLiteral";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInDmlInstruction";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInTableExpression";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFrozenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInSetOrMapLiteral";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInArrayLiteral";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInDmlInstruction";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInTableExpression";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

