/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.clickhouse.CHouseOptionalKeywords;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.dialects.clickhouse.psi.CHouseJoinExpression;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseDialect
extends SqlLanguageDialectEx {
    public static final SqlFunctionDefinition.Type ANY_NA = new SqlFunctionDefinition.Type("ANY_NA", DataTypeFactory.of("any"));
    public static final SqlFunctionDefinition.Type STRING_OR_TOKEN = new SqlFunctionDefinition.Type("StringOrToken", DataTypeFactory.of("String"));
    public static final SqlFunctionDefinition.Type STRING_OR_SCHEMA = new SqlFunctionDefinition.Type("StringOrSchema", DataTypeFactory.of("String"));
    public static final SqlFunctionDefinition.Type ARRAY = new SqlFunctionDefinition.Type("Array", DataTypeFactory.of("Array"));
    public static final SqlFunctionDefinition.Type AGGREGATE_FUNCTION = new SqlFunctionDefinition.Type("AggregateFunction", DataTypeFactory.of("AggregateFunction"));
    public static final CHouseDialect INSTANCE = new CHouseDialect();

    public CHouseDialect() {
        super("ClickHouse");
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, ANY_NA);
        SqlFunctionDefinition.addSimpleType(myTypes, STRING_OR_TOKEN);
        SqlFunctionDefinition.addSimpleType(myTypes, STRING_OR_SCHEMA);
        SqlFunctionDefinition.addSimpleType(myTypes, "UInt8", "UInt8", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "UInt16", "UInt16", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "UInt32", "UInt32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "UInt64", "UInt64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Int8", "Int8", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Int16", "Int16", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Int32", "Int32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Int64", "Int64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Float32", "Float32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Float64", "Float64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Date", "Date", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "DateTime", "DateTime", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "String", "String", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "FixedString", "FixedString", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, ARRAY);
        SqlFunctionDefinition.addSimpleType(myTypes, "Tuple", "Tuple", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Enum", "Enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "UUID", "UUID", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Expression", "Expression", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, AGGREGATE_FUNCTION);
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity.Typed entity : LazyData.RE_COLUMNS) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple(entity, entity.type, name, element2, resolve, processor, true, true)) continue;
                return false;
            }
        }
        if (element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getQualifierExpression() == null) {
            for (ReservedEntity type : LazyData.ourObjects) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple(type, REFERENCE, name, element2, resolve, processor, true, resolve)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CHouseDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, (TreePatternNode.Group[])null);
            if (treePattern == null) {
                CHouseDialect.$$$reportNull$$$0(7);
            }
            return treePattern;
        }
        String dbname = (String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"default");
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)dbname), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            CHouseDialect.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    @Override
    @Nullable
    public SqlType getUnqualifiedAsteriskType(@NotNull PsiElement element2) {
        SqlQueryExpression queryExpression;
        SqlTableExpression tableExpression;
        if (element2 == null) {
            CHouseDialect.$$$reportNull$$$0(9);
        }
        SqlTableExpression sqlTableExpression = tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        if (tableExpression == null) {
            return null;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return this.getDummyType(tableExpression);
        }
        SqlExpression expr = fromClause.getFromExpression();
        if (expr == null) {
            return null;
        }
        return expr instanceof CHouseJoinExpression ? ((CHouseJoinExpression)expr).calcJoinType(null, true) : expr.getSqlType();
    }

    @Override
    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(10);
        }
        return CHouseDialect.isOpIn(place) && !(place.getParent() instanceof SqlReferenceExpression);
    }

    @Override
    @NotNull
    public Set<SqlFunctionDefinition.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression, SqlReferenceExpression.class);
        if (ref != null && ref.getReferenceElementType().getTargetKind() == SqlDbElementType.ENGINE) {
            EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.ENGINE_SPEC);
            if (enumSet == null) {
                CHouseDialect.$$$reportNull$$$0(11);
            }
            return enumSet;
        }
        Set<SqlFunctionDefinition.Location> set = super.getExpectedFunctionLocations(expression);
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(12);
        }
        return set;
    }

    private SqlType getDummyType(@NotNull SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            CHouseDialect.$$$reportNull$$$0(13);
        }
        return (SqlType)CachedValuesManager.getCachedValue((PsiElement)tableExpression, () -> {
            if (tableExpression == null) {
                CHouseDialect.$$$reportNull$$$0(34);
            }
            return CachedValueProvider.Result.create((Object)this.calcDummyType(tableExpression), (Object[])new Object[]{tableExpression});
        });
    }

    private SqlType calcDummyType(@NotNull SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        SqlType dummy = SqlTypeFactory.defaultType(SqlType.Category.BOOLEAN, this);
        return SqlImplUtil.createType(Collections.singletonList(PostgresDialect.col((PsiElement)tableExpression, null, "dummy", dummy)), tableExpression.getParent());
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return res2;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        if ((type == ObjectKind.VIEW || type == ObjectKind.MAT_VIEW) && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && expectedTypes.contains(SqlDbElementType.ENGINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        switch (cat) {
            case INTEGER: {
                return "Int64";
            }
            case REAL: {
                return "Float64";
            }
            case STRING: {
                return "String";
            }
            case BOOLEAN: {
                return "UInt8";
            }
            case DATE_TIME: {
                return "DateTime";
            }
            case DATE: {
                return "Date";
            }
            case TIME: {
                return "DateTime";
            }
            case TIMESTAMP: {
                return "DateTime";
            }
            case INTERVAL: {
                return "Interval";
            }
            case BYTES: {
                return "FixedString";
            }
            case ARRAY: {
                return "Array";
            }
            case RECORD: {
                return "Tuple";
            }
            case TABLE: {
                return "Nested";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        if (name.equalsIgnoreCase("int")) {
            if ("Int32" == null) {
                CHouseDialect.$$$reportNull$$$0(19);
            }
            return "Int32";
        }
        if (name.equalsIgnoreCase("integer")) {
            if ("Int32" == null) {
                CHouseDialect.$$$reportNull$$$0(20);
            }
            return "Int32";
        }
        String string = name;
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.FORMAT && type != SqlDbElementType.PARTITION && super.shallResolve(o, type);
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        SqlReferenceExpression prevRef;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        if (!CHouseDialect.processAliases(processor, state, ref)) {
            return false;
        }
        PsiElement place = ref.getElement();
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE) && ObjectUtils.tryCast((Object)place.getParent(), SqlExpressionList.class) != null && (prevRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)place, SqlExpression.class), SqlReferenceExpression.class)) != null && prevRef.getReferenceElementType().getTargetKind() == ObjectKind.SCHEMA && !SqlImplUtil.processQualifier(prevRef, processor, state, place)) {
            return false;
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    @Override
    public boolean processTypeExtra(SqlTableType type, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        for (PsiObject pc : CHouseDialect.getParentColumnObjects(place.getContainingFile(), type)) {
            if (processor.execute((PsiElement)pc, state)) continue;
            return false;
        }
        return super.processTypeExtra(type, processor, state, place);
    }

    private static boolean isOpIn(@Nullable PsiElement place) {
        SqlBinaryExpression exp;
        SqlBinaryExpression sqlBinaryExpression = exp = place == null ? null : (SqlBinaryExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlBinaryExpression.class);
        if (exp == null || exp.getROperand() != place) {
            return place == null;
        }
        return exp.getOpSign() == SqlCommonKeywords.SQL_IN;
    }

    private static boolean processAliases(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        PsiElement place;
        SqlQueryExpression root2;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(25);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(26);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        if ((root2 = (SqlQueryExpression)PsiTreeUtil.getContextOfType((PsiElement)(place = ref.getElement()), (Class[])new Class[]{SqlQueryExpression.class})) == null) {
            return true;
        }
        for (SqlAsExpression alias : CHouseDialect.getAliases(root2)) {
            if (PsiTreeUtil.isContextAncestor((PsiElement)alias, (PsiElement)place, (boolean)false) || processor.execute((PsiElement)alias, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<PsiObject> getParentColumnObjects(@NotNull PsiFile file, @Nullable SqlTableType type) {
        if (file == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        if (type == null || type.getTypeElement() instanceof MyAggColumnDefinition) {
            List<PsiObject> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(29);
            }
            return list;
        }
        Map grouped = null;
        int c2 = type.getColumnCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            String name = type.getColumnName(i2);
            int dotIdx = name.indexOf(46);
            if (dotIdx == -1) continue;
            if (grouped == null) {
                grouped = ContainerUtil.newHashMap();
            }
            ((List)ContainerUtil.getOrCreate((Map)grouped, (Object)name.substring(0, dotIdx), ContainerUtil::newArrayList)).add(ObjectUtils.chooseNotNull((Object)type.getSourceColumnElement(i2), (Object)type.getColumnElement(i2)));
        }
        if (grouped == null) {
            List<PsiObject> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList res2 = ContainerUtil.newArrayListWithCapacity((int)grouped.size());
        ConcurrentMap caches = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        for (Map.Entry entry : grouped.entrySet()) {
            res2.add(caches.computeIfAbsent(Pair.create(entry.getKey(), entry.getValue()), param -> new MyAggColumnDefinition((PsiElement)((List)param.second).get(0), (String)param.first, (List)param.second)));
        }
        ArrayList arrayList = res2;
        if (arrayList == null) {
            CHouseDialect.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public static boolean isNestedType(@NotNull SqlColumnDefinition o1) {
        SqlTypeElement type;
        if (o1 == null) {
            CHouseDialect.$$$reportNull$$$0(32);
        }
        if (PsiUtilCore.getElementType((PsiElement)(type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)o1, SqlTypeElement.class))) != SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT) {
            return false;
        }
        PsiElement name = type.getFirstChild();
        name = name == null ? null : name.getFirstChild();
        name = name == null ? null : name.getFirstChild();
        return PsiUtilCore.getElementType((PsiElement)name) == CHouseTypes.CH_NESTED;
    }

    private static List<SqlAsExpression> getAliases(SqlQueryExpression root2) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)root2, () -> CachedValueProvider.Result.create(CHouseDialect.calcAliases(root2), (Object[])new Object[]{root2}));
    }

    @NotNull
    private static List<SqlAsExpression> calcAliases(SqlQueryExpression root2) {
        List list = ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)root2).expand(e -> e == root2 || !(e instanceof SqlQueryExpression))).filter(SqlAsExpression.class).toList();
        if (list == null) {
            CHouseDialect.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 13: 
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 16: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentColumnObjects";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAliases";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedAsteriskType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDummyType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcDummyType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processAliases";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentColumnObjects";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNestedType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDummyType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAggColumnDefinition
    extends MyColumnDefinition {
        private final List<PsiElement> myColumns;

        MyAggColumnDefinition(PsiElement parent2, String name, List<PsiElement> columns) {
            super(parent2, name);
            this.myColumns = columns;
        }

        @Override
        @NotNull
        public SqlType getSqlType() {
            String preName = this.getName();
            ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)this.myColumns.size());
            for (PsiElement column2 : this.myColumns) {
                String name = column2 instanceof DasObject ? ((DasObject)column2).getName() : "";
                String cName = name.length() <= preName.length() ? name : name.substring(preName.length() + 1);
                columns.add(CachedValuesManager.getCachedValue((PsiElement)column2, () -> CachedValueProvider.Result.create((Object)((Object)new MyColumnDefinition(column2, cName)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})));
            }
            TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl(columns, (PsiElement)this);
            if (tableBasedSqlTableTypeImpl == null) {
                MyAggColumnDefinition.$$$reportNull$$$0(0);
            }
            return tableBasedSqlTableTypeImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/clickhouse/CHouseDialect$MyAggColumnDefinition", "getSqlType"));
        }
    }

    private static class MyColumnDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        MyColumnDefinition(PsiElement parent2, String name) {
            super(parent2, name, null);
        }

        @NotNull
        public Language getLanguage() {
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(this.getParent());
            if (sqlLanguageDialectEx == null) {
                MyColumnDefinition.$$$reportNull$$$0(0);
            }
            return sqlLanguageDialectEx;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.getParent();
            if (psiElement == null) {
                MyColumnDefinition.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        public boolean isNameQuoted() {
            return false;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnDefinition.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                MyColumnDefinition.$$$reportNull$$$0(3);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return true;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = INSTANCE.getSqlType(null, this.getParent());
            if (sqlType == null) {
                MyColumnDefinition.$$$reportNull$$$0(4);
            }
            return sqlType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$MyColumnDefinition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class SuffixedBuiltinFunctions
    implements SqlLanguageDialectEx.BuiltinFunctions {
        private final Map<String, SqlFunctionDefinition> myMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));

        private SuffixedBuiltinFunctions() {
        }

        @Override
        @Nullable
        public SqlFunctionDefinition get(@Nullable String name) {
            SqlFunctionDefinition def2 = this.getImpl(name);
            if (def2 != null || name == null) {
                return def2;
            }
            return this.getSuffixed(name);
        }

        @Nullable
        private SqlFunctionDefinition getSuffixed(@NotNull String name) {
            Suffix suffix;
            if (name == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(0);
            }
            if ((suffix = Suffix.find(name)) == null) {
                return null;
            }
            SqlFunctionDefinition def2 = this.myMap.get(name = suffix.trim(name));
            if (def2 != null && !"true".equals(def2.getDialectAttribute("aggregate"))) {
                return null;
            }
            if (def2 == null) {
                def2 = this.getSuffixed(name);
            }
            return def2 == null ? null : suffix.modify(def2);
        }

        @Override
        public boolean contains(@Nullable String name) {
            if (this.getImpl(name) != null) {
                return true;
            }
            while (name != null) {
                Suffix suffix = Suffix.find(name);
                if (suffix == null) {
                    return false;
                }
                SqlFunctionDefinition def2 = this.myMap.get(name = suffix.trim(name));
                if (def2 == null) continue;
                return "true".equals(def2.getDialectAttribute("aggregate"));
            }
            return false;
        }

        @Nullable
        private SqlFunctionDefinition getImpl(@Nullable String name) {
            SqlFunctionDefinition def2 = this.myMap.get(name);
            if (def2 != null || name == null) {
                return def2;
            }
            def2 = this.myMap.get(Case.LOWER.apply(name));
            return def2 != null && "true".equals(def2.getDialectAttribute("insensitive")) ? def2 : null;
        }

        @Override
        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(1);
            }
            JBIterable<SqlFunctionDefinition> jBIterable = this.byMatcherImpl(matcher);
            if (jBIterable == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        JBIterable<SqlFunctionDefinition> byMatcherImpl(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(3);
            }
            return JBIterable.from(this.myMap.values()).filter(d2 -> {
                if (matcher == null) {
                    SuffixedBuiltinFunctions.$$$reportNull$$$0(5);
                }
                return matcher.prefixMatches(d2.getName());
            });
        }

        @Override
        @NotNull
        public Collection<SqlFunctionDefinition> forTokens() {
            Collection<SqlFunctionDefinition> collection = this.myMap.values();
            if (collection == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(4);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuffixed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcherImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$byMatcherImpl$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum Suffix {
            If{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p2) {
                    SqlFunctionDefinition.Parameter[] oldParams = p2.getParams();
                    boolean broken = oldParams.length != 0 && this.isGreedy(oldParams[oldParams.length - 1]);
                    SqlFunctionDefinition.Parameter[] params = new SqlFunctionDefinition.Parameter[oldParams.length + (broken ? 1 : 2)];
                    System.arraycopy(oldParams, 0, params, 0, oldParams.length);
                    SqlFunctionDefinition.Parameter[] argSeq = broken ? new SqlFunctionDefinition.Parameter[2] : params;
                    argSeq[argSeq.length - 2] = COMMA.copyWithPrototype(p2.getPrototypeId());
                    argSeq[argSeq.length - 1] = COND.copyWithPrototype(p2.getPrototypeId());
                    if (broken) {
                        params[params.length - 1] = new SqlFunctionDefinition.ParameterBlock(p2.getPrototypeId(), SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE, argSeq, false);
                    }
                    return new SqlFunctionDefinition.Prototype(null, p2.getReturnType(), p2.getPrototypeId(), p2.getHeadBlock(), params, p2.getTailBlock(), p2.getAttributes());
                }

                private boolean isGreedy(SqlFunctionDefinition.Parameter param) {
                    if (param.isMany()) {
                        return true;
                    }
                    SqlFunctionDefinition.ParameterBlock block = (SqlFunctionDefinition.ParameterBlock)ObjectUtils.tryCast((Object)param, SqlFunctionDefinition.ParameterBlock.class);
                    if (block == null || block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.CHOICE) {
                        return false;
                    }
                    if (block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE) {
                        return true;
                    }
                    SqlFunctionDefinition.Parameter[] params = block.getParams();
                    return params.length == 0 || this.isGreedy(params[params.length - 1]);
                }
            }
            ,
            Array{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p2) {
                    SqlFunctionDefinition.Parameter[] params = Suffix.makeArrayParams(p2.getParams());
                    SqlFunctionDefinition.Type ret = p2.getReturnType();
                    if (ret instanceof SqlFunctionDefinition.ParamType) {
                        ret = SqlFunctionDefinition.ANY;
                    }
                    return new SqlFunctionDefinition.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), params, p2.getTailBlock(), p2.getAttributes());
                }
            }
            ,
            State{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p2) {
                    return new SqlFunctionDefinition.Prototype(null, AGGREGATE_FUNCTION, p2.getPrototypeId(), p2.getHeadBlock(), p2.getParams(), p2.getTailBlock(), p2.getAttributes());
                }
            }
            ,
            Merge{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p2) {
                    SqlFunctionDefinition.Type ret = p2.getReturnType();
                    if (ret instanceof SqlFunctionDefinition.ParamType) {
                        ret = SqlFunctionDefinition.ANY;
                    }
                    return new SqlFunctionDefinition.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), new SqlFunctionDefinition.Parameter[]{STATE.copyWithPrototype(p2.getPrototypeId())}, p2.getTailBlock(), p2.getAttributes());
                }
            }
            ,
            ForEach{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p2) {
                    SqlFunctionDefinition.Parameter[] params = Suffix.makeArrayParams(p2.getParams());
                    return new SqlFunctionDefinition.Prototype(null, ARRAY, p2.getPrototypeId(), p2.getHeadBlock(), params, p2.getTailBlock(), p2.getAttributes());
                }
            };

            private static final SqlFunctionDefinition.Parameter COMMA;
            private static final SqlFunctionDefinition.Parameter COND;
            private static final SqlFunctionDefinition.Parameter STATE;
            private final Map<SqlFunctionDefinition, SqlFunctionDefinition> myCache = ConcurrentFactoryMap.createMap(this::modifyDef, ContainerUtil::createConcurrentSoftValueMap);

            boolean at(String s) {
                return this.name().length() < s.length() && s.endsWith(this.name());
            }

            String trim(String s) {
                return s.substring(0, s.length() - this.name().length());
            }

            SqlFunctionDefinition modify(SqlFunctionDefinition def2) {
                return this.myCache.get((Object)def2);
            }

            private SqlFunctionDefinition modifyDef(SqlFunctionDefinition def2) {
                SqlFunctionDefinition.Prototype[] protos = def2.getPrototypes();
                ArrayList newProtos = ContainerUtil.newArrayListWithCapacity((int)protos.length);
                for (SqlFunctionDefinition.Prototype proto : protos) {
                    newProtos.add(this.modifyProto(proto));
                }
                return new SqlFunctionDefinition(def2.getName() + this.name(), def2.getAliasedFunction(), def2.getDialectAttrs(), newProtos);
            }

            protected abstract SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype var1);

            @NotNull
            private static SqlFunctionDefinition.Parameter[] makeArrayParams(SqlFunctionDefinition.Parameter[] oldParams) {
                SqlFunctionDefinition.Parameter[] params = new SqlFunctionDefinition.Parameter[oldParams.length];
                for (int i2 = 0; i2 < oldParams.length; ++i2) {
                    SqlFunctionDefinition.Parameter param = oldParams[i2];
                    params[i2] = Suffix.makeArrayParams(param);
                }
                if (params == null) {
                    Suffix.$$$reportNull$$$0(0);
                }
                return params;
            }

            private static SqlFunctionDefinition.Parameter makeArrayParams(SqlFunctionDefinition.Parameter p2) {
                if (p2 instanceof SqlFunctionDefinition.SimpleParameter) {
                    return new SqlFunctionDefinition.SimpleParameter(p2.getPrototypeId(), ((SqlFunctionDefinition.SimpleParameter)p2).getName(), ARRAY, p2.isMany());
                }
                if (p2 instanceof SqlFunctionDefinition.ParameterBlock) {
                    return new SqlFunctionDefinition.ParameterBlock(p2.getPrototypeId(), ((SqlFunctionDefinition.ParameterBlock)p2).getBlockType(), Suffix.makeArrayParams(((SqlFunctionDefinition.ParameterBlock)p2).getParams()), p2.isMany());
                }
                return p2;
            }

            @Nullable
            static Suffix find(@NotNull String s) {
                if (s == null) {
                    Suffix.$$$reportNull$$$0(1);
                }
                for (Suffix suffix : Suffix.values()) {
                    if (!suffix.at(s)) continue;
                    return suffix;
                }
                return null;
            }

            static {
                COMMA = new SqlFunctionDefinition.SyntaxParameter(0, ",");
                COND = new SqlFunctionDefinition.SimpleParameter(0, "cond", INSTANCE.getBuiltInTypes().get("B"), false);
                STATE = new SqlFunctionDefinition.SimpleParameter(0, "state", AGGREGATE_FUNCTION, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeArrayParams";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "find";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CHouseTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SuffixedBuiltinFunctions();
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final List<ReservedEntity> ourObjects;
        static final List<ReservedEntity.Typed> RE_COLUMNS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{CHouseTypes.CH_DELIMITER_TOKEN})});
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, CHouseOptionalKeywords.CH_SOUNDS});
            ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
            RE_COLUMNS = Arrays.asList(new ReservedEntity.Typed("_part", ObjectKind.COLUMN, INSTANCE.stringType()), new ReservedEntity.Typed("_part_index", ObjectKind.COLUMN, INSTANCE.integerType()), new ReservedEntity.Typed("_sample_factor", ObjectKind.COLUMN, INSTANCE.realType()), new ReservedEntity.Typed("_table", ObjectKind.COLUMN, INSTANCE.stringType()));
        }
    }
}

