/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeBlockProvider
implements CodeBlockProvider {
    private static final TokenSet EXPAND = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_WHEN_CLAUSE, SqlCompositeElementTypes.SQL_CASE_WHEN_THEN_CLAUSE, SqlCompositeElementTypes.SQL_ELSE_CLAUSE, SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE});
    static final TokenSet STARTERS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCommonKeywords.SQL_IF, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_REPEAT, SqlCommonKeywords.SQL_FOR, SqlCommonKeywords.SQL_WHILE, SqlCommonKeywords.SQL_CASE});
    private static final Condition<PsiElement> STARTERS_C = e -> STARTERS.contains(PsiUtilCore.getElementType((PsiElement)e));
    private static final TokenSet EXTRA = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCommonKeywords.SQL_ELSE, SqlCommonKeywords.SQL_WHEN, SqlCommonKeywords.SQL_ELSIF, SqlCommonKeywords.SQL_ELSEIF});
    private static final Condition<PsiElement> EXTRA_C = e -> EXTRA.contains(PsiUtilCore.getElementType((PsiElement)e));
    private static final Condition<PsiElement> NOT_END_C = Conditions.or(EXTRA_C, STARTERS_C);
    private static final TokenSet ACTIVATORS = TokenSet.orSet((TokenSet[])new TokenSet[]{STARTERS, EXTRA, TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END})});

    @Nullable
    public TextRange getCodeBlockRange(Editor editor, PsiFile psiFile) {
        int at = editor.getCaretModel().getOffset();
        PsiElement block = this.findInitialBlock(psiFile, at);
        while (block != null) {
            TextRange range = SqlCodeBlockProvider.getBlockRange(block, at);
            if (range != null) {
                return range;
            }
            block = SqlCodeBlockProvider.findBlock(block.getParent());
        }
        return null;
    }

    @Nullable
    private static TextRange getBlockRange(@NotNull PsiElement block, int at) {
        if (block == null) {
            SqlCodeBlockProvider.$$$reportNull$$$0(0);
        }
        int from = -1;
        int to = -1;
        int last = -1;
        for (PsiElement e : SqlCodeBlockProvider.collectRanges(block)) {
            TextRange rg = e.getTextRange();
            if (last == -1 && at < rg.getStartOffset()) {
                return null;
            }
            if (from == -1 && STARTERS_C.value((Object)e)) {
                from = rg.getEndOffset();
            } else if (from != -1 && to == -1 && PsiUtilCore.getElementType((PsiElement)e) == SqlCommonKeywords.SQL_END) {
                to = rg.getStartOffset();
            }
            last = rg.getEndOffset();
        }
        return from == -1 || to == -1 || at > last + 1 ? null : TextRange.create((int)from, (int)to);
    }

    @Nullable
    public PsiElement findInitialBlock(PsiFile psiFile, int at) {
        PsiElement block1 = SqlCodeBlockProvider.findBlock(psiFile.findElementAt(at));
        PsiElement block2 = at == 0 ? null : SqlCodeBlockProvider.findBlock(psiFile.findElementAt(at - 1));
        return block1 == null || block2 != null && PsiTreeUtil.isAncestor((PsiElement)block1, (PsiElement)block2, (boolean)true) ? block2 : block1;
    }

    @Nullable
    private static PsiElement findBlock(@Nullable PsiElement element2) {
        return element2 == null ? null : (PsiElement)SqlImplUtil.sqlParents(element2).find(e -> SqlCodeBlockProvider.isGoodBlock(e));
    }

    public static JBIterable<PsiElement> processBlock(PsiFile file, int at) {
        PsiElement block;
        PsiElement element2 = file.findElementAt(at);
        IElementType type = PsiUtilCore.getElementType((PsiElement)element2);
        if (type != null && ACTIVATORS.contains(type) && SqlCodeBlockProvider.isGoodBlock(block = SqlCodeBlockProvider.getBlock(element2))) {
            if (type == SqlCommonKeywords.SQL_END && !SqlCodeBlockProvider.isLastEnd(block, element2)) {
                return JBIterable.of((Object)element2);
            }
            return SqlCodeBlockProvider.collectRanges(block);
        }
        return JBIterable.empty();
    }

    private static PsiElement getBlock(PsiElement element2) {
        boolean expanded = false;
        for (PsiElement e : SqlImplUtil.sqlParents(element2)) {
            if (e == element2) continue;
            boolean expand2 = EXPAND.contains(PsiUtilCore.getElementType((PsiElement)e));
            expanded |= expand2;
            if (expand2) continue;
            if (expanded && e instanceof SqlBlockStatementImpl) {
                return null;
            }
            return e;
        }
        return null;
    }

    private static SyntaxTraverser<PsiElement> childrenOfBlock(PsiElement block, boolean rev) {
        return (SyntaxTraverser)(rev ? SqlImplUtil.sqlRevTraverser(block) : SqlImplUtil.sqlTraverser(block)).expandAndSkip(e -> e == block || !(block instanceof SqlBlockStatementImpl) && EXPAND.contains(PsiUtilCore.getElementType((PsiElement)e)));
    }

    private static JBIterable<PsiElement> collectRanges(@NotNull PsiElement block) {
        if (block == null) {
            SqlCodeBlockProvider.$$$reportNull$$$0(1);
        }
        PsiElement end = SqlCodeBlockProvider.findEnd((JBIterable<PsiElement>)SqlCodeBlockProvider.childrenOfBlock(block, true).traverse());
        JBIterable allChildren = SqlCodeBlockProvider.childrenOfBlock(block, false).traverse();
        JBIterable fromStarter = allChildren.skipWhile(Conditions.not(STARTERS_C));
        if (end == null) {
            return fromStarter.skipWhile(Conditions.not(STARTERS_C)).filter(NOT_END_C);
        }
        JBIterable res2 = fromStarter.takeWhile(e -> e != end).filter(NOT_END_C);
        PsiElement f = (PsiElement)res2.first();
        if (f != null && f.getTextRange().getStartOffset() > end.getTextRange().getStartOffset()) {
            res2 = JBIterable.empty();
        }
        return res2.append((Object)end).append((Iterable)allChildren.skipWhile(e -> e != end).filter(NOT_END_C));
    }

    @Contract(value="null->false")
    private static boolean isGoodBlock(PsiElement block) {
        return block instanceof SqlBlockStatementImpl || block instanceof SqlIfStatement || PsiUtilCore.getElementType((PsiElement)block) == SqlCompositeElementTypes.SQL_CASE_STATEMENT || block instanceof SqlCaseExpression || block instanceof SqlLoopStatement || block instanceof LazyParseablePsiElement || block instanceof SqlFile;
    }

    private static boolean isLastEnd(PsiElement block, PsiElement element2) {
        TextRange rest = TextRange.create((int)element2.getTextRange().getEndOffset(), (int)block.getTextRange().getEndOffset());
        return SqlCodeBlockProvider.findEnd(SqlCodeBlockProvider.childrenOnRange(block, rest)) == null;
    }

    private static PsiElement findEnd(JBIterable<PsiElement> elements) {
        return (PsiElement)elements.find(e -> PsiUtilCore.getElementType((PsiElement)e) == SqlCommonKeywords.SQL_END);
    }

    @NotNull
    private static JBIterable<PsiElement> childrenOnRange(PsiElement element2, TextRange range) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlCodeBlockProvider.childrenOfBlock(element2, true).onRange(e -> e.getTextRange().intersectsStrict(range))).traverse();
        if (jBIterable == null) {
            SqlCodeBlockProvider.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlCodeBlockProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlCodeBlockProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOnRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBlockRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectRanges";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

