/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.SqlDialects;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement;
        PsiFile file;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = file = (psiElement = node.getPsi()) == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(file instanceof SqlFile)) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (Boolean.TRUE.equals(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION))) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        if (file.getTextLength() < 1024 && SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlStatement.class).isEmpty()) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        CodeStyleSettings css = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings((PsiElement)file);
        if (css == null) {
            css = CodeStyle.getSettings((PsiFile)file);
        }
        if (language == SqlDialects.getGenericDialect() || ((SqlCodeStyleSettings)css.getCustomSettings(SqlCodeStyleSettings.class)).DISABLE_FORMATTING) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        MyFormatter formatter = new MyFormatter(psiElement, language);
        TextRange textRange = formatter.process(range);
        if (textRange == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    private static CodeStyleSettings getDefaultCodeStyleSettings(@NotNull Project project) {
        if (project == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(7);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (codeStyleSettings == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(8);
        }
        return codeStyleSettings;
    }

    @Nullable
    private static PsiElement[] findSubSequence(@Nullable PsiElement begin, Predicate<PsiElement> ... predicates) {
        if (predicates == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(9);
        }
        int n = predicates.length;
        PsiElement[] found = new PsiElement[n];
        PsiElement p2 = SqlPreFormatProcessor.skipSpaces(begin);
        while (p2 != null) {
            boolean ok;
            PsiElement q = p2;
            for (int i2 = 0; i2 < n && (ok = predicates[i2].test(q)); ++i2) {
                found[i2] = q;
                if (i2 == n - 1) {
                    return found;
                }
                if ((q = SqlPreFormatProcessor.skipSpaces(q.getNextSibling())) == null) break;
            }
            p2 = SqlPreFormatProcessor.skipSpaces(p2.getNextSibling());
        }
        return null;
    }

    @Nullable
    private static PsiElement skipSpaces(@Nullable PsiElement element2) {
        PsiElement e = element2;
        while (e instanceof PsiWhiteSpace) {
            e = e.getNextSibling();
        }
        return e;
    }

    private static void applyChanges(List<Change> changes, PairProcessor<TextRange, String> processor) {
        for (Change change : changes) {
            TextRange range = new TextRange(change.from, change.till);
            String str = change.replacement != null ? change.replacement : "";
            processor.process((Object)range, (Object)str);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCodeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCodeStyleSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSubSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFormatter {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final PsiElement myElement;
        @NotNull
        protected final PsiDocumentManager myDocumentManager;
        @NotNull
        protected final SqlLanguageDialectEx myLanguage;
        @NotNull
        private final DatabaseDialectEx myDialect;
        @Nullable
        protected final Document myDocument;
        protected final SqlCodeStyleSettings mySqlCodeStyleSettings;

        MyFormatter(@NotNull PsiElement element2, @NotNull SqlLanguageDialectEx language) {
            if (element2 == null) {
                MyFormatter.$$$reportNull$$$0(0);
            }
            if (language == null) {
                MyFormatter.$$$reportNull$$$0(1);
            }
            this.myLanguage = language;
            this.myDialect = language.getDatabaseDialect();
            this.myProject = element2.getProject();
            this.myElement = element2;
            CodeStyleSettings css = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings(element2);
            if (css == null) {
                css = CodeStyle.getSettings((PsiFile)element2.getContainingFile());
            }
            this.mySqlCodeStyleSettings = (SqlCodeStyleSettings)css.getCustomSettings(SqlCodeStyleSettings.class);
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file = element2.getContainingFile();
            Document hardRef = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY);
            this.myDocument = hardRef != null ? hardRef : (ApplicationManager.getApplication().isReadAccessAllowed() ? file.getViewProvider().getDocument() : null);
        }

        @NotNull
        private TextRange process(final @NotNull TextRange range) {
            if (range == null) {
                MyFormatter.$$$reportNull$$$0(2);
            }
            if (this.myDocument == null || this.mySqlCodeStyleSettings == null) {
                TextRange textRange = range;
                if (textRange == null) {
                    MyFormatter.$$$reportNull$$$0(3);
                }
                return textRange;
            }
            if (PostprocessReformattingAspect.getInstance((Project)this.myProject).isDisabled()) {
                TextRange textRange = range;
                if (textRange == null) {
                    MyFormatter.$$$reportNull$$$0(4);
                }
                return textRange;
            }
            final ArrayList keywords = ContainerUtil.newArrayList();
            final ArrayList types = ContainerUtil.newArrayList();
            final ArrayList identifiers = ContainerUtil.newArrayList();
            final ArrayList selects = ContainerUtil.newArrayList();
            ArrayList changes = ContainerUtil.newArrayList();
            final List readOnlyFragments = this.myDocument instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.myProject).getNonEditableFragments((DocumentWindow)this.myDocument) : ContainerUtil.emptyList();
            this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.process(element2);
                    if (element2 instanceof IsExternal) {
                        this.process(element2.getFirstChild());
                        return;
                    }
                    super.visitElement(element2);
                }

                public void process(@Nullable PsiElement element2) {
                    TextRange nodeRange;
                    if (element2 == null) {
                        return;
                    }
                    IElementType elementType = PsiUtilCore.getElementType((PsiElement)element2);
                    if (elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE) {
                        selects.add(element2);
                    }
                    if (range.intersects(nodeRange = element2.getNode().getTextRange()) && !this.intersect(readOnlyFragments, nodeRange)) {
                        boolean parameter;
                        boolean isKeyword = element2.getNode().getElementType() instanceof SqlKeywordTokenType;
                        PsiElement parent2 = element2.getParent();
                        boolean isRemapped = parent2 instanceof SqlIdentifier;
                        ASTNode parentNode = parent2 != null ? parent2.getNode() : null;
                        IElementType parentType = parentNode != null ? parentNode.getElementType() : null;
                        PsiElement gradnpa = parent2 instanceof SqlReferenceExpression ? parent2.getParent() : null;
                        ASTNode grandpaNode = gradnpa == null ? null : gradnpa.getNode();
                        IElementType grandpaType = grandpaNode != null ? grandpaNode.getElementType() : null;
                        boolean insideSpecialLiteral = parentType == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && !"null".equalsIgnoreCase(element2.getText());
                        boolean functionName = parentType == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE || parentType == SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE || grandpaType == SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                        boolean bl = parameter = parentType == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
                        if (isKeyword && !isRemapped && !insideSpecialLiteral) {
                            if (element2.getParent() instanceof SqlTypeElement) {
                                types.add(nodeRange);
                            } else {
                                keywords.add(nodeRange);
                            }
                        } else {
                            boolean identifier = element2 instanceof SqlIdentifier;
                            boolean asterisk = "*".equals(element2.getText());
                            if (!(!identifier || functionName || parameter || range.getLength() <= 1 && asterisk)) {
                                if (parentType == SqlCompositeElementTypes.SQL_TYPE_REFERENCE) {
                                    types.add(nodeRange);
                                } else {
                                    identifiers.add((SqlIdentifier)element2);
                                }
                            }
                        }
                    }
                }

                private boolean intersect(@NotNull List<TextRange> trs, @NotNull TextRange r) {
                    if (trs == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (r == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    for (TextRange tr : trs) {
                        if (!tr.intersects(r)) continue;
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "trs";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "r";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "intersect";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            if (!keywords.isEmpty()) {
                start = Math.min(start, ((TextRange)keywords.get(0)).getStartOffset());
                end = Math.max(end, ((TextRange)keywords.get(keywords.size() - 1)).getEndOffset());
            }
            if (!identifiers.isEmpty()) {
                start = Math.min(start, ((SqlIdentifier)identifiers.get(0)).getTextRange().getStartOffset());
                end = Math.max(end, ((SqlIdentifier)identifiers.get(identifiers.size() - 1)).getTextRange().getEndOffset());
            }
            TextRange fixedRange = new TextRange(start, end);
            CharSequence charSequence = this.myDocument.getCharsSequence();
            this.processSelects(selects, changes);
            int[] delta = new int[]{0};
            DocumentUtil.executeInBulk((Document)this.myDocument, (boolean)true, () -> {
                PairProcessor processor = (range1, s) -> {
                    TextRange shifted = TextRange.create((int)(range1.getStartOffset() + delta[0]), (int)(range1.getEndOffset() + delta[0]));
                    String text2 = this.myDocument.getText(shifted);
                    if (text2.equals(s)) {
                        return true;
                    }
                    if (this.myDocument.getRangeGuard(shifted.getStartOffset(), shifted.getEndOffset()) != null) {
                        return true;
                    }
                    this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), (CharSequence)s);
                    delta[0] = delta[0] + (s.length() - range1.getLength());
                    return true;
                };
                this.processKeywords(keywords, charSequence, (PairProcessor<TextRange, String>)processor);
                this.processTypes(types, charSequence, (PairProcessor<TextRange, String>)processor);
                this.processIdentifiers(identifiers, (PairProcessor<TextRange, String>)processor);
                SqlPreFormatProcessor.applyChanges(changes, (PairProcessor<TextRange, String>)processor);
            });
            if (this.myDocumentManager.isUncommited(this.myDocument)) {
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            TextRange textRange = fixedRange.grown(delta[0]);
            if (textRange == null) {
                MyFormatter.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private void processSelects(@NotNull List<PsiElement> selects, @NotNull List<Change> changes) {
            String AS;
            if (selects == null) {
                MyFormatter.$$$reportNull$$$0(6);
            }
            if (changes == null) {
                MyFormatter.$$$reportNull$$$0(7);
            }
            boolean comma1st = this.mySqlCodeStyleSettings.SELECT_EL_COMMA == 1;
            boolean commaLast = this.mySqlCodeStyleSettings.SELECT_EL_COMMA == 2;
            boolean processCommas = comma1st || commaLast;
            int useAsWord = this.mySqlCodeStyleSettings.SELECT_USE_AS_WORD;
            switch (this.mySqlCodeStyleSettings.KEYWORD_CASE) {
                case 0: {
                    AS = "AS";
                    break;
                }
                case 1: {
                    AS = "as";
                    break;
                }
                default: {
                    AS = null;
                }
            }
            for (PsiElement select : selects) {
                PsiElement[] s;
                if (useAsWord > 0) {
                    for (PsiElement e = select.getFirstChild(); e != null; e = e.getNextSibling()) {
                        if (PsiUtilCore.getElementType((PsiElement)e) != SqlCompositeElementTypes.SQL_AS_EXPRESSION) continue;
                        if (useAsWord == 1) {
                            String word;
                            s = SqlPreFormatProcessor.findSubSequence(e.getFirstChild(), new Predicate[]{x -> x instanceof SqlExpression, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER});
                            if (s == null) continue;
                            String string = AS != null ? AS : (word = MyFormatter.whetherKeywordsUpper(select) ? "AS" : "as");
                            assert (s.length == 2);
                            changes.add(Change.insert(s[1].getTextRange().getStartOffset(), word + ' '));
                            continue;
                        }
                        if (useAsWord != 2 || (s = SqlPreFormatProcessor.findSubSequence(e.getFirstChild(), new Predicate[]{x -> x instanceof SqlExpression, z -> PsiUtilCore.getElementType((PsiElement)z) == SqlCommonKeywords.SQL_AS, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER})) == null) continue;
                        assert (s.length == 3);
                        TextRange r = s[1].getTextRange();
                        changes.add(Change.delete(r.getStartOffset(), r.getEndOffset()));
                    }
                }
                if (!processCommas) continue;
                PsiElement begin = select.getFirstChild();
                if (comma1st) {
                    while (begin != null && (s = SqlPreFormatProcessor.findSubSequence(begin, new Predicate[]{element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_COMMA, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> element2 instanceof SqlExpression})) != null) {
                        assert (s.length == 4);
                        changes.add(Change.delete(s[1].getTextRange()));
                        changes.add(Change.insertAfter(s[2].getTextRange(), "\n,"));
                        begin = s[3];
                    }
                }
                if (!commaLast) continue;
                while (begin != null && (s = SqlPreFormatProcessor.findSubSequence(begin, new Predicate[]{element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_COMMA, element2 -> element2 instanceof SqlExpression})) != null) {
                    assert (s.length == 4);
                    changes.add(Change.insertBefore(s[1].getTextRange(), ", "));
                    changes.add(Change.delete(s[2].getTextRange()));
                    begin = s[3];
                }
            }
        }

        private static boolean whetherKeywordsUpper(PsiElement select) {
            PsiElement e;
            PsiElement kw = select;
            while ((e = kw.getFirstChild()) != null) {
                kw = e;
            }
            String text2 = kw.getText();
            if (text2 == null || text2.length() < 2) {
                return false;
            }
            return Character.isUpperCase(text2.charAt(1));
        }

        private void processKeywords(List<TextRange> keywords, CharSequence charSequence, PairProcessor<TextRange, String> processor) {
            MyFormatter.processRanges(keywords, charSequence, processor, SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.KEYWORD_CASE));
        }

        private void processTypes(List<TextRange> types, CharSequence charSequence, PairProcessor<TextRange, String> processor) {
            Case casing = this.isExactCasedDialect() ? Case.EXACT : this.mySqlCodeStyleSettings.getCaseModeExt(this.mySqlCodeStyleSettings.TYPE_CASE);
            MyFormatter.processRanges(types, charSequence, processor, casing);
        }

        private static void processRanges(List<TextRange> ranges, CharSequence charSequence, PairProcessor<TextRange, String> processor, Case mode) {
            if (mode == Case.MIXED) {
                return;
            }
            for (TextRange range : ranges) {
                String text2 = charSequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
                String newText = mode.apply(text2);
                processor.process((Object)range, (Object)newText);
            }
        }

        private void processIdentifiers(List<SqlIdentifier> identifiers, PairProcessor<TextRange, String> processor) {
            Case quotedMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.QUOTED_IDENTIFIER_CASE);
            Case plainMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.IDENTIFIER_CASE);
            if (this.isExactCasedDialect()) {
                plainMode = Case.EXACT;
            }
            if (quotedMode == Case.MIXED && plainMode == Case.MIXED && this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 2) {
                return;
            }
            for (SqlIdentifier psi : identifiers) {
                String newText;
                boolean isQuoted = !psi.isPlainIdentifier();
                String identifierName = psi.getName();
                String prefix = psi.getNamePrefix();
                String text2 = psi.getText();
                if (this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 0 && !isQuoted) {
                    newText = this.myDialect.quoteIdentifier(identifierName, true, false);
                    newText = quotedMode.apply(newText);
                } else {
                    newText = this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 1 && isQuoted ? (SqlImplUtil.canUnquote(identifierName, this.myDialect) ? plainMode.apply(identifierName) : quotedMode.apply(text2)) : (isQuoted ? quotedMode : plainMode).apply(prefix == null ? text2 : text2.replaceFirst(prefix, ""));
                }
                if (newText == null) continue;
                if (prefix != null) {
                    newText = prefix + newText;
                }
                TextRange range = psi.getTextRange();
                processor.process((Object)range, (Object)newText);
            }
        }

        private boolean isExactCasedDialect() {
            Casing casing = this.myDialect.getCasing(ObjectKind.NONE, null);
            return casing.plain == Case.EXACT;
        }

        private void unblockDocument() {
            this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selects";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processSelects";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Change {
        final int from;
        final int till;
        @Nullable
        final String replacement;

        @NotNull
        static Change insert(int position, @NotNull String text2) {
            if (text2 == null) {
                Change.$$$reportNull$$$0(0);
            }
            Change change = new Change(position, position, text2);
            if (change == null) {
                Change.$$$reportNull$$$0(1);
            }
            return change;
        }

        @NotNull
        static Change insertBefore(@NotNull TextRange range, @NotNull String text2) {
            if (range == null) {
                Change.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                Change.$$$reportNull$$$0(3);
            }
            Change change = Change.insert(range.getStartOffset(), text2);
            if (change == null) {
                Change.$$$reportNull$$$0(4);
            }
            return change;
        }

        @NotNull
        static Change insertAfter(@NotNull TextRange range, @NotNull String text2) {
            if (range == null) {
                Change.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                Change.$$$reportNull$$$0(6);
            }
            Change change = Change.insert(range.getEndOffset(), text2);
            if (change == null) {
                Change.$$$reportNull$$$0(7);
            }
            return change;
        }

        @NotNull
        static Change replace(int from, int till, @NotNull String text2) {
            if (text2 == null) {
                Change.$$$reportNull$$$0(8);
            }
            Change change = new Change(from, till, text2);
            if (change == null) {
                Change.$$$reportNull$$$0(9);
            }
            return change;
        }

        @NotNull
        static Change delete(int from, int till) {
            Change change = new Change(from, till, null);
            if (change == null) {
                Change.$$$reportNull$$$0(10);
            }
            return change;
        }

        @NotNull
        static Change delete(@NotNull TextRange range) {
            if (range == null) {
                Change.$$$reportNull$$$0(11);
            }
            Change change = Change.delete(range.getStartOffset(), range.getEndOffset());
            if (change == null) {
                Change.$$$reportNull$$$0(12);
            }
            return change;
        }

        private Change(int from, int till, @Nullable String replacement) {
            this.from = from;
            this.till = till;
            this.replacement = replacement;
        }

        public String toString() {
            return Integer.toString(this.from) + ':' + this.till + (this.replacement == null ? " -X-" : " <- " + this.replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor$Change";
                    break;
                }
                case 2: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor$Change";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertBefore";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertAfter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "delete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "insertBefore";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "insertAfter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "delete";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

