/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.SqlSpacing;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0002*\u00020\rH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"WORD_CATEGORY_CHARS", "", "", "languageRequiresSpaceBetween", "", "node1", "Lcom/intellij/lang/ASTNode;", "node2", "languageRequiresSpaceBetweenLeafNodes", "languageRequiresSpacesBetweenChars", "c1", "c2", "safeFirst", "", "safeLast", "intellij.database.sql.impl"})
@JvmName(name="SqlSpacing")
public final class SqlSpacing {
    private static final Set<Character> WORD_CATEGORY_CHARS = SetsKt.setOf((Object[])new Character[]{Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('`'), Character.valueOf('$')});

    public static final boolean languageRequiresSpaceBetween(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkParameterIsNotNull((Object)node1, (String)"node1");
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node2");
        ASTNode leaf1 = SqlUtilFun.lastLeaf(node1);
        ASTNode leaf2 = SqlUtilFun.firstLeaf(node2);
        return SqlSpacing.languageRequiresSpaceBetweenLeafNodes(leaf1, leaf2);
    }

    public static final boolean languageRequiresSpaceBetweenLeafNodes(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkParameterIsNotNull((Object)node1, (String)"node1");
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node2");
        String string = node1.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node1.text");
        char c1 = SqlSpacing.safeLast(string);
        String string2 = node2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node2.text");
        char c2 = SqlSpacing.safeFirst(string2);
        if (CharsKt.isWhitespace((char)c1) || CharsKt.isWhitespace((char)c2)) {
            return false;
        }
        return SqlSpacing.languageRequiresSpacesBetweenChars(c1, c2);
    }

    private static final boolean languageRequiresSpacesBetweenChars(char c1, char c2) {
        languageRequiresSpacesBetweenChars.1 isWordCategory$ = languageRequiresSpacesBetweenChars.1.INSTANCE;
        return isWordCategory$.invoke(c1) && isWordCategory$.invoke(c2);
    }

    private static final char safeFirst(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        return charSequence.length() > 0 ? $receiver.charAt(0) : (char)'\u0000';
    }

    private static final char safeLast(@NotNull String $receiver) {
        int n = $receiver.length();
        return n > 0 ? $receiver.charAt(n - 1) : (char)'\u0000';
    }

    @NotNull
    public static final /* synthetic */ Set access$getWORD_CATEGORY_CHARS$p() {
        return WORD_CATEGORY_CHARS;
    }
}

