/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "()V", "countOfElements", "", "getCountOfElements", "()I", "setCountOfElements", "(I)V", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "userRequiresExpand", "", "intellij.database.sql.impl"})
public final class SqlAlterTableBlock
extends SqlDdlStatementBlock {
    private int countOfElements;

    public final int getCountOfElements() {
        return this.countOfElements;
    }

    public final void setCountOfElements(int n) {
        this.countOfElements = n;
    }

    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION)) ? BlockRole.ELEMENT : super.determineRole$intellij_database_sql_impl(node);
    }

    @Override
    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_impl(role);
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        Object a;
        boolean toAlign;
        boolean toWrap = this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 1;
        boolean bl = toAlign = this.getContext().getSql().TABLE_ALTER_INSTRUCTION_ALIGN && this.countOfElements >= 2;
        if (toWrap || toAlign) {
            Wrap w = toWrap ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.ALWAYS, false, 2, null) : null;
            a = toAlign ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
            Iterable $receiver$iv = this.getNestedBlocks();
            Iterable $receiver$iv$iv = $receiver$iv;
            JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable2 = jBIterable.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
            $receiver$iv = (Iterable)jBIterable2;
            for (Object element$iv : $receiver$iv) {
                SqlAlterInstructionBlock it = (SqlAlterInstructionBlock)element$iv;
                it.setMyWrap(w);
                it.setMyAlign((Alignment)a);
            }
        }
        if (this.getContext().getSql().TABLE_TYPES_ALIGN) {
            Iterable $receiver$iv;
            Alignment columnTypeAlignment = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            a = this.getNestedBlocks();
            Iterable $receiver$iv$iv = $receiver$iv;
            JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable3 = jBIterable.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable4 = jBIterable3.flatten((Function)configureFormattingAttributes.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            $receiver$iv = (Iterable)jBIterable4;
            $receiver$iv$iv = $receiver$iv;
            JBIterable jBIterable5 = JBIterable.from((Iterable)$receiver$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable5, (String)"JBIterable.from(this)");
            JBIterable jBIterable6 = jBIterable5.filter(SqlColumnBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable6, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable7 = jBIterable6.flatten((Function)configureFormattingAttributes.3.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable7, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            JBIterable<SqlBlock> jBIterable8 = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable7), BlockRole.ESSENCE);
            Intrinsics.checkExpressionValueIsNotNull(jBIterable8, (String)"nestedBlocks\n        .fi\u2026filter(BlockRole.ESSENCE)");
            $receiver$iv = (Iterable)jBIterable8;
            for (Object element$iv : $receiver$iv) {
                SqlBlock it = (SqlBlock)element$iv;
                it.setMyAlign(columnTypeAlignment);
            }
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 1 || this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0;
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        return block2 instanceof SqlAlterInstructionBlock && this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0 ? this.getContext().makeAutoSpacing(true) : super.decideSpacing$intellij_database_sql_impl(block1, block2);
    }
}

