/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010$\u001a\u00020%*\u00020&\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\"\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0005\"\u001f\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000f0\u000f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0005\"\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000b\"\u0011\u0010\u001c\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000b\"\u0011\u0010 \u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0011\u0010\"\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000b\u00a8\u0006'"}, d2={"BLOCK_COMMENT_TYPES", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "getBLOCK_COMMENT_TYPES", "()Ljava/util/Set;", "COMMENT_TYPES", "getCOMMENT_TYPES", "LEFT_BRACE_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "getLEFT_BRACE_TOKENS", "()Lcom/intellij/psi/tree/TokenSet;", "LINE_COMMENT_TYPES", "getLINE_COMMENT_TYPES", "LITERAL_TYPES", "Lcom/intellij/psi/tree/IElementType;", "getLITERAL_TYPES", "MEANINGLESS_TYPES", "getMEANINGLESS_TYPES", "MUST_FOLLOWED_BY_NL_TYPES", "NONE_INDENT", "Lcom/intellij/formatting/Indent;", "getNONE_INDENT", "()Lcom/intellij/formatting/Indent;", "NORMAL_INDENT", "getNORMAL_INDENT", "RIGHT_BRACE_TOKENS", "getRIGHT_BRACE_TOKENS", "USUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS", "getUSUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS", "USUALLY_LEFT_CLOSELY_SPACES_TOKENS", "getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS", "USUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS", "getUSUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS", "USUALLY_RIGHT_CLOSELY_SPACES_TOKENS", "getUSUALLY_RIGHT_CLOSELY_SPACES_TOKENS", "usualRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.impl"})
public final class SqlFormattingFunKt {
    @NotNull
    private static final Set<IElementType> MEANINGLESS_TYPES = SetsKt.setOf((Object[])new IElementType[]{SqlTokens.SQL_WHITE_SPACE, (IElementType)SqlTokens.SQL_BLOCK_COMMENT, (IElementType)SqlTokens.SQL_LINE_COMMENT, (IElementType)SqlTokens.MYSQL_LINE_COMMENT, (IElementType)SqlTokens.ORAP_LINE_COMMENT, (IElementType)SqlTokens.ORAP_DELIMITER_TOKEN});
    @NotNull
    private static final Set<SqlTokenType> LINE_COMMENT_TYPES = SetsKt.setOf((Object[])new SqlTokenType[]{SqlTokens.SQL_LINE_COMMENT, SqlTokens.MYSQL_LINE_COMMENT, SqlTokens.ORAP_LINE_COMMENT});
    @NotNull
    private static final Set<SqlTokenType> BLOCK_COMMENT_TYPES = SetsKt.setOf((Object)SqlTokens.SQL_BLOCK_COMMENT);
    @NotNull
    private static final Set<SqlTokenType> COMMENT_TYPES = CollectionsKt.union((Iterable)LINE_COMMENT_TYPES, (Iterable)BLOCK_COMMENT_TYPES);
    @JvmField
    @NotNull
    public static final Set<IElementType> MUST_FOLLOWED_BY_NL_TYPES;
    @NotNull
    private static final Set<IElementType> LITERAL_TYPES;
    @NotNull
    private static final Indent NONE_INDENT;
    @NotNull
    private static final Indent NORMAL_INDENT;
    @NotNull
    private static final TokenSet LEFT_BRACE_TOKENS;
    @NotNull
    private static final TokenSet RIGHT_BRACE_TOKENS;
    @NotNull
    private static final TokenSet USUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS;
    @NotNull
    private static final TokenSet USUALLY_RIGHT_CLOSELY_SPACES_TOKENS;
    @NotNull
    private static final TokenSet USUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS;
    @NotNull
    private static final TokenSet USUALLY_LEFT_CLOSELY_SPACES_TOKENS;

    @NotNull
    public static final BlockRole usualRole(@NotNull ASTNode $receiver) {
        BlockRole blockRole;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IElementType iElementType = $receiver.getElementType();
        if (CollectionsKt.contains((Iterable)LINE_COMMENT_TYPES, (Object)iElementType)) {
            blockRole = BlockRole.LINE_COMMENT;
        } else if (CollectionsKt.contains((Iterable)BLOCK_COMMENT_TYPES, (Object)iElementType)) {
            blockRole = $receiver.textContains('\n') ? BlockRole.LARGE_COMMENT : BlockRole.TINY_COMMENT;
        } else if (LEFT_BRACE_TOKENS.contains(iElementType)) {
            blockRole = BlockRole.PREFIX;
        } else if (RIGHT_BRACE_TOKENS.contains(iElementType)) {
            blockRole = BlockRole.SUFFIX;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_COMMA) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_SEMICOLON)) {
            blockRole = BlockRole.DELIMITER;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_AS)) {
            blockRole = BlockRole.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_OP_ASSIGN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_OP_EQ)) {
            blockRole = BlockRole.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_OP_LT)) {
            ASTNode aSTNode = $receiver.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"this.treeParent");
            blockRole = aSTNode.getElementType() == SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST ? BlockRole.PREFIX : BlockRole.DELIMITER;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_OP_GT)) {
            ASTNode aSTNode = $receiver.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"this.treeParent");
            blockRole = aSTNode.getElementType() == SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST ? BlockRole.SUFFIX : BlockRole.DELIMITER;
        } else {
            ASTNode aSTNode;
            blockRole = Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT) ? BlockRole.TYPE : (iElementType instanceof SqlTokenType.Synthetic ? BlockRole.UNKNOWN : ((aSTNode = $receiver) instanceof PsiErrorElement ? BlockRole.ERROR : BlockRole.NOTHING));
        }
        return blockRole;
    }

    @NotNull
    public static final Set<IElementType> getMEANINGLESS_TYPES() {
        return MEANINGLESS_TYPES;
    }

    @NotNull
    public static final Set<SqlTokenType> getLINE_COMMENT_TYPES() {
        return LINE_COMMENT_TYPES;
    }

    @NotNull
    public static final Set<SqlTokenType> getBLOCK_COMMENT_TYPES() {
        return BLOCK_COMMENT_TYPES;
    }

    @NotNull
    public static final Set<SqlTokenType> getCOMMENT_TYPES() {
        return COMMENT_TYPES;
    }

    @NotNull
    public static final Set<IElementType> getLITERAL_TYPES() {
        return LITERAL_TYPES;
    }

    @NotNull
    public static final Indent getNONE_INDENT() {
        return NONE_INDENT;
    }

    @NotNull
    public static final Indent getNORMAL_INDENT() {
        return NORMAL_INDENT;
    }

    @NotNull
    public static final TokenSet getLEFT_BRACE_TOKENS() {
        return LEFT_BRACE_TOKENS;
    }

    @NotNull
    public static final TokenSet getRIGHT_BRACE_TOKENS() {
        return RIGHT_BRACE_TOKENS;
    }

    @NotNull
    public static final TokenSet getUSUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS() {
        return USUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS;
    }

    @NotNull
    public static final TokenSet getUSUALLY_RIGHT_CLOSELY_SPACES_TOKENS() {
        return USUALLY_RIGHT_CLOSELY_SPACES_TOKENS;
    }

    @NotNull
    public static final TokenSet getUSUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS() {
        return USUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS;
    }

    @NotNull
    public static final TokenSet getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS() {
        return USUALLY_LEFT_CLOSELY_SPACES_TOKENS;
    }

    static {
        Object[] objectArray = new IElementType[5];
        SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
        objectArray[0] = (IElementType)sqlTokenType;
        SqlTokenType sqlTokenType2 = SqlTokens.MYSQL_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType2, (String)"MYSQL_LINE_COMMENT");
        objectArray[1] = (IElementType)sqlTokenType2;
        SqlTokenType sqlTokenType3 = SqlTokens.ORAP_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType3, (String)"ORAP_LINE_COMMENT");
        objectArray[2] = (IElementType)sqlTokenType3;
        SqlTokenType sqlTokenType4 = SqlTokens.PG_COPY_TERMINATOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType4, (String)"SqlTokens.PG_COPY_TERMINATOR");
        objectArray[3] = (IElementType)sqlTokenType4;
        SqlTokenType sqlTokenType5 = SqlTokens.ORAP_SLASH_DELIMITER_TOKEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType5, (String)"SqlTokens.ORAP_SLASH_DELIMITER_TOKEN");
        objectArray[4] = (IElementType)sqlTokenType5;
        MUST_FOLLOWED_BY_NL_TYPES = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new IElementType[3];
        SqlTokenType sqlTokenType6 = SqlTokens.SQL_INTEGER_TOKEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType6, (String)"SQL_INTEGER_TOKEN");
        objectArray2[0] = (IElementType)sqlTokenType6;
        SqlTokenType sqlTokenType7 = SqlTokens.SQL_FLOAT_TOKEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType7, (String)"SQL_FLOAT_TOKEN");
        objectArray2[1] = (IElementType)sqlTokenType7;
        SqlTokenType sqlTokenType8 = SqlTokens.SQL_STRING_TOKEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType8, (String)"SQL_STRING_TOKEN");
        objectArray2[2] = (IElementType)sqlTokenType8;
        LITERAL_TYPES = SetsKt.setOf((Object[])objectArray2);
        Indent indent = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getNoneIndent()");
        NONE_INDENT = indent;
        Indent indent2 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"Indent.getNormalIndent()");
        NORMAL_INDENT = indent2;
        LEFT_BRACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_LEFT_BRACKET, (IElementType)SqlTokens.SQL_LEFT_BRACE});
        RIGHT_BRACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_BRACKET, (IElementType)SqlTokens.SQL_RIGHT_BRACE});
        USUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlTokens.SQL_PERIOD, (IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlTokens.SQL_DOUBLE_COLON, (IElementType)SqlTokens.SQL_ELLIPSES, (IElementType)SqlTokens.SQL_SEMICOLON});
        USUALLY_RIGHT_CLOSELY_SPACES_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{USUALLY_RIGHT_CLOSELY_SPACES_SYMBOL_TOKENS, RIGHT_BRACE_TOKENS});
        USUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlTokens.SQL_PERIOD, (IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlTokens.SQL_DOUBLE_COLON, (IElementType)SqlTokens.SQL_ELLIPSES});
        USUALLY_LEFT_CLOSELY_SPACES_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{USUALLY_LEFT_CLOSELY_SPACES_SYMBOL_TOKENS, LEFT_BRACE_TOKENS});
    }
}

