/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExpressionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/SqlFunctionCallBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlExpressionBlock;", "()V", "countOfElements", "", "getCountOfElements$intellij_database_sql_impl", "()I", "setCountOfElements$intellij_database_sql_impl", "(I)V", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "whetherToFlatten", "", "intellij.database.sql.impl"})
public final class SqlFunctionCallBlock
extends SqlNodeBlock
implements SqlExpressionBlock {
    private int countOfElements;

    public final int getCountOfElements$intellij_database_sql_impl() {
        return this.countOfElements;
    }

    public final void setCountOfElements$intellij_database_sql_impl(int n) {
        this.countOfElements = n;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return node.getElementType() == SqlElementTypes.SQL_EXPRESSION_LIST;
    }

    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node.getElementType() == SqlElementTypes.SQL_ANY_CALLABLE_REFERENCE) {
            return BlockRole.ESSENCE;
        }
        BlockRole r = super.determineRole$intellij_database_sql_impl(node);
        if (r == BlockRole.NOTHING) {
            r = BlockRole.ELEMENT;
        }
        return r;
    }

    @Override
    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        if (this.countOfElements == 0) {
            return;
        }
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.NORMAL, false, 2, null);
        Indent i2 = Indent.getContinuationIndent();
        Alignment a = this.countOfElements >= 2 ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        JBIterable<SqlBlock> jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"nestedBlocks.filter(ELEMENT)");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            SqlBlock it = (SqlBlock)element$iv;
            it.setMyWrap(w);
            it.setMyIndent(i2);
            it.setMyAlign(a);
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        IElementType t1 = SqlFormattingModelFunKt.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFunKt.primaryElementType(block2);
        return t2 == SqlElementTypes.SQL_LEFT_PAREN ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (t1 == SqlElementTypes.SQL_LEFT_PAREN || t2 == SqlElementTypes.SQL_RIGHT_PAREN ? this.getContext().makeSpace(this.getContext().getSql().EXPR_CALL_SPACE_INSIDE_PARENTHESES) : (t2 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(this.getContext().getSql().EXPR_CALL_SPACE_BEFORE_COMMA) : (t1 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(this.getContext().getSql().EXPR_CALL_SPACE_AFTER_COMMA) : super.decideSpacing$intellij_database_sql_impl(block1, block2))));
    }
}

