/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedSubqueryItemInspection;
import com.intellij.sql.inspections.SqlUnusedVariableInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedSubqueryItemInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "getDisplayName", "", "intellij.database.sql.impl"})
public final class SqlUnusedSubqueryItemInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.unused.subquery.item", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SqlMessages.message(\"ins\u2026me.unused.subquery.item\")");
        return string;
    }

    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                List expressionList;
                SqlExpression fromExpression;
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                SqlSelectClause selectClause = o.getSelectClause();
                if (selectClause == null) {
                    return;
                }
                boolean hasNoArgAggregate = false;
                Iterator<E> iterator = selectClause.getExpressions().iterator();
                while (iterator.hasNext()) {
                    SqlExpressionList parameterList;
                    SqlExpression expression;
                    SqlExpression sqlExpression = expression = (SqlExpression)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"expression");
                    if (this.isStarReference(sqlExpression)) {
                        return;
                    }
                    if (!(expression instanceof SqlFunctionCallExpression) || (parameterList = ((SqlFunctionCallExpression)expression).getParameterList()) == null || parameterList.getExpressionList().size() != 0) continue;
                    hasNoArgAggregate = true;
                }
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                SqlExpression sqlExpression = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : (fromExpression = null);
                if (fromExpression instanceof SqlAsExpression) {
                    fromExpression = ((SqlAsExpression)fromExpression).getExpression();
                }
                while (fromExpression instanceof SqlParenthesizedExpression && (expressionList = ((SqlParenthesizedExpression)fromExpression).getExpressionList()).size() == 1) {
                    fromExpression = (SqlExpression)expressionList.get(0);
                }
                List expressionBranches = ContainerUtil.emptyList();
                while (fromExpression instanceof SqlNAryExpression) {
                    if (expressionBranches.isEmpty()) {
                        expressionBranches = ContainerUtil.newArrayList();
                    }
                    List list = ((SqlNAryExpression)fromExpression).getOperands();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"fromExpression.operands");
                    expressionBranches.addAll(list);
                    fromExpression = ((SqlNAryExpression)fromExpression).getLOperand();
                }
                if (fromExpression instanceof SqlQueryExpression) {
                    SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)fromExpression;
                    SearchScope searchScope = (SearchScope)new LocalSearchScope((PsiElement)o);
                    List list = expressionBranches;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expressionBranches");
                    this.inspectQueryExpression(sqlQueryExpression, searchScope, list, hasNoArgAggregate);
                }
                super.visitSqlQueryExpression(o);
            }

            private final boolean isStarReference(SqlExpression expression) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)expression).filter(SqlReferenceExpression.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil.sqlTraverser\u2026ceExpression::class.java)");
                    Iterable $receiver$iv = (Iterable)jBIterable;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            SqlReferenceExpression e;
                            SqlReferenceExpression sqlReferenceExpression = e = (SqlReferenceExpression)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"e");
                            if (!Intrinsics.areEqual((Object)"*", (Object)sqlReferenceExpression.getName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectQueryExpression(SqlQueryExpression o, SearchScope searchScope, List<? extends SqlExpression> expressionBranches, boolean hasNoArgAggregate) {
                SqlSelectClause sqlSelectClause = o.getSelectClause();
                if (sqlSelectClause == null) {
                    return;
                }
                SqlSelectClause selectClause = sqlSelectClause;
                List expressions = selectClause.getExpressions();
                if (expressions.size() == 1 && hasNoArgAggregate) {
                    return;
                }
                for (SqlExpression expression : expressions) {
                    if (expression instanceof SqlAsExpression) {
                        this.reportErrorForName(expression, this.getErrorElementName(o, (PsiElement)expression, expression, expressionBranches, searchScope, true));
                    }
                    if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) continue;
                    if (this.isStarReference(expression)) {
                        this.validateStarReference(o, expression, expressionBranches, searchScope);
                        continue;
                    }
                    PsiElement element2 = ((SqlReferenceExpression)expression).resolve();
                    if (element2 == null) continue;
                    this.reportErrorForName(expression, this.getErrorElementName(o, element2, expression, expressionBranches, searchScope, false));
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void validateStarReference(SqlQueryExpression o, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope searchScope) {
                SqlTableType sqlType;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                Object object = sqlType = sqlTableExpression != null ? sqlTableExpression.getSqlType() : null;
                if (sqlType == null || sqlType instanceof SqlTableTypeBase.Empty) {
                    return;
                }
                HashSet unusedNames = ContainerUtil.newHashSet((int)sqlType.getColumnCount());
                HashSet usedNames = ContainerUtil.newHashSet((int)sqlType.getColumnCount());
                int n = 0;
                int n2 = sqlType.getColumnCount();
                if (n <= n2) {
                    while (true) {
                        void index2;
                        try {
                            PsiElement element2 = sqlType.getColumnElement((int)index2);
                            String name = this.getErrorElementName(o, element2, expression, expressionBranches, searchScope, false);
                            if (name != null) {
                                unusedNames.add(name);
                            } else {
                                usedNames.add(sqlType.getColumnName((int)index2));
                            }
                        }
                        catch (Throwable e) {
                            return;
                        }
                        if (index2 == n2) break;
                        ++index2;
                    }
                }
                if (unusedNames.isEmpty()) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlMessages.message("subquery.item.star.includes.unused", unusedNames.stream().map(createAnnotationVisitor.validateStarReference.1.INSTANCE).collect(Collectors.joining(", ")), "select " + StringUtil.join((Collection)usedNames, (String)", ")), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final String getErrorElementName(SqlQueryExpression inspected, PsiElement element2, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope scope, boolean isAlias) {
                if (SqlUnusedVariableInspection.foundAnyRefs(element2, (Condition<? super PsiElement>)((Condition)new Condition<PsiElement>(this, expression, expressionBranches, inspected, isAlias){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ SqlExpression $expression;
                    final /* synthetic */ List $expressionBranches;
                    final /* synthetic */ SqlQueryExpression $inspected;
                    final /* synthetic */ boolean $isAlias;

                    public final boolean value(PsiElement it) {
                        PsiElement psiElement = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                        return createAnnotationVisitor.1.access$hasOnlyLocalRefs(this.this$0, psiElement, this.$expression, this.$expressionBranches) ? true : createAnnotationVisitor.1.access$hasOnlyInnerUsages(this.this$0, this.$inspected, it, this.$isAlias);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$expression = sqlExpression;
                        this.$expressionBranches = list;
                        this.$inspected = sqlQueryExpression;
                        this.$isAlias = bl;
                    }
                }), scope)) {
                    return null;
                }
                PsiElement psiElement = element2;
                if (!(psiElement instanceof PsiNamedElement)) {
                    psiElement = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                return psiNamedElement != null ? psiNamedElement.getName() : null;
            }

            private final void reportErrorForName(SqlExpression expression, String name) {
                if (name == null) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlMessages.message("subquery.item.never.used", name), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final boolean hasOnlyInnerUsages(SqlQueryExpression inspected, PsiElement it, boolean isAlias) {
                if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)inspected), (PsiElement)it, (boolean)true)) {
                    return false;
                }
                SqlSelectClause selectClause = inspected.getSelectClause();
                if (selectClause == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)it, (boolean)true)) {
                    return !isAlias;
                }
                return PsiTreeUtil.getParentOfType((PsiElement)it, SqlAsExpression.class, (boolean)true, (Class[])new Class[]{SqlSelectClause.class}) == null;
            }

            private final boolean hasOnlyLocalRefs(PsiElement e, SqlExpression expression, List<? extends SqlExpression> expressionBranches) {
                return e == expression || expressionBranches.stream().anyMatch((Predicate)new Predicate<SqlExpression>(e){
                    final /* synthetic */ PsiElement $e;

                    public final boolean test(SqlExpression b2) {
                        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)b2), (PsiElement)this.$e, (boolean)true);
                    }
                    {
                        this.$e = psiElement;
                    }
                });
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public static final /* synthetic */ boolean access$hasOnlyLocalRefs(createAnnotationVisitor.1 $this, @NotNull PsiElement e, @NotNull SqlExpression expression, @NotNull List expressionBranches) {
                return $this.hasOnlyLocalRefs(e, expression, expressionBranches);
            }

            public static final /* synthetic */ boolean access$hasOnlyInnerUsages(createAnnotationVisitor.1 $this, @NotNull SqlQueryExpression inspected, @NotNull PsiElement it, boolean isAlias) {
                return $this.hasOnlyInnerUsages(inspected, it, isAlias);
            }
        };
    }
}

