/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0016J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J \u0010\u001d\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "()V", "collectItemsToQualify", "", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "element", "Lcom/intellij/database/model/PsiTable;", "searchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "topSqlExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "doInvoke", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "findReference", "Lcom/intellij/psi/PsiReference;", "getFamilyName", "", "getSuitableReference", "reference", "getText", "invoke", "", "isAvailable", "startInWriteAction", "Companion", "intellij.database.sql.impl"})
public final class SqlIntroduceTableAliasIntention
extends BaseIntentionAction {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Introduce table alias";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getSuitableReference(this.findReference(editor, file)) != null;
    }

    private final PsiReference findReference(Editor editor, PsiFile file) {
        PsiElement element2;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiReference reference = file.findReferenceAt(offset);
        if (reference == null && offset > 0 && Companion.shouldLookBehind(element2 = file.findElementAt(offset))) {
            reference = file.findReferenceAt(offset - 1);
        }
        return reference;
    }

    private final SqlReferenceExpression getSuitableReference(PsiReference reference) {
        if (reference == null) {
            return null;
        }
        PsiElement psiElement = reference.getElement();
        if (!(psiElement instanceof SqlReferenceExpression)) {
            return null;
        }
        if (((SqlReferenceExpression)psiElement).getReferenceElementType() != SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
            return null;
        }
        PsiElement element2 = reference.resolve();
        if (!(element2 instanceof DasTable)) {
            return null;
        }
        PsiElement parent2 = ((SqlReferenceExpression)psiElement).getParent();
        if (parent2 instanceof SqlReferenceExpression || parent2 instanceof SqlAsExpression || parent2 instanceof SqlTableColumnsList) {
            return null;
        }
        return (SqlReferenceExpression)psiElement;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(this, file, editor, project){
                final /* synthetic */ SqlIntroduceTableAliasIntention this$0;
                final /* synthetic */ PsiFile $file;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ Project $project;

                public final boolean compute() {
                    return SqlIntroduceTableAliasIntention.access$doInvoke(this.this$0, this.$file, this.$editor, this.$project);
                }
                {
                    this.this$0 = sqlIntroduceTableAliasIntention;
                    this.$file = psiFile;
                    this.$editor = editor;
                    this.$project = project;
                }
            })).booleanValue()) {
                return;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
            if (renameHandler == null) break block1;
            renameHandler.invoke(project, editor, file, dataContext);
        }
    }

    private final boolean doInvoke(PsiFile file, Editor editor, Project project) {
        SqlReferenceExpression reference = this.getSuitableReference(this.findReference(editor, file));
        if (reference == null) {
            return false;
        }
        PsiElement element2 = reference.resolve();
        if (!(element2 instanceof PsiTable)) {
            return false;
        }
        SqlResultSetExpression topSqlExpression = Companion.getTopExpression((SqlExpression)reference, element2);
        if (topSqlExpression == null) {
            return false;
        }
        String aliasName = SqlNamesGenerator.suggestAliasName(reference.getName(), (PsiElement)reference);
        ArrayList<PsiElement> toReplace = new ArrayList<PsiElement>();
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)topSqlExpression);
        Query query = ReferencesSearch.search((PsiElement)element2, (SearchScope)((SearchScope)searchScope));
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(element, searchScope)");
        Iterable $receiver$iv = (Iterable)query;
        for (Object element$iv : $receiver$iv) {
            PsiReference it;
            PsiReference psiReference = it = (PsiReference)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
            PsiElement psiElement = psiReference.getElement();
            if (Intrinsics.areEqual((Object)psiElement, (Object)reference)) continue;
            if (!(psiElement instanceof SqlReferenceExpression)) {
                return false;
            }
            if (Companion.getTopExpression((SqlExpression)psiElement, element2) != topSqlExpression) continue;
            toReplace.add(psiElement);
        }
        List<SqlReferenceExpression> toQualify = this.collectItemsToQualify((PsiTable)element2, searchScope, topSqlExpression);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)reference);
        SqlExpression sqlExpression = SqlPsiElementFactory.createAsExpressionFromText(reference.getText() + " " + aliasName, dialect, (PsiElement)reference);
        if (sqlExpression == null) {
            Intrinsics.throwNpe();
        }
        SqlExpression expression = sqlExpression;
        PsiElement newExpression = reference.replace((PsiElement)expression);
        for (SqlReferenceExpression sqlReferenceExpression : toReplace) {
            SqlLanguageDialect sqlLanguageDialect = dialect;
            SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression2, (String)"referenceExpression");
            SqlReferenceExpression sqlReferenceExpression3 = SqlPsiElementFactory.createReferenceFromText(aliasName, sqlLanguageDialect, sqlReferenceExpression2.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            if (sqlReferenceExpression3 == null) {
                Intrinsics.throwNpe();
            }
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression3);
        }
        for (SqlReferenceExpression sqlReferenceExpression : toQualify) {
            SqlReferenceExpression sqlReferenceExpression4 = SqlPsiElementFactory.createReferenceFromText(aliasName + "." + sqlReferenceExpression.getText(), dialect, sqlReferenceExpression.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            if (sqlReferenceExpression4 == null) {
                Intrinsics.throwNpe();
            }
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression4);
        }
        CaretModel caretModel = editor.getCaretModel();
        PsiElement psiElement = newExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"newExpression");
        TextRange textRange = psiElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"newExpression.textRange");
        caretModel.moveToOffset(textRange.getEndOffset());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(editor.getDocument());
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
        return true;
    }

    private final List<SqlReferenceExpression> collectItemsToQualify(PsiTable element2, LocalSearchScope searchScope, SqlResultSetExpression topSqlExpression) {
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlEditorOptions, (String)"SqlEditorOptions.getInstance()");
        SqlEditorOptions.QualificationType aliasQualification = sqlEditorOptions.getAliasQualification();
        if (aliasQualification != SqlEditorOptions.QualificationType.ALWAYS) {
            return CollectionsKt.emptyList();
        }
        ArrayList<PsiElement> toQualify = new ArrayList<PsiElement>();
        PsiTable psiTable = element2;
        if (!(psiTable instanceof DbTable)) {
            psiTable = null;
        }
        DbTable dbTable = (DbTable)psiTable;
        Object object = dbTable != null ? dbTable.getDataSource() : null;
        if (!(object instanceof DbDataSourceImpl)) {
            object = null;
        }
        DbDataSourceImpl dataSourceImpl = (DbDataSourceImpl)((Object)object);
        for (DasColumn column2 : DasUtil.getColumns((DasObject)((DasObject)element2))) {
            PsiObject col;
            PsiObject psiObject;
            DasColumn dasColumn = column2;
            if (!(dasColumn instanceof PsiColumn)) {
                dasColumn = null;
            }
            PsiColumn psiColumn = (PsiColumn)dasColumn;
            if (psiColumn != null) {
                psiObject = (PsiObject)psiColumn;
            } else {
                DbDataSourceImpl dbDataSourceImpl = dataSourceImpl;
                psiObject = col = (PsiObject)(dbDataSourceImpl != null ? dbDataSourceImpl.findElement((DasObject)column2) : null);
            }
            if (col == null) continue;
            Query query = ReferencesSearch.search((PsiElement)((PsiElement)col), (SearchScope)((SearchScope)searchScope));
            Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(col, searchScope)");
            Iterable $receiver$iv = (Iterable)query;
            for (Object element$iv : $receiver$iv) {
                PsiReference it;
                PsiReference psiReference = it = (PsiReference)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                PsiElement psiElement = psiReference.getElement();
                if (!(psiElement instanceof SqlReferenceExpression) || ((SqlReferenceExpression)psiElement).getQualifierExpression() != null || ((SqlReferenceExpression)psiElement).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || Companion.getTopExpression((SqlExpression)psiElement, (PsiElement)element2) != topSqlExpression) continue;
                toQualify.add(psiElement);
            }
        }
        return toQualify;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ boolean access$doInvoke(SqlIntroduceTableAliasIntention $this, @NotNull PsiFile file, @NotNull Editor editor, @NotNull Project project) {
        return $this.doInvoke(file, editor, project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention$Companion;", "", "()V", "getTopExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "reference", "Lcom/intellij/sql/psi/SqlExpression;", "table", "Lcom/intellij/psi/PsiElement;", "isCorrelatedQuery", "", "expression", "resolveTable", "tableExpression", "Lcom/intellij/sql/psi/SqlTableExpression;", "shouldLookBehind", "element", "intellij.database.sql.impl"})
    public static final class Companion {
        public final boolean shouldLookBehind(@Nullable PsiElement element2) {
            return element2 == null || element2 instanceof PsiWhiteSpace || element2 instanceof PsiComment || element2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)element2).getElementType(), (Object)SqlCommonTokens.SQL_SEMICOLON);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SqlResultSetExpression getTopExpression(@Nullable SqlExpression reference, @Nullable PsiElement table) {
            void sqlExpression;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)reference), SqlResultSetExpression.class);
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            if ((SqlResultSetExpression)sqlExpression.element != null && (!(((SqlResultSetExpression)sqlExpression.element).getParent() instanceof SqlParenthesizedExpression) || this.isCorrelatedQuery((SqlResultSetExpression)sqlExpression.element, table))) {
                void parentParent;
                while (((Function0)new Function0<SqlResultSetExpression>((Ref.ObjectRef)parentParent, (Ref.ObjectRef)sqlExpression){
                    final /* synthetic */ Ref.ObjectRef $parentParent;
                    final /* synthetic */ Ref.ObjectRef $sqlExpression;

                    @Nullable
                    public final SqlResultSetExpression invoke() {
                        this.$parentParent.element = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)((SqlResultSetExpression)this.$sqlExpression.element)), SqlResultSetExpression.class);
                        return (SqlResultSetExpression)this.$parentParent.element;
                    }
                    {
                        this.$parentParent = objectRef;
                        this.$sqlExpression = objectRef2;
                        super(0);
                    }
                }).invoke() != null && !((SqlResultSetExpression)parentParent.element instanceof SqlNAryExpression)) {
                    sqlExpression.element = (SqlResultSetExpression)parentParent.element;
                    if ((SqlResultSetExpression)parentParent.element == null) break;
                    SqlResultSetExpression sqlResultSetExpression = (SqlResultSetExpression)parentParent.element;
                    if (sqlResultSetExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    if (this.isCorrelatedQuery(sqlResultSetExpression, table)) continue;
                    SqlResultSetExpression sqlResultSetExpression2 = (SqlResultSetExpression)parentParent.element;
                    if (!((sqlResultSetExpression2 != null ? sqlResultSetExpression2.getParent() : null) instanceof SqlParenthesizedExpression)) continue;
                    break;
                }
            }
            return (SqlResultSetExpression)sqlExpression.element;
        }

        public final boolean isCorrelatedQuery(@NotNull SqlResultSetExpression expression, @Nullable PsiElement table) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            if (!(expression instanceof SqlQueryExpression)) {
                return false;
            }
            PsiElement queryTable = this.resolveTable(((SqlQueryExpression)expression).getTableExpression());
            return queryTable == null || Intrinsics.areEqual((Object)table, (Object)queryTable) ^ true;
        }

        @Nullable
        public final PsiElement resolveTable(@Nullable SqlTableExpression tableExpression) {
            SqlExpression fromExpression;
            SqlTableExpression sqlTableExpression = tableExpression;
            SqlExpression sqlExpression = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : (fromExpression = null);
            if (fromExpression == null) {
                return null;
            }
            if (fromExpression instanceof SqlAsExpression) {
                fromExpression = ((SqlAsExpression)fromExpression).getExpression();
            }
            if (!(fromExpression instanceof SqlReferenceExpression)) {
                return null;
            }
            PsiElement possiblyTable = ((SqlReferenceExpression)fromExpression).resolve();
            return possiblyTable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

