/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.database.Dbms;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.sql.dialects.DbmsBean;
import com.intellij.sql.liveTemplates.SqlDialectSpecificContextType;
import com.intellij.sql.liveTemplates.SqlStatementContextType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class SqlDialectTemplateRegistrar
implements BaseComponent {
    static final String GENERIC_DIALECT_CLASS_POSTFIX = ".GenericDialect";
    static final String SQL92_LANGUAGE_CLASS_NAME = "Sql92Dialect";
    static final String SQL92_LANGUAGE_DESC = "Sql92";

    SqlDialectTemplateRegistrar() {
    }

    public void initComponent() {
        ExtensionsArea area = Extensions.getRootArea();
        ExtensionPoint templatesExtensionPoint = area.getExtensionPoint(TemplateContextType.EP_NAME);
        Arrays.stream(DbmsBean.getExtensions()).filter(b2 -> !b2.sqlDialectStr.endsWith(GENERIC_DIALECT_CLASS_POSTFIX)).collect(Collectors.groupingBy(o -> o.dbmsStr, Collectors.toList())).forEach((dbms, beans) -> {
            if (beans.isEmpty()) {
                return;
            }
            SqlDialectSpecificContextType contextType = new SqlDialectSpecificContextType((String)dbms, SqlDialectTemplateRegistrar.getDisplayName((DbmsBean)beans.get(0)), (List<DbmsBean>)beans);
            templatesExtensionPoint.registerExtension((Object)contextType);
            templatesExtensionPoint.registerExtension((Object)new SqlStatementContextType((String)dbms, contextType));
        });
    }

    @NotNull
    private static String getDisplayName(@NotNull DbmsBean dbmsBean) {
        if (dbmsBean == null) {
            SqlDialectTemplateRegistrar.$$$reportNull$$$0(0);
        }
        if (dbmsBean.sqlDialectStr.endsWith(SQL92_LANGUAGE_CLASS_NAME)) {
            if (SQL92_LANGUAGE_DESC == null) {
                SqlDialectTemplateRegistrar.$$$reportNull$$$0(1);
            }
            return SQL92_LANGUAGE_DESC;
        }
        String string = ((Dbms)dbmsBean.dbms.getValue()).getDisplayName();
        if (string == null) {
            SqlDialectTemplateRegistrar.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsBean";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/liveTemplates/SqlDialectTemplateRegistrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/liveTemplates/SqlDialectTemplateRegistrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

