/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallTableExpressionImpl
extends SqlExplicitTableExpressionImpl
implements SqlDefinition {
    private volatile FakeTable myTable;

    public SqlFunctionCallTableExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myTable = null;
    }

    @Override
    public void clearCaches() {
        this.myTable = null;
        super.clearCaches();
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        ArrayList columns;
        SqlColumnAliasListImpl aliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        if (aliasList != null && SqlFunctionCallExpressionImpl.collectColumnDefs(columns = ContainerUtil.newArrayList(), (PsiElement)aliasList, SqlColumnAliasDefinition.class)) {
            TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl(columns, (PsiElement)this.getTable());
            if (tableBasedSqlTableTypeImpl == null) {
                SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(1);
            }
            return tableBasedSqlTableTypeImpl;
        }
        SqlTableType type = this.getFunctionTableType();
        SqlTypedDefinition ordinality = this.getOrdinalityColumn();
        if (ordinality != null) {
            type = type.add(new TableBasedSqlTableTypeImpl<SqlTypedDefinition>(Collections.singletonList(ordinality), (PsiElement)this.getTable()));
        }
        SqlTableType sqlTableType = type;
        if (sqlTableType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlTableType;
    }

    private SqlTableType getFunctionTableType() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        if (call == null) {
            return SqlTableTypeBase.createType((SqlElement)this, new TableBasedSqlTableTypeImpl(ContainerUtil.emptyList(), null), null, (PsiElement)this.getTable());
        }
        SqlReferenceExpression name = call.getNameElement();
        SqlType type = call.getSqlType();
        String alias = name == null ? null : name.getName();
        FakeTable table = this.getTable();
        if (type instanceof SqlTableType) {
            SqlTableType tableType = (SqlTableType)type;
            List aliases = Collections.emptyList();
            if (tableType.getColumnCount() == 1 && StringUtil.isEmpty((String)tableType.getColumnName(0))) {
                aliases = ContainerUtil.createMaybeSingletonList((Object)name);
            }
            return tableType.alias(alias, (PsiElement)table, aliases);
        }
        return SqlTableTypeBase.createType((SqlElement)table.myColumn, type, alias, (PsiElement)table);
    }

    @Nullable
    private SqlFunctionCallExpression getFunctionCall() {
        return (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlFunctionCallExpression.class);
    }

    @Nullable
    private SqlTypedDefinition getOrdinalityColumn() {
        return (SqlTypedDefinition)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcOrdinalityColumn(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlTypedDefinition calcOrdinalityColumn() {
        SqlElement ordinality = this.getWithOrdinality();
        if (ordinality == null) {
            return null;
        }
        return new OrdinalityColumn(this.getTable(), ordinality);
    }

    @Nullable
    private SqlElement getWithOrdinality() {
        for (PsiElement c2 = this.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
            if (!(c2 instanceof SqlClause) || PsiUtilCore.getElementType((PsiElement)c2.getFirstChild()) != SqlCommonKeywords.SQL_WITH || PsiUtilCore.getElementType((PsiElement)c2.getLastChild()) != SqlCommonKeywords.SQL_ORDINALITY) continue;
            return (SqlElement)c2;
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        SqlNameElement nameElement = this.getNameElement();
        String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
        if (string == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlNameElement nameElement;
        if (name == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((nameElement = this.getNameElement()) != null) {
            nameElement.setName(name);
        }
        return this;
    }

    @Nullable
    public SqlNameElement getNameElement() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        return call == null ? null : call.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(5);
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    public boolean isNameQuoted() {
        return DbSqlUtil.isQuoted(this.getNameElement());
    }

    private FakeTable getTable() {
        return this.myTable == null ? (this.myTable = new FakeTable()) : this.myTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OrdinalityColumn
    extends FakeDefinition
    implements SqlTypedDefinition {
        private final SqlElement myClause;

        protected OrdinalityColumn(PsiTable table, SqlElement clause) {
            super((PsiElement)table);
            this.myClause = clause;
        }

        @Override
        @NotNull
        public String getName() {
            if ("ordinality" == null) {
                OrdinalityColumn.$$$reportNull$$$0(0);
            }
            return "ordinality";
        }

        public DasObject getDasParent() {
            return (PsiTable)this.getParent();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                OrdinalityColumn.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                OrdinalityColumn.$$$reportNull$$$0(2);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = SqlFunctionCallTableExpressionImpl.this.getSqlTypeForCategory(SqlType.Category.INTEGER);
            if (sqlType == null) {
                OrdinalityColumn.$$$reportNull$$$0(3);
            }
            return sqlType;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlElement sqlElement = this.myClause;
            if (sqlElement == null) {
                OrdinalityColumn.$$$reportNull$$$0(4);
            }
            return sqlElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$OrdinalityColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class FakeTable
    extends FakeDefinition
    implements PsiTable {
        private final FakeColumn myColumn;

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                FakeTable.$$$reportNull$$$0(0);
            }
            return set;
        }

        protected FakeTable() {
            super((PsiElement)SqlFunctionCallTableExpressionImpl.this);
            this.myColumn = new FakeColumn();
        }

        @NotNull
        public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this.myColumn)).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                FakeTable.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                FakeTable.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class FakeColumn
        extends FakeDefinition
        implements PsiColumn {
            protected FakeColumn() {
                super((PsiElement)FakeTable.this);
            }

            public short getPosition() {
                return 0;
            }

            @Override
            @NotNull
            public String getName() {
                SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)SqlFunctionCallTableExpressionImpl.this.getParent(), SqlAsExpression.class);
                String name = asExpr == null ? null : asExpr.getName();
                String string = name == null ? super.getName() : name;
                if (string == null) {
                    FakeColumn.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getDisplayOrder() {
                if ("" == null) {
                    FakeColumn.$$$reportNull$$$0(1);
                }
                return "";
            }

            public String getTableName() {
                return this.getTable().getName();
            }

            public DasTable getTable() {
                return FakeTable.this;
            }

            @Nullable
            public DasObject getDasParent() {
                return this.getTable();
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    FakeColumn.$$$reportNull$$$0(2);
                }
                return objectKind;
            }

            @NotNull
            public DataType getDataType() {
                SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
                DataType dataType = call == null ? DataType.UNKNOWN : call.getSqlType().getDataType();
                if (dataType == null) {
                    FakeColumn.$$$reportNull$$$0(3);
                }
                return dataType;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayOrder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    private abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent2) {
            super(parent2);
        }

        public boolean isNameQuoted() {
            return DbSqlUtil.isQuoted(this.getNameElement());
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
            return call == null ? null : call.getNameElement();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(SqlVisitor visitor) {
        }

        public void acceptChildren(SqlVisitor visitor) {
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            SqlNameElement nameElement;
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            if ((nameElement = this.getNameElement()) != null) {
                nameElement.setName(name);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlFunctionCallTableExpressionImpl sqlFunctionCallTableExpressionImpl = SqlFunctionCallTableExpressionImpl.this;
            if (sqlFunctionCallTableExpressionImpl == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            return sqlFunctionCallTableExpressionImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

