/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.util.containers.WeakInterner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlTypeFactory {
    private static final WeakInterner<SqlPrimitiveType> ourInterner = new WeakInterner();

    @NotNull
    public static SqlType of(@NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(1);
        }
        if (dataType == DataType.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(2);
            }
            return sqlPrimitiveType;
        }
        SqlType.Category cat = dialect.getTypeCategory(dataType);
        SqlType sqlType = SqlTypeFactory.of(dataType, cat);
        if (sqlType == null) {
            SqlTypeFactory.$$$reportNull$$$0(3);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType of(@NotNull DataType dataType, @NotNull SqlType.Category category) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(4);
        }
        if (category == null) {
            SqlTypeFactory.$$$reportNull$$$0(5);
        }
        if (dataType == DataType.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(6);
            }
            return sqlPrimitiveType;
        }
        SqlType sqlType = (SqlType)ourInterner.intern((Object)new SqlPrimitiveType(dataType, category));
        if (sqlType == null) {
            SqlTypeFactory.$$$reportNull$$$0(7);
        }
        return sqlType;
    }

    @NotNull
    public static SqlParametrizedType of(@NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @NotNull List<SqlType> typeParameters) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(9);
        }
        if (typeParameters == null) {
            SqlTypeFactory.$$$reportNull$$$0(10);
        }
        SqlParametrizedType sqlParametrizedType = new SqlParametrizedType(dataType, dialect.getTypeCategory(dataType), typeParameters);
        if (sqlParametrizedType == null) {
            SqlTypeFactory.$$$reportNull$$$0(11);
        }
        return sqlParametrizedType;
    }

    @NotNull
    public static SqlType defaultType(@NotNull SqlType.Category category, @NotNull SqlLanguageDialectEx dialect) {
        if (category == null) {
            SqlTypeFactory.$$$reportNull$$$0(12);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(13);
        }
        if (category == SqlType.Category.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(14);
            }
            return sqlPrimitiveType;
        }
        String name = dialect.getDefaultTypeName(category);
        Object object = name == null ? SqlType.UNKNOWN : SqlTypeFactory.of(DataTypeFactory.of(dialect.getNormalizedTypeName(name)), dialect);
        if (object == null) {
            SqlTypeFactory.$$$reportNull$$$0(15);
        }
        return object;
    }

    @NotNull
    public static SqlType findByJdbcType(int jdbcType, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(16);
        }
        SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.findByJdbcType((int)jdbcType), dialect);
        if (sqlType == null) {
            SqlTypeFactory.$$$reportNull$$$0(17);
        }
        return sqlType;
    }

    @NotNull
    public static DataType createTableDataType(@NotNull Iterable<? extends DasTypedObject> vagueArgs) {
        if (vagueArgs == null) {
            SqlTypeFactory.$$$reportNull$$$0(18);
        }
        StringBuilder args2 = new StringBuilder();
        for (DasTypedObject dasTypedObject : vagueArgs) {
            String name;
            if (args2.length() != 0) {
                args2.append(", ");
            }
            if (StringUtil.isNotEmpty((String)(name = dasTypedObject.getName()))) {
                args2.append(name).append(" ");
            }
            args2.append(dasTypedObject.getDataType().getSpecification());
        }
        DataType dataType = SqlTypeFactory.createTableDataType(args2.toString());
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(19);
        }
        return dataType;
    }

    @NotNull
    public static DataType createTableDataType(@NotNull String vagueArgs) {
        if (vagueArgs == null) {
            SqlTypeFactory.$$$reportNull$$$0(20);
        }
        DataType dataType = DataTypeFactory.ofArgs(null, "table", vagueArgs, false);
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(21);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeFactory";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagueArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeFactory";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findByJdbcType";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defaultType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findByJdbcType";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTableDataType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

