/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.editor.SqlCodeBlockProvider;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBlockHighlighterFactory
implements TextEditorHighlightingPassFactory {
    private static final HighlightInfoType MATCHED = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES);
    private static final HighlightInfoType UNMATCHED = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);

    public SqlBlockHighlighterFactory(TextEditorHighlightingPassRegistrar registrar) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(1);
        }
        return file instanceof SqlFile ? new SqlBlockHighlightingPass(file, editor) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/psi/impl/support/SqlBlockHighlighterFactory";
        objectArray[2] = "createHighlightingPass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SqlBlockHighlightingPass
    extends TextEditorHighlightingPass {
        private final PsiFile myFile;
        private final Editor myEditor;
        private final List<TextRange> myRanges = ContainerUtil.newArrayList();
        private int myEndIdx;

        public SqlBlockHighlightingPass(PsiFile file, Editor editor) {
            super(file.getProject(), editor.getDocument(), false);
            this.myFile = file;
            this.myEditor = editor;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                SqlBlockHighlightingPass.$$$reportNull$$$0(0);
            }
            this.findPair(this.myEditor.getCaretModel().getOffset());
        }

        public void findPair(int offset) {
            this.myRanges.clear();
            this.myEndIdx = -1;
            for (PsiElement element2 : SqlCodeBlockProvider.processBlock(this.myFile, offset)) {
                if (PsiUtilCore.getElementType((PsiElement)element2) == SqlCommonKeywords.SQL_END) {
                    this.myEndIdx = this.myRanges.size();
                }
                this.myRanges.add(element2.getTextRange());
            }
        }

        public List<TextRange> getRanges() {
            return this.myRanges;
        }

        public void doApplyInformationToEditor() {
            ArrayList infos;
            if (this.myRanges.isEmpty()) {
                infos = Collections.emptyList();
            } else {
                infos = ContainerUtil.newArrayList();
                HighlightInfoType type = this.isMatched() ? MATCHED : UNMATCHED;
                for (TextRange range : this.myRanges) {
                    ContainerUtil.addIfNotNull((Collection)infos, (Object)HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(range).create());
                }
            }
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myFile.getProject(), (Document)this.myEditor.getDocument(), (int)0, (int)this.myFile.getTextLength(), (Collection)infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        public boolean isMatched() {
            return this.myEndIdx >= 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/sql/psi/impl/support/SqlBlockHighlighterFactory$SqlBlockHighlightingPass", "doCollectInformation"));
        }
    }
}

