/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlCteInplaceIntroducer
extends AbstractInplaceIntroducer<SqlAsExpression, PsiElement> {
    private final SqlExpression myInnerExpr;
    private SqlAsExpression myId;
    private boolean myDeleteSelf;
    private final PsiElement myContext;

    SqlCteInplaceIntroducer(Project project, Editor editor, @NotNull SqlExpression subquery, @NotNull PsiElement context, FileType fileType) {
        if (subquery == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(1);
        }
        super(project, editor, (PsiElement)SqlSubqueryUtils.expanded(subquery), null, new PsiElement[]{subquery}, "Introduce CTE", fileType);
        this.myInnerExpr = subquery;
        this.myContext = context;
    }

    public PsiElement restoreExpression(@NotNull PsiFile containingFile, @NotNull SqlAsExpression variable, @NotNull RangeMarker marker, String exprText) {
        if (containingFile == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(3);
        }
        if (marker == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(4);
        }
        PsiElement start = containingFile.findElementAt(marker.getStartOffset());
        PsiElement end = containingFile.findElementAt(marker.getEndOffset() - 1);
        if (start == null || end == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
    }

    protected String getActionName() {
        return "Introduce CTE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected SqlAsExpression createFieldToStartTemplateOn(boolean replaceAll, @NotNull String[] names) {
        if (names == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(5);
        }
        SqlWithClause with = SqlSubqueryUtils.extractWithClause(this.myContext);
        StringBuilder out = new StringBuilder();
        DdlBuilder builder = new DdlBuilder(out);
        builder.applyCodeStyle(this.myProject);
        if (with != null) {
            builder.plain(with.getText()).symbol(",").space();
        } else {
            builder.keyword("with").space();
        }
        String aliasName = SqlNamesGenerator.suggestAliasName(this.myInnerExpr);
        int idPos = builder.length();
        builder.identifier(aliasName).space().keyword("as").space().symbol("(").plain(this.myInnerExpr.getText()).symbol(")").newLine().plain("SELECT * from aaa");
        SqlSelectStatement select = (SqlSelectStatement)PsiTreeUtil.findChildOfType((PsiElement)SqlPsiElementFactory.createStatementFromText(out.toString(), SqlImplUtil.getSqlDialectSafe(this.myContext), this.myProject, this.myContext), SqlSelectStatement.class, (boolean)false);
        assert (select != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)select.getQueryExpression(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlWithClause newWith = withEx.getWithClause();
        if (with != null) {
            with = (SqlWithClause)with.replace((PsiElement)newWith);
        } else {
            SqlExpression q = withEx.getExpression();
            with = (SqlWithClause)this.myContext.addRangeBefore((PsiElement)withEx.getWithClause(), (PsiElement)(q != null ? q.getPrevSibling() : withEx.getWithClause()), this.myContext.getFirstChild());
        }
        this.myId = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)with.findElementAt(idPos), SqlAsExpression.class);
        SmartPsiElementPointer smartId = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myId);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            if (smartId.getElement() != null) {
                this.restoreState((SqlAsExpression)smartId.getElement());
            }
            this.myId = (SqlAsExpression)smartId.getElement();
        }
        finally {
            this.myDeleteSelf = true;
            SmartPointerManager.getInstance((Project)this.myProject).removePointer(smartId);
        }
        this.myEditor.getCaretModel().moveToOffset(this.myId.getTextRange().getStartOffset());
        return this.myId;
    }

    protected void deleteTemplateField(SqlAsExpression variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        super.deleteTemplateField((PsiNameIdentifierOwner)variable);
    }

    protected int getCaretOffset() {
        PsiElement identifier;
        if (this.myId != null && (identifier = this.myId.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    @NotNull
    protected String[] suggestNames(boolean replaceAll, @Nullable SqlAsExpression variable) {
        String[] stringArray = new String[]{};
        if (stringArray == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    protected void performIntroduce() {
    }

    public boolean isReplaceAllOccurrences() {
        return false;
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected JComponent getComponent() {
        return null;
    }

    protected void saveSettings(@NotNull SqlAsExpression variable) {
        if (variable == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(7);
        }
    }

    protected SqlAsExpression getVariable() {
        return this.myId;
    }

    protected void restoreState(@NotNull SqlAsExpression psiField) {
        if (psiField == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(8);
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState((PsiNameIdentifierOwner)psiField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subquery";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/SqlCteInplaceIntroducer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/SqlCteInplaceIntroducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

