/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.ConfigurableUiEx;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.ui.ComboBoxModelEditor;
import com.intellij.util.ui.ListItemEditor;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.RepositoryItem;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"createRepositoryListEditor", "Lcom/intellij/ui/layout/ConfigurableUiEx;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "deleteRepository", "", "intellij.settingsRepository"})
public final class RepositoryListEditorKt {
    @NotNull
    public static final ConfigurableUiEx<IcsSettings> createRepositoryListEditor(@NotNull IcsManager icsManager2) {
        Intrinsics.checkParameterIsNotNull((Object)icsManager2, (String)"icsManager");
        ComboBoxModelEditor editor2 = new ComboBoxModelEditor((ListItemEditor)new ListItemEditor<RepositoryItem>(){

            @NotNull
            public Class<RepositoryItem> getItemClass() {
                return RepositoryItem.class;
            }

            @NotNull
            public RepositoryItem clone(@NotNull RepositoryItem item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new RepositoryItem(item.getUrl());
            }
        });
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(editor2, deleteButton){
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    RepositoryItem repositoryItem;
                    MutableCollectionComboBoxModel mutableCollectionComboBoxModel = this.$editor.getModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableCollectionComboBoxModel, (String)"editor.model");
                    RepositoryItem repositoryItem2 = (RepositoryItem)mutableCollectionComboBoxModel.getSelected();
                    if (repositoryItem2 == null) break block0;
                    RepositoryItem it2 = repositoryItem = repositoryItem2;
                    this.$editor.getModel().remove((Object)it2);
                    MutableCollectionComboBoxModel mutableCollectionComboBoxModel2 = this.$editor.getModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableCollectionComboBoxModel2, (String)"editor.model");
                    this.$deleteButton.setEnabled(mutableCollectionComboBoxModel2.getSelected() != null);
                }
            }
            {
                this.$editor = comboBoxModelEditor;
                this.$deleteButton = jButton;
            }
        });
        return (ConfigurableUiEx)new ConfigurableUiEx<IcsSettings>(editor2, deleteButton, icsManager2){
            private Row repositoryRow;
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;
            final /* synthetic */ IcsManager $icsManager;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            /*
             * WARNING - void declaration
             */
            public void buildUi(@NotNull LayoutBuilder builder) {
                Row row;
                void this_$iv$iv;
                Row row$iv$iv;
                Row $receiver;
                void label$iv;
                void this_$iv;
                LayoutBuilder layoutBuilder;
                LayoutBuilder $receiver2;
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                LayoutBuilder layoutBuilder2 = $receiver2 = (layoutBuilder = builder);
                String string = "Repository:";
                createRepositoryListEditor.2 var6_6 = this;
                void var7_7 = this_$iv;
                JLabel label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                boolean separated$iv$iv = false;
                Row this_$iv2 = $receiver = (row$iv$iv = this_$iv$iv.getBuilder().newRow(label$iv$iv, this_$iv$iv.getButtonGroup(), separated$iv$iv));
                boolean isVerticalFlow$iv = false;
                this_$iv2.setCellMode(true, isVerticalFlow$iv);
                Cell $receiver3 = (Cell)this_$iv2;
                ComboBox comboBox = this.$editor.getComboBox();
                Intrinsics.checkExpressionValueIsNotNull((Object)comboBox, (String)"comboBox");
                CCFlags[] cCFlagsArray = new CCFlags[]{};
                GrowPolicy growPolicy = null;
                int n = 0;
                String string2 = "Use File -> Settings Repository... to configure";
                Cell.invoke$default((Cell)$receiver3, (JComponent)((JComponent)comboBox), (CCFlags[])cCFlagsArray, (int)n, growPolicy, (String)string2, (int)6, null);
                Cell.invoke$default((Cell)$receiver3, (JComponent)this.$deleteButton, (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
                this_$iv2.setCellMode(false, isVerticalFlow$iv);
                var6_6.repositoryRow = row = row$iv$iv;
            }

            @NotNull
            public JPanel getComponent() {
                LayoutBuilder builder$iv;
                createRepositoryListEditor.2 var1_1 = this;
                Object[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                LayoutBuilder p1 = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
                var1_1.buildUi(p1);
                JPanel panel$iv = ComponentsKt.Panel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
                return panel$iv;
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List newList = this.$editor.apply();
                if (newList.isEmpty()) {
                    RepositoryListEditorKt.access$deleteRepository(this.$icsManager);
                }
            }

            public void reset(@NotNull IcsSettings settings) {
                RepositoryItem upstream;
                RepositoryItem repositoryItem;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                ArrayList<Object> list = new ArrayList<Object>();
                String string = this.$icsManager.getRepositoryManager().getUpstream();
                if (string != null) {
                    object = string;
                    String p1 = object;
                    repositoryItem = new RepositoryItem(p1);
                } else {
                    repositoryItem = null;
                }
                RepositoryItem repositoryItem2 = upstream = repositoryItem;
                if (repositoryItem2 != null) {
                    Object it = object = repositoryItem2;
                    list.add(it);
                }
                this.$editor.reset((List)list);
                MutableCollectionComboBoxModel mutableCollectionComboBoxModel = this.$editor.getModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableCollectionComboBoxModel, (String)"editor.model");
                mutableCollectionComboBoxModel.setSelectedItem((Object)upstream);
                MutableCollectionComboBoxModel mutableCollectionComboBoxModel2 = this.$editor.getModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableCollectionComboBoxModel2, (String)"editor.model");
                this.$deleteButton.setEnabled(mutableCollectionComboBoxModel2.getSelectedItem() != null);
            }
            {
                this.$editor = $captured_local_variable$0;
                this.$deleteButton = $captured_local_variable$1;
                this.$icsManager = $captured_local_variable$2;
            }
        };
    }

    private static final void deleteRepository(IcsManager icsManager2) {
        String title$iv;
        String string = "Syncing before delete Repository";
        boolean cancellable$iv = true;
        Project project$iv = null;
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, icsManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ IcsManager $icsManager$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$icsManager$inlined = icsManager2;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                indicator2.setIndeterminate(true);
                RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                if (!repositoryManager.canCommit()) {
                    IcsManagerKt.getLOG().info("Commit on repository delete skipped: repository is not committable");
                } else {
                    boolean asWarning$iv = true;
                    try {
                        RepositoryManager.Updater updater = repositoryManager.fetch(indicator2);
                        indicator2.checkCanceled();
                        updater.merge();
                        indicator2.checkCanceled();
                        if (!updater.getDefinitelySkipPush()) {
                            repositoryManager.push(indicator2);
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e$iv) {
                        IcsManagerKt.getLOG().warn(e$iv);
                    }
                }
            }
        });
        title$iv = "Deleting Repository";
        cancellable$iv = false;
        project$iv = null;
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, icsManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ IcsManager $icsManager$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$icsManager$inlined = icsManager2;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                indicator2.setIndeterminate(true);
                repositoryManager.deleteRepository();
                this.$icsManager$inlined.setRepositoryActive(false);
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ComponentStoreImpl store = (ComponentStoreImpl)iComponentStore;
        StateStorageManager stateStorageManager = store.getStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        if (!StoreAwareProjectManagerKt.reloadAppStore((Set)((StateStorageManagerImpl)stateStorageManager).getCachedFileStorages())) {
            return;
        }
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)deleteRepository.3.INSTANCE);
    }

    public static final /* synthetic */ void access$deleteRepository(@NotNull IcsManager icsManager2) {
        RepositoryListEditorKt.deleteRepository(icsManager2);
    }
}

