/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.basic;

import com.microsoft.alm.auth.basic.CredentialPrompt;
import com.microsoft.alm.secret.Credential;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DefaultCredentialPrompt
implements CredentialPrompt {
    private final Lock lock = new ReentrantLock();
    private final Condition userResponseReceived = this.lock.newCondition();
    private Credential userEnteredCredential;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldUsername;
    private JFrame frame;

    public DefaultCredentialPrompt() {
        JPanel panel = this.createJPanel();
        this.frame = new JFrame();
        this.frame.setSize(380, 180);
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DefaultCredentialPrompt.this.jButtonCancelActionPerformed(null);
            }
        });
        this.frame.add(panel);
    }

    private JPanel createJPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jPasswordField = new JPasswordField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        jLabel1.setText("Username:");
        jLabel2.setText("Password:");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultCredentialPrompt.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultCredentialPrompt.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(jPanel);
        jPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel2).addComponent(jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldUsername).addComponent(this.jPasswordField, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 180, -2).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel))).addGap(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldUsername, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jPasswordField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(14, Short.MAX_VALUE)));
        return jPanel;
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.lock.lock();
        try {
            this.userEnteredCredential = null;
            this.userResponseReceived.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.lock.lock();
        try {
            String username = this.jTextFieldUsername.getText();
            String password = String.valueOf(this.jPasswordField.getPassword());
            this.userEnteredCredential = new Credential(username, password);
            this.userResponseReceived.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void showPrompt() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultCredentialPrompt.this.frame.setVisible(true);
            }
        });
    }

    @Override
    public Credential prompt(URI target) {
        this.showPrompt();
        this.lock.lock();
        try {
            this.userResponseReceived.awaitUninterruptibly();
            Credential credential = this.userEnteredCredential;
            return credential;
        }
        finally {
            this.frame.dispose();
            this.lock.unlock();
        }
    }
}

