/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.helpers.PropertyBag;
import java.net.URI;

public class AzureDeviceFlowResponse
extends DeviceFlowResponse {
    static final String VERIFICATION_URL = "verification_url";
    static final String MESSAGE = "message";
    private final String message;

    public AzureDeviceFlowResponse(String deviceCode, String userCode, URI verificationUri, int expiresIn, int interval, String message) {
        super(deviceCode, userCode, verificationUri, expiresIn, interval);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static AzureDeviceFlowResponse fromJson(String jsonText) {
        PropertyBag bag = PropertyBag.fromJson((String)jsonText);
        String deviceCode = (String)bag.get((Object)"device_code");
        String userCode = (String)bag.get((Object)"user_code");
        String verificationUriString = (String)bag.get((Object)VERIFICATION_URL);
        URI verificationUri = URI.create(verificationUriString);
        int expiresInSeconds = bag.readOptionalInteger("expires_in", 600);
        int intervalInSeconds = bag.readOptionalInteger("interval", 5);
        String message = (String)bag.get((Object)MESSAGE);
        AzureDeviceFlowResponse result = new AzureDeviceFlowResponse(deviceCode, userCode, verificationUri, expiresInSeconds, intervalInSeconds, message);
        return result;
    }
}

