/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBPoint;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\u00020\u00012\u00020\u0002:\u0003012B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020%J\b\u0010'\u001a\u00020\u0018H\u0002J\b\u0010(\u001a\u00020\u0018H\u0002J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u000eJ\b\u0010)\u001a\u00020\u0018H\u0002J\u0006\u0010*\u001a\u00020\u0018J\b\u0010+\u001a\u00020\u0018H\u0002J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgit4idea/branch/DeepComparator;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "dataProvider", "Lcom/intellij/vcs/log/VcsLogDataProvider;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/VcsLogDataProvider;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "comparedBranch", "", "nonPickedCommits", "Lgnu/trove/TIntHashSet;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "dispose", "", "getRepositories", "providers", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "branchToCompare", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "isSelected", "", "hasHighlightingOrInProgress", "notifyUnhighlight", "startTask", "stopTask", "stopTaskAndUnhighlight", "unhighlight", "update", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "refreshHappened", "Companion", "Factory", "MyTask", "intellij.vcs.git"})
public final class DeepComparator
implements VcsLogHighlighter,
Disposable {
    private ProgressIndicator progressIndicator;
    private String comparedBranch;
    private Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches;
    private TIntHashSet nonPickedCommits;
    private final Project project;
    private final GitRepositoryManager repositoryManager;
    private final VcsLogDataProvider dataProvider;
    private final VcsLogUi ui;
    private static final Logger LOG;
    private static final String HIGHLIGHTING_CANCELLED = "Highlighting of non-picked commits has been cancelled";
    public static final Companion Companion;

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)commitDetails, (String)"commitDetails");
                if (this.nonPickedCommits == null) break block4;
                TIntHashSet tIntHashSet = this.nonPickedCommits;
                if (tIntHashSet == null) {
                    Intrinsics.throwNpe();
                }
                if (!tIntHashSet.contains(commitId)) break block5;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsCommitStyle, (String)"VcsLogHighlighter.VcsCommitStyle.DEFAULT");
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsCommitStyle, (String)"VcsCommitStyleFactory.fo\u2026.MERGE_COMMIT_FOREGROUND)");
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
        if (this.comparedBranch == null) {
            return;
        }
        String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)dataPack.getFilters(), (VcsLogRefs)dataPack.getRefs());
        if (Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch) ^ true) {
            LOG.debug("Branch filter changed. Compared branch: " + this.comparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight();
            return;
        }
        if (refreshHappened) {
            Map<GitRepository, GitBranch> repositories;
            this.stopTask();
            Map map2 = dataPack.getLogProviders();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"dataPack.logProviders");
            String string = this.comparedBranch;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(repositories = this.getRepositories(map2, string), this.repositoriesWithCurrentBranches)) {
                this.startTask();
            } else {
                LOG.debug("Repositories with current branches changed. Actual:\n" + repositories + "\nExpected:\n" + this.repositoriesWithCurrentBranches);
                this.unhighlight();
            }
        }
    }

    public final void startTask(@NotNull String branchToCompare) {
        Intrinsics.checkParameterIsNotNull((Object)branchToCompare, (String)"branchToCompare");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        VcsLogDataPack vcsLogDataPack = this.ui.getDataPack();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogDataPack, (String)"ui.dataPack");
        Map map2 = vcsLogDataPack.getLogProviders();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"ui.dataPack.logProviders");
        Map<GitRepository, GitBranch> repositories = this.getRepositories(map2, branchToCompare);
        if (repositories.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithCurrentBranches = repositories;
        this.startTask();
    }

    public final void stopTaskAndUnhighlight() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    public final boolean hasHighlightingOrInProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask() {
        LOG.debug("Highlighting requested for " + this.repositoriesWithCurrentBranches);
        Map<GitRepository, ? extends GitBranch> map2 = this.repositoriesWithCurrentBranches;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        String string = this.comparedBranch;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MyTask task2 = new MyTask(map2, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task2;
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            Intrinsics.throwNpe();
        }
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator == null) {
                Intrinsics.throwNpe();
            }
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithCurrentBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, GitBranch> getRepositories(Map<VirtualFile, ? extends VcsLogProvider> providers, String branchToCompare) {
        void $receiver$iv$iv;
        GitRepository gitRepository;
        Object it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)providers.keySet();
        Iterable destination$iv$iv = new ArrayList();
        Iterator $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv = iterator.next();
            Object element$iv$iv = element$iv$iv$iv;
            it = (VirtualFile)element$iv$iv;
            if ((GitRepository)this.repositoryManager.getRepositoryForRoot((VirtualFile)it) == null) continue;
            GitRepository it$iv$iv = gitRepository;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            GitRepository repository;
            GitRepository gitRepository2 = repository = (GitRepository)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository2, (String)"repository");
            if (!(gitRepository2.getCurrentBranch() != null && repository.getBranches().findBranchByName(branchToCompare) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv2;
            Object object = it = (GitRepository)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            GitLocalBranch gitLocalBranch = object.getCurrentBranch();
            if (gitLocalBranch == null) {
                Intrinsics.throwNpe();
            }
            gitRepository = new Pair(it, (Object)gitLocalBranch);
            map2.put(gitRepository.getFirst(), gitRepository.getSecond());
        }
        return destination$iv$iv2;
    }

    private final void notifyUnhighlight() {
        if (this.ui instanceof AbstractVcsLogUi) {
            JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
            Balloon balloon = jBPopupFactory.createHtmlTextBalloonBuilder(HIGHLIGHTING_CANCELLED, null, messageType.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            VcsLogGraphTable component = ((AbstractVcsLogUi)this.ui).getTable();
            Component component2 = (Component)component;
            VcsLogGraphTable vcsLogGraphTable = component;
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogGraphTable, (String)"component");
            balloon.show(new RelativePoint(component2, (Point)new JBPoint(vcsLogGraphTable.getWidth() / 2, component.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogDataProvider dataProvider, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)repositoryManager), (String)"repositoryManager");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.dataProvider = dataProvider;
        this.ui = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(DeepComparator.class);
    }

    @Nullable
    public static final /* synthetic */ ProgressIndicator access$getProgressIndicator$p(DeepComparator $this) {
        return $this.progressIndicator;
    }

    @Nullable
    public static final /* synthetic */ TIntHashSet access$getNonPickedCommits$p(DeepComparator $this) {
        return $this.nonPickedCommits;
    }

    @NotNull
    public static final /* synthetic */ VcsLogDataProvider access$getDataProvider$p(DeepComparator $this) {
        return $this.dataProvider;
    }

    @JvmStatic
    @NotNull
    public static final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogDataProvider dataProvider, @NotNull VcsLogUi logUi) {
        return Companion.getInstance(project, dataProvider, logUi);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/branch/DeepComparator$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "comparedBranch", "", "(Lgit4idea/branch/DeepComparator;Ljava/util/Map;Ljava/lang/String;)V", "collectedNonPickedCommits", "Lgnu/trove/TIntHashSet;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "getNonPickedCommitsFromGit", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentBranch", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.vcs.git"})
    private final class MyTask
    extends Task.Backgroundable {
        private final TIntHashSet collectedNonPickedCommits;
        private VcsException exception;
        private final Map<GitRepository, GitBranch> repositoriesWithCurrentBranches;
        private final String comparedBranch;

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            try {
                this.repositoriesWithCurrentBranches.forEach(new BiConsumer<GitRepository, GitBranch>(this){
                    final /* synthetic */ MyTask this$0;

                    public final void accept(@NotNull GitRepository repo, @NotNull GitBranch currentBranch) {
                        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
                        Intrinsics.checkParameterIsNotNull((Object)currentBranch, (String)"currentBranch");
                        TIntHashSet tIntHashSet = MyTask.access$getCollectedNonPickedCommits$p(this.this$0);
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
                        String string = currentBranch.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentBranch.name");
                        TroveUtil.addAll((TIntHashSet)tIntHashSet, (TIntHashSet)MyTask.access$getNonPickedCommitsFromGit(this.this$0, virtualFile, string, MyTask.access$getComparedBranch$p(this.this$0)));
                    }
                    {
                        this.this$0 = myTask;
                    }
                });
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.exception = e;
            }
        }

        public void onFinished() {
            DeepComparator.this.progressIndicator = null;
        }

        public void onSuccess() {
            if (this.exception != null) {
                DeepComparator.this.nonPickedCommits = null;
                VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
                String string = "Couldn't compare with branch " + this.comparedBranch;
                VcsException vcsException = this.exception;
                if (vcsException == null) {
                    Intrinsics.throwNpe();
                }
                vcsNotifier.notifyError(string, vcsException.getMessage());
                return;
            }
            DeepComparator.this.nonPickedCommits = this.collectedNonPickedCommits;
        }

        private final TIntHashSet getNonPickedCommitsFromGit(VirtualFile root, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(this.getProject(), root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            TIntHashSet pickedCommits = new TIntHashSet();
            handler.addLineListener(new GitLineHandlerListener(this, pickedCommits, root){
                final /* synthetic */ MyTask this$0;
                final /* synthetic */ TIntHashSet $pickedCommits;
                final /* synthetic */ VirtualFile $root;

                /*
                 * WARNING - void declaration
                 */
                public final void onLineAvailable(String l, Key<Object> $noName_1) {
                    String line;
                    String string = line = l;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                    if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
                        try {
                            int firstSpace;
                            void $receiver$iv;
                            String string2 = line;
                            int n = 2;
                            String string3 = string2.substring(n);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                            string2 = string3;
                            CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $receiver$iv$iv.charAt(index$iv$iv);
                                boolean bl = match$iv$iv = it <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((firstSpace = StringsKt.indexOf$default((CharSequence)(line = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)' ', (int)0, (boolean)false, (int)6, null)) > 0) {
                                $receiver$iv$iv = line;
                                int n2 = 0;
                                CharSequence charSequence = $receiver$iv$iv;
                                if (charSequence == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string4 = ((String)charSequence).substring(n2, firstSpace);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                line = string4;
                            }
                            Hash hash = HashImpl.build((String)line);
                            this.$pickedCommits.add(DeepComparator.access$getDataProvider$p(this.this$0.DeepComparator.this).getCommitIndex(hash, this.$root));
                        }
                        catch (Exception e) {
                            DeepComparator.access$getLOG$cp().error("Couldn't parse line [" + line + ']');
                        }
                    }
                }
                {
                    this.this$0 = myTask;
                    this.$pickedCommits = tIntHashSet;
                    this.$root = virtualFile;
                }
            });
            Git.getInstance().runCommandWithoutCollectingOutput(handler);
            return pickedCommits;
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithCurrentBranches;
        }

        public MyTask(@NotNull Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches, String comparedBranch) {
            Intrinsics.checkParameterIsNotNull(repositoriesWithCurrentBranches, (String)"repositoriesWithCurrentBranches");
            Intrinsics.checkParameterIsNotNull((Object)comparedBranch, (String)"comparedBranch");
            super(DeepComparator.this.project, "Comparing Branches...");
            this.repositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.comparedBranch = comparedBranch;
            this.collectedNonPickedCommits = new TIntHashSet();
        }

        @NotNull
        public static final /* synthetic */ TIntHashSet access$getCollectedNonPickedCommits$p(MyTask $this) {
            return $this.collectedNonPickedCommits;
        }

        @NotNull
        public static final /* synthetic */ TIntHashSet access$getNonPickedCommitsFromGit(MyTask $this, @NotNull VirtualFile root, @NotNull String currentBranch, @NotNull String comparedBranch) {
            return $this.getNonPickedCommitsFromGit(root, currentBranch, comparedBranch);
        }

        @NotNull
        public static final /* synthetic */ String access$getComparedBranch$p(MyTask $this) {
            return $this.comparedBranch;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/branch/DeepComparator$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logDataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logDataManager, @NotNull VcsLogUi logUi) {
            Intrinsics.checkParameterIsNotNull((Object)logDataManager, (String)"logDataManager");
            Intrinsics.checkParameterIsNotNull((Object)logUi, (String)"logUi");
            Project project = logDataManager.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"logDataManager.project");
            return Companion.getInstance(project, (VcsLogDataProvider)logDataManager, logUi);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            return "Cherry Picked Commits";
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "()V", "HIGHLIGHTING_CANCELLED", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lgit4idea/branch/DeepComparator;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/VcsLogDataProvider;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogDataProvider dataProvider, @NotNull VcsLogUi logUi) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
            Intrinsics.checkParameterIsNotNull((Object)logUi, (String)"logUi");
            DeepComparator deepComparator = ((DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class)).getInstance(dataProvider, logUi);
            Intrinsics.checkExpressionValueIsNotNull((Object)deepComparator, (String)"ServiceManager.getServic\u2026ance(dataProvider, logUi)");
            return deepComparator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

