/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import git4idea.commands.BufferingTextSplitter;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLineHandler
extends GitTextHandler {
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;
    @NotNull
    private Collection<String> myUrls;
    private boolean myIgnoreAuthenticationRequest;
    @Nullable
    private GitAuthenticationGate myAuthenticationGate;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(2);
        }
        super(project, directory, command);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(3);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(5);
        }
        super(project, vcsRoot, command);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(8);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(9);
        }
        super(project, vcsRoot, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
    }

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull String pathToExecutable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(10);
        }
        if (pathToExecutable == null) {
            GitLineHandler.$$$reportNull$$$0(11);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(12);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(13);
        }
        super(project, directory, pathToExecutable, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            GitLineHandler.$$$reportNull$$$0(14);
        }
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            GitLineHandler.$$$reportNull$$$0(15);
        }
        this.myUrls = urls;
    }

    @NotNull
    public Collection<String> getUrls() {
        Collection<String> collection = this.myUrls;
        if (collection == null) {
            GitLineHandler.$$$reportNull$$$0(16);
        }
        return collection;
    }

    protected boolean isRemote() {
        return !this.myUrls.isEmpty();
    }

    public boolean isIgnoreAuthenticationRequest() {
        return this.myIgnoreAuthenticationRequest;
    }

    public void setIgnoreAuthenticationRequest(boolean ignoreAuthenticationRequest) {
        this.myIgnoreAuthenticationRequest = ignoreAuthenticationRequest;
    }

    @Nullable
    public GitAuthenticationGate getAuthenticationGate() {
        return this.myAuthenticationGate;
    }

    public void setAuthenticationGate(@NotNull GitAuthenticationGate authenticationGate) {
        if (authenticationGate == null) {
            GitLineHandler.$$$reportNull$$$0(17);
        }
        this.myAuthenticationGate = authenticationGate;
    }

    @Override
    protected void processTerminated(int exitCode) {
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener((ProcessEventListener)listener);
        this.myLineListeners.addListener((EventListener)((Object)listener));
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        this.notifyLine(text, outputType);
    }

    private void notifyLine(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            GitLineHandler.$$$reportNull$$$0(18);
        }
        if (outputType == null) {
            GitLineHandler.$$$reportNull$$$0(19);
        }
        String lineWithoutSeparator = LineHandlerHelper.trimLineSeparator((String)line);
        if (!line.endsWith("\r")) {
            this.logOutput(lineWithoutSeparator, outputType);
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(lineWithoutSeparator, outputType);
    }

    private void logOutput(@NotNull String line, @NotNull Key outputType) {
        String trimmedLine;
        if (line == null) {
            GitLineHandler.$$$reportNull$$$0(20);
        }
        if (outputType == null) {
            GitLineHandler.$$$reportNull$$$0(21);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(trimmedLine = line.trim())) && !this.mySilent && (outputType == ProcessOutputTypes.STDOUT && !this.isStdoutSuppressed() || outputType == ProcessOutputTypes.STDERR && !this.isStderrSuppressed())) {
            LOG.info(trimmedLine);
        } else {
            OUTPUT_LOG.debug(trimmedLine);
        }
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitLineHandler.$$$reportNull$$$0(22);
        }
        return new GitTextHandler.MyOSProcessHandler(commandLine, this.myWithMediator && Registry.is((String)"git.execute.with.mediator")){

            @NotNull
            protected BaseDataReader createOutputDataReader() {
                LineReader lineReader = new LineReader(this.createProcessOutReader(), this.readerOptions().policy(), new BufferingTextSplitter(line -> this.notifyTextAvailable((String)line, ProcessOutputTypes.STDOUT)), this.myPresentableName);
                if (lineReader == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lineReader;
            }

            @NotNull
            protected BaseDataReader createErrorDataReader() {
                LineReader lineReader = new LineReader(this.createProcessErrReader(), this.readerOptions().policy(), new BufferingTextSplitter(line -> this.notifyTextAvailable((String)line, ProcessOutputTypes.STDERR)), this.myPresentableName);
                if (lineReader == null) {
                    1.$$$reportNull$$$0(1);
                }
                return lineReader;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "git4idea/commands/GitLineHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createOutputDataReader";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createErrorDataReader";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToExecutable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationGate";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAuthenticationGate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyLine";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "logOutput";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineReader
    extends BaseDataReader {
        @NotNull
        private final Reader myReader;
        @NotNull
        private final char[] myInputBuffer;
        @NotNull
        private final BufferingTextSplitter myOutputProcessor;

        LineReader(@NotNull Reader reader, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy, @NotNull BufferingTextSplitter outputProcessor, @NotNull String presentableName) {
            if (reader == null) {
                LineReader.$$$reportNull$$$0(0);
            }
            if (sleepingPolicy == null) {
                LineReader.$$$reportNull$$$0(1);
            }
            if (outputProcessor == null) {
                LineReader.$$$reportNull$$$0(2);
            }
            if (presentableName == null) {
                LineReader.$$$reportNull$$$0(3);
            }
            super(sleepingPolicy);
            this.myInputBuffer = new char[8192];
            this.myReader = reader;
            this.myOutputProcessor = outputProcessor;
            this.start(presentableName);
        }

        protected boolean readAvailableNonBlocking() throws IOException {
            return this.read(true);
        }

        protected boolean readAvailableBlocking() throws IOException {
            return this.read(false);
        }

        private boolean read(boolean checkReaderReady) throws IOException {
            int n;
            boolean read = false;
            while ((!checkReaderReady || this.myReader.ready()) && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.myOutputProcessor.process(this.myInputBuffer, n);
            }
            return read;
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                LineReader.$$$reportNull$$$0(4);
            }
            Future<?> future = ProcessIOExecutorService.INSTANCE.submit(runnable);
            if (future == null) {
                LineReader.$$$reportNull$$$0(5);
            }
            return future;
        }

        protected void close() throws IOException {
            try {
                this.myReader.close();
            }
            finally {
                this.myOutputProcessor.flush();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sleepingPolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitLineHandler$LineReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitLineHandler$LineReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

