/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiMessage;
import com.intellij.dvcs.MultiRootMessage;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRestrictingAuthenticationGate;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.fetch.GitFetchSupportImpl;
import git4idea.fetch.GitFetchSupportImplKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0006345678B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\u001c\u0010\f\u001a\u00020\u00172\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0016J.\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001d0\u00182\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020#H\u0002J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\rH\u0002J\u001c\u0010&\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J.\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u00182\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001d0\u0018H\u0002J)\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0002\u00a2\u0006\u0002\u00100J)\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0006\u00101\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0002\u00a2\u0006\u0002\u00102R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl;", "Lgit4idea/fetch/GitFetchSupport;", "git", "Lgit4idea/commands/Git;", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "(Lgit4idea/commands/Git;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressManager;Lcom/intellij/openapi/vcs/VcsNotifier;)V", "Lgit4idea/commands/GitImpl;", "doFetch", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "authenticationGate", "Lgit4idea/commands/GitAuthenticationGate;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "remotes", "", "Lgit4idea/fetch/GitFetchResult;", "", "fetch", "repositories", "", "fetchInParallel", "Ljava/util/concurrent/Future;", "getDefaultRemoteToFetch", "getMaxThreads", "", "numberOfRemotes", "getProgressTitle", "", "getPrunedRef", "line", "resultOf", "remoteResult", "Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "results", "waitForFetchTasks", "tasks", "withIndicator", "T", "operation", "Lkotlin/Function0;", "(Lgit4idea/repo/GitRepository;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "title", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "CancelledRepoResult", "ErrorRepoResult", "FetchResultImpl", "RepoResult", "RepoResultPerRemote", "SingleRemoteResult", "intellij.vcs.git"})
public final class GitFetchSupportImpl
implements GitFetchSupport {
    private final GitImpl git;
    private final Project project;
    private final ProgressManager progressManager;
    private final VcsNotifier vcsNotifier;

    @Override
    @Nullable
    public GitRemote getDefaultRemoteToFetch(@NotNull GitRepository repository) {
        Comparable<GitReference> comparable;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Collection<GitRemote> remotes = repository.getRemotes();
        if (remotes.isEmpty()) {
            comparable = null;
        } else if (remotes.size() == 1) {
            Collection<GitRemote> collection = remotes;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"remotes");
            comparable = (GitRemote)CollectionsKt.first((Iterable)collection);
        } else {
            comparable = repository.getCurrentBranch();
            if (comparable == null || (comparable = ((GitLocalBranch)comparable).findTrackedBranch(repository)) == null || (comparable = ((GitRemoteBranch)comparable).getRemote()) == null) {
                comparable = GitUtil.findRemoteByName(repository, "origin");
            }
        }
        return comparable;
    }

    @NotNull
    public GitFetchResult fetch(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Map remotesToFetch = new LinkedHashMap();
        for (GitRepository gitRepository : repositories) {
            GitRemote remote = this.getDefaultRemoteToFetch(gitRepository);
            if (remote != null) {
                Map map2 = remotesToFetch;
                GitRemote gitRemote = remote;
                map2.put(gitRepository, gitRemote);
                continue;
            }
            GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
        }
        return this.doFetch(remotesToFetch);
    }

    private final GitFetchResult doFetch(Map<GitRepository, GitRemote> remotes) {
        Map<GitRepository, Future<RepoResult>> tasks = this.fetchInParallel(remotes);
        Map<GitRepository, RepoResult> results = this.waitForFetchTasks(tasks);
        return new FetchResultImpl(this.project, this.vcsNotifier, results);
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        return (GitFetchResult)this.withIndicator(repository, (Function0)new Function0<GitFetchResult>(this, repository, remote){
            final /* synthetic */ GitFetchSupportImpl this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;

            @NotNull
            public final GitFetchResult invoke() {
                return this.this$0.fetch(this.$repository, CollectionsKt.listOf((Object)this.$remote));
            }
            {
                this.this$0 = gitFetchSupportImpl;
                this.$repository = gitRepository;
                this.$remote = gitRemote;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull List<GitRemote> remotes) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(remotes, (String)"remotes");
        return (GitFetchResult)this.withIndicator(repository, (Function0)new Function0<FetchResultImpl>(this, repository, remotes){
            final /* synthetic */ GitFetchSupportImpl this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ List $remotes;

            @NotNull
            public final FetchResultImpl invoke() {
                return GitFetchSupportImpl.access$resultOf(this.this$0, MapsKt.mapOf((Pair)new Pair((Object)this.$repository, (Object)GitFetchSupportImpl.access$doFetch(this.this$0, this.$repository, this.$remotes))));
            }
            {
                this.this$0 = gitFetchSupportImpl;
                this.$repository = gitRepository;
                this.$remotes = list;
                super(0);
            }
        });
    }

    private final Map<GitRepository, Future<RepoResult>> fetchInParallel(Map<GitRepository, GitRemote> remotes) {
        Map tasks = new LinkedHashMap();
        int maxThreads = Math.min(this.getMaxThreads(remotes.size()), 10);
        GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remotes + " using " + maxThreads + " threads");
        ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitFetch pool", (int)maxThreads);
        ProgressIndicator progressIndicator = this.progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator commonIndicator = progressIndicator;
        GitRestrictingAuthenticationGate authenticationGate = new GitRestrictingAuthenticationGate();
        Map<GitRepository, GitRemote> map2 = remotes;
        Iterator<Map.Entry<GitRepository, GitRemote>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Future task2;
            Map.Entry<GitRepository, GitRemote> entry;
            Map.Entry<GitRepository, GitRemote> entry2 = entry = iterator.next();
            GitRepository repository = entry2.getKey();
            entry2 = entry;
            GitRemote remote = entry2.getValue();
            GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remote + " in " + repository);
            Intrinsics.checkExpressionValueIsNotNull(executor.submit((Callable)new Callable<RepoResult>(this, commonIndicator, repository, remote, authenticationGate){
                final /* synthetic */ GitFetchSupportImpl this$0;
                final /* synthetic */ ProgressIndicator $commonIndicator;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ GitRemote $remote;
                final /* synthetic */ GitRestrictingAuthenticationGate $authenticationGate;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final RepoResult call() {
                    void result2;
                    this.$commonIndicator.checkCanceled();
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(this, (Ref.ObjectRef)result2){
                        final /* synthetic */ fetchInParallel.task.1 this$0;
                        final /* synthetic */ Ref.ObjectRef $result;

                        public final void run() {
                            this.this$0.$commonIndicator.checkCanceled();
                            SingleRemoteResult fetchResult = GitFetchSupportImpl.access$doFetch(this.this$0.this$0, this.this$0.$repository, this.this$0.$remote, this.this$0.$authenticationGate);
                            this.$result.element = GitFetchSupportImpl.access$resultOf(this.this$0.this$0, this.this$0.$remote, fetchResult);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = objectRef;
                        }
                    }, this.$commonIndicator);
                    Object object = result2.element;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                    }
                    return (RepoResult)object;
                }
                {
                    this.this$0 = gitFetchSupportImpl;
                    this.$commonIndicator = progressIndicator;
                    this.$repository = gitRepository;
                    this.$remote = gitRemote;
                    this.$authenticationGate = gitRestrictingAuthenticationGate;
                }
            }), (String)"executor.submit<RepoResu\u2026r)\n        result\n      }");
            Map map3 = tasks;
            Future future = task2;
            map3.put(repository, future);
        }
        return tasks;
    }

    private final int getMaxThreads(int numberOfRemotes) {
        int maxThreads = Registry.intValue((String)"git.parallel.fetch.threads");
        return maxThreads > 0 ? maxThreads : (maxThreads == -1 ? Runtime.getRuntime().availableProcessors() : (maxThreads == -2 ? numberOfRemotes : (maxThreads == -3 ? Math.min(numberOfRemotes, Runtime.getRuntime().availableProcessors() * 2) : 1)));
    }

    private final Map<GitRepository, RepoResult> waitForFetchTasks(Map<GitRepository, ? extends Future<RepoResult>> tasks) {
        Map results = new LinkedHashMap();
        Map<GitRepository, ? extends Future<RepoResult>> map2 = tasks;
        for (Map.Entry<GitRepository, ? extends Future<RepoResult>> entry : map2.entrySet()) {
            Map map3;
            Object object = entry;
            GitRepository repository = object.getKey();
            object = entry;
            Future<RepoResult> task2 = object.getValue();
            try {
                object = results;
                Intrinsics.checkExpressionValueIsNotNull((Object)task2.get(), (String)"task.get()");
                object.put(repository, map3);
            }
            catch (CancellationException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    }
                    throw (Throwable)((ProcessCanceledException)throwable);
                }
                map3 = results;
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                ErrorRepoResult errorRepoResult = new ErrorRepoResult(string);
                map3.put(repository, errorRepoResult);
                GitFetchSupportImplKt.access$getLOG$p().error((Throwable)e);
            }
        }
        return results;
    }

    private final <T> T withIndicator(GitRepository repository, Function0<? extends T> operation) {
        return this.withIndicator(this.getProgressTitle(repository), operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withIndicator(String title, Function0<? extends T> operation) {
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = indicator = this.progressManager.getProgressIndicator();
        String prevText = progressIndicator != null ? progressIndicator.getText() : null;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(title);
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            block4: {
                ProgressIndicator progressIndicator3 = indicator;
                if (progressIndicator3 == null) break block4;
                progressIndicator3.setText(prevText);
            }
        }
    }

    private final String getProgressTitle(GitRepository repository) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("Fetching ");
        if (GitUtil.justOneGitRepository(this.project)) {
            string = "";
        } else {
            String string2 = DvcsUtil.getShortRepositoryName((Repository)repository);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getShortRepositoryName(repository)");
        }
        return stringBuilder.append(string).toString();
    }

    private final RepoResult doFetch(GitRepository repository, List<GitRemote> remotes) {
        Map results = new LinkedHashMap();
        for (GitRemote remote : remotes) {
            Map map2 = results;
            SingleRemoteResult singleRemoteResult = GitFetchSupportImpl.doFetch$default(this, repository, remote, null, 4, null);
            map2.put(remote, singleRemoteResult);
        }
        return new RepoResultPerRemote(results);
    }

    /*
     * WARNING - void declaration
     */
    private final SingleRemoteResult doFetch(GitRepository repository, GitRemote remote, GitAuthenticationGate authenticationGate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        GitCommandResult result2;
        GitCommandResult gitCommandResult = result2 = this.git.fetch(repository, remote, (List<GitLineHandlerListener>)CollectionsKt.emptyList(), authenticationGate, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"result");
        List<String> list = gitCommandResult.getOutput();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"result.output");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            String it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            String string2 = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (this.getPrunedRef(string2) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        List pruned = (List)destination$iv$iv;
        if (result2.success()) {
            repository.update();
        }
        String error = result2.success() ? null : result2.getErrorOutputAsJoinedString();
        return new SingleRemoteResult(error, pruned);
    }

    static /* synthetic */ SingleRemoteResult doFetch$default(GitFetchSupportImpl gitFetchSupportImpl, GitRepository gitRepository, GitRemote gitRemote, GitAuthenticationGate gitAuthenticationGate, int n, Object object) {
        if ((n & 4) != 0) {
            gitAuthenticationGate = null;
        }
        return gitFetchSupportImpl.doFetch(gitRepository, gitRemote, gitAuthenticationGate);
    }

    private final String getPrunedRef(String line) {
        Matcher matcher = GitFetchSupportImplKt.access$getPRUNE_PATTERN$p().matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private final RepoResult resultOf(GitRemote remote, SingleRemoteResult remoteResult) {
        return new RepoResultPerRemote(MapsKt.mapOf((Pair)new Pair((Object)remote, (Object)remoteResult)));
    }

    private final FetchResultImpl resultOf(Map<GitRepository, ? extends RepoResult> results) {
        return new FetchResultImpl(this.project, this.vcsNotifier, results);
    }

    public GitFetchSupportImpl(@NotNull Git git, @NotNull Project project, @NotNull ProgressManager progressManager, @NotNull VcsNotifier vcsNotifier) {
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)vcsNotifier, (String)"vcsNotifier");
        this.project = project;
        this.progressManager = progressManager;
        this.vcsNotifier = vcsNotifier;
        this.git = (GitImpl)git;
    }

    @NotNull
    public static final /* synthetic */ FetchResultImpl access$resultOf(GitFetchSupportImpl $this, @NotNull Map results) {
        return $this.resultOf(results);
    }

    @NotNull
    public static final /* synthetic */ RepoResult access$doFetch(GitFetchSupportImpl $this, @NotNull GitRepository repository, @NotNull List remotes) {
        return $this.doFetch(repository, remotes);
    }

    @NotNull
    public static final /* synthetic */ SingleRemoteResult access$doFetch(GitFetchSupportImpl $this, @NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable GitAuthenticationGate authenticationGate) {
        return $this.doFetch(repository, remote, authenticationGate);
    }

    @NotNull
    public static final /* synthetic */ RepoResult access$resultOf(GitFetchSupportImpl $this, @NotNull GitRemote remote, @NotNull SingleRemoteResult remoteResult) {
        return $this.resultOf(remote, remoteResult);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "", "error", "", "prunedRefs", "totallySuccessful", "", "intellij.vcs.git"})
    private static interface RepoResult {
        public boolean totallySuccessful();

        @Nullable
        public String error();

        @NotNull
        public String prunedRefs();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$ErrorRepoResult;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "prunedRefs", "totallySuccessful", "", "intellij.vcs.git"})
    private static final class ErrorRepoResult
    implements RepoResult {
        @NotNull
        private final String error;

        @Override
        public boolean totallySuccessful() {
            return false;
        }

        @Override
        @NotNull
        public String error() {
            return this.error;
        }

        @Override
        @NotNull
        public String prunedRefs() {
            return "";
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        public ErrorRepoResult(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            this.error = error;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$CancelledRepoResult;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "()V", "error", "", "prunedRefs", "totallySuccessful", "", "intellij.vcs.git"})
    private static final class CancelledRepoResult
    implements RepoResult {
        @Override
        public boolean totallySuccessful() {
            return false;
        }

        @Override
        @NotNull
        public String error() {
            return "cancelled";
        }

        @Override
        @NotNull
        public String prunedRefs() {
            return "";
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResultPerRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "results", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Ljava/util/Map;)V", "getResults", "()Ljava/util/Map;", "error", "", "multiRemoteMessage", "Lcom/intellij/dvcs/MultiMessage;", "remoteInPrefix", "", "prunedRefs", "totallySuccessful", "intellij.vcs.git"})
    private static final class RepoResultPerRemote
    implements RepoResult {
        @NotNull
        private final Map<GitRemote, SingleRemoteResult> results;

        @Override
        public boolean totallySuccessful() {
            boolean bl;
            block3: {
                Iterable $receiver$iv = this.results.values();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        SingleRemoteResult it = (SingleRemoteResult)element$iv;
                        if (it.success()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        @Nullable
        public String error() {
            MultiMessage<GitRemote> errorMessage = this.multiRemoteMessage(true);
            Map<GitRemote, SingleRemoteResult> map2 = this.results;
            Iterator<Map.Entry<GitRemote, SingleRemoteResult>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GitRemote, SingleRemoteResult> entry;
                Map.Entry<GitRemote, SingleRemoteResult> entry2 = entry = iterator.next();
                GitRemote remote = entry2.getKey();
                entry2 = entry;
                SingleRemoteResult result2 = entry2.getValue();
                if (result2.getError() == null) continue;
                errorMessage.append((Object)remote, result2.getError());
            }
            return errorMessage.asString();
        }

        @Override
        @NotNull
        public String prunedRefs() {
            MultiMessage<GitRemote> prunedRefs = this.multiRemoteMessage(false);
            Map<GitRemote, SingleRemoteResult> map2 = this.results;
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : map2.entrySet()) {
                Object object = entry;
                GitRemote remote = object.getKey();
                object = entry;
                SingleRemoteResult result2 = object.getValue();
                if (!(!(object = (Collection)result2.getPrunedRefs()).isEmpty())) continue;
                prunedRefs.append((Object)remote, CollectionsKt.joinToString$default((Iterable)result2.getPrunedRefs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            return prunedRefs.asString();
        }

        private final MultiMessage<GitRemote> multiRemoteMessage(boolean remoteInPrefix) {
            return new MultiMessage((Collection)this.results.keySet(), (Function1)multiRemoteMessage.1.INSTANCE, (Function1)multiRemoteMessage.2.INSTANCE, remoteInPrefix, false, 16, null);
        }

        @NotNull
        public final Map<GitRemote, SingleRemoteResult> getResults() {
            return this.results;
        }

        public RepoResultPerRemote(@NotNull Map<GitRemote, SingleRemoteResult> results) {
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.results = results;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "", "error", "", "prunedRefs", "", "(Ljava/lang/String;Ljava/util/List;)V", "getError", "()Ljava/lang/String;", "getPrunedRefs", "()Ljava/util/List;", "success", "", "intellij.vcs.git"})
    private static final class SingleRemoteResult {
        @Nullable
        private final String error;
        @NotNull
        private final List<String> prunedRefs;

        public final boolean success() {
            return this.error == null;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<String> getPrunedRefs() {
            return this.prunedRefs;
        }

        public SingleRemoteResult(@Nullable String error, @NotNull List<String> prunedRefs) {
            Intrinsics.checkParameterIsNotNull(prunedRefs, (String)"prunedRefs");
            this.error = error;
            this.prunedRefs = prunedRefs;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "Lgit4idea/fetch/GitFetchResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "results", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsNotifier;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResults", "()Ljava/util/Map;", "getVcsNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "doShowNotification", "", "failureTitle", "", "prefixWithBr", "text", "showNotification", "showNotificationIfFailed", "", "title", "intellij.vcs.git"})
    private static final class FetchResultImpl
    implements GitFetchResult {
        @NotNull
        private final Project project;
        @NotNull
        private final VcsNotifier vcsNotifier;
        @NotNull
        private final Map<GitRepository, RepoResult> results;

        @Override
        public void showNotification() {
            FetchResultImpl.doShowNotification$default(this, null, 1, null);
        }

        @Override
        public boolean showNotificationIfFailed() {
            return this.showNotificationIfFailed("Fetch Failed");
        }

        @Override
        public boolean showNotificationIfFailed(@NotNull String title) {
            boolean failure;
            block4: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                Iterable $receiver$iv = this.results.values();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        RepoResult it = (RepoResult)element$iv;
                        if (!(!it.totallySuccessful())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = failure = false;
                }
            }
            if (failure) {
                this.doShowNotification(title);
            }
            return !failure;
        }

        /*
         * WARNING - void declaration
         */
        private final void doShowNotification(String failureTitle) {
            String string;
            NotificationType type;
            RepoResult result2;
            Object repo;
            Map failed;
            Map.Entry<GitRepository, RepoResult> entry$iv2;
            Map it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.results.keySet();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                VirtualFile virtualFile = it.getRoot();
                collection.add(virtualFile);
            }
            List roots = (List)destination$iv$iv;
            MultiRootMessage errorMessage = new MultiRootMessage(this.project, (Collection)roots, true, false, 8, null);
            MultiRootMessage prunedRefs = new MultiRootMessage(this.project, (Collection)roots, false, false, 12, null);
            Map.Entry<GitRepository, RepoResult> $receiver$iv2 = this.results;
            Iterator<Map.Entry<GitRepository, RepoResult>> result$iv = new LinkedHashMap();
            it = $receiver$iv2;
            for (Map.Entry<GitRepository, RepoResult> entry$iv2 : it.entrySet()) {
                RepoResult it2 = entry$iv2.getValue();
                if (!(!it2.totallySuccessful())) continue;
                ((HashMap)((Object)result$iv)).put(entry$iv2.getKey(), entry$iv2.getValue());
            }
            it = failed = (Map)((Object)result$iv);
            result$iv = it.entrySet().iterator();
            while (result$iv.hasNext()) {
                entry$iv2 = $receiver$iv2 = (Map.Entry)result$iv.next();
                repo = (GitRepository)entry$iv2.getKey();
                entry$iv2 = $receiver$iv2;
                result2 = (RepoResult)entry$iv2.getValue();
                if (result2.error() == null) continue;
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
                String string2 = result2.error();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                errorMessage.append((Object)virtualFile, string2);
            }
            repo = this.results;
            result$iv = repo.entrySet().iterator();
            while (result$iv.hasNext()) {
                entry$iv2 = $receiver$iv2 = result$iv.next();
                repo = entry$iv2.getKey();
                entry$iv2 = $receiver$iv2;
                result2 = entry$iv2.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
                prunedRefs.append((Object)virtualFile, result2.prunedRefs());
            }
            NotificationType notificationType = type = failed.isEmpty() ? NotificationType.INFORMATION : NotificationType.ERROR;
            if (failed.size() == roots.size()) {
                string = "";
            } else {
                String string3 = GitUtil.mention(failed.keySet());
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mention(failed.keys)");
            }
            String mentionFailedRepos = string;
            String title = failed.isEmpty() ? "<b>Fetch Successful</b>" : "<b>" + failureTitle + "</b>" + mentionFailedRepos;
            String message = title + this.prefixWithBr(errorMessage.asString()) + this.prefixWithBr(prunedRefs.asString());
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, type, null);
            this.vcsNotifier.notify(notification);
        }

        static /* synthetic */ void doShowNotification$default(FetchResultImpl fetchResultImpl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "Fetch Failed";
            }
            fetchResultImpl.doShowNotification(string);
        }

        private final String prefixWithBr(String text) {
            CharSequence charSequence = text;
            return charSequence.length() > 0 ? "<br/>" + text : "";
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsNotifier getVcsNotifier() {
            return this.vcsNotifier;
        }

        @NotNull
        public final Map<GitRepository, RepoResult> getResults() {
            return this.results;
        }

        public FetchResultImpl(@NotNull Project project, @NotNull VcsNotifier vcsNotifier, @NotNull Map<GitRepository, ? extends RepoResult> results) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)vcsNotifier, (String)"vcsNotifier");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.project = project;
            this.vcsNotifier = vcsNotifier;
            this.results = results;
        }
    }
}

