/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.history.GitLogUtil;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer;", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "gitMergeProvider", "Lgit4idea/merge/GitMergeProvider;", "(Lgit4idea/merge/GitMergeProvider;)V", "project", "Lcom/intellij/openapi/project/Project;", "getLeftPanelTitle", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMultipleFileMergeDescription", "files", "", "getRightPanelTitle", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "loadCherryPickCommitDetails", "Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "root", "CherryPickDetails", "intellij.vcs.git"})
public class GitDefaultMergeDialogCustomizer
extends MergeDialogCustomizer {
    private final Project project;
    private final GitMergeProvider gitMergeProvider;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        boolean bl;
        List cherryPickCommitDetails;
        block28: {
            Iterator $receiver$iv$iv;
            Object element$iv3;
            boolean bl2;
            List rebaseOntoBranches;
            Object object;
            CherryPickDetails it;
            Collection collection;
            Map<VirtualFile, List<VirtualFile>> filesByRoot;
            block27: {
                Iterator $receiver$iv$iv2;
                Object it2;
                Object element$iv2;
                block29: {
                    String string;
                    Object object2;
                    Object $receiver$iv;
                    block33: {
                        block32: {
                            String $i$f$any;
                            String string2;
                            Object object3;
                            Object $receiver;
                            Object it3;
                            block31: {
                                block30: {
                                    boolean bl3;
                                    List mergeBranches;
                                    block26: {
                                        Iterator $receiver$iv$iv3;
                                        Intrinsics.checkParameterIsNotNull(files, (String)"files");
                                        filesByRoot = GitUtil.sortFilesByGitRoot(files);
                                        $receiver$iv = filesByRoot.keySet();
                                        Iterable iterable = $receiver$iv;
                                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                        Iterator iterator = $receiver$iv$iv3.iterator();
                                        while (iterator.hasNext()) {
                                            Object item$iv$iv = iterator.next();
                                            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                                            collection = destination$iv$iv;
                                            object = this.gitMergeProvider.resolveMergeBranch((VirtualFile)it);
                                            collection.add(object);
                                        }
                                        mergeBranches = (List)destination$iv$iv;
                                        $receiver$iv = mergeBranches;
                                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                            bl3 = false;
                                        } else {
                                            $receiver$iv$iv3 = $receiver$iv.iterator();
                                            while ($receiver$iv$iv3.hasNext()) {
                                                element$iv2 = $receiver$iv$iv3.next();
                                                it3 = (String)element$iv2;
                                                if (!(it3 != null)) continue;
                                                bl3 = true;
                                                break block26;
                                            }
                                            bl3 = false;
                                        }
                                    }
                                    if (!bl3) break block29;
                                    $receiver = $receiver$iv = new StringBuilder();
                                    ((StringBuilder)$receiver).append("<html>Merging ");
                                    object3 = $receiver;
                                    string2 = (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)mergeBranches));
                                    if (string2 == null) break block30;
                                    element$iv2 = string2;
                                    it3 = object3;
                                    it2 = element$iv2;
                                    $i$f$any = "branch <b>" + XmlStringUtil.escapeString((String)it2) + "</b>";
                                    object3 = it3;
                                    string2 = $i$f$any;
                                    if (string2 != null) break block31;
                                }
                                string2 = "diverging branches ";
                            }
                            ((StringBuilder)object3).append(string2);
                            ((StringBuilder)$receiver).append(" into ");
                            object2 = $receiver;
                            string = this.gitMergeProvider.getSingleCurrentBranchName((Collection<VirtualFile>)filesByRoot.keySet());
                            if (string == null) break block32;
                            element$iv2 = string;
                            it3 = object2;
                            it2 = element$iv2;
                            $i$f$any = "branch <b>" + XmlStringUtil.escapeString((String)it2) + "</b>";
                            object2 = it3;
                            string = $i$f$any;
                            if (string != null) break block33;
                        }
                        string = "diverging branches";
                    }
                    ((StringBuilder)object2).append(string);
                    String string3 = ((StringBuilder)$receiver$iv).toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                    return string3;
                }
                Iterable $receiver$iv = filesByRoot.keySet();
                element$iv2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                it2 = $receiver$iv$iv2.iterator();
                while (it2.hasNext()) {
                    void it4;
                    Object item$iv$iv = it2.next();
                    VirtualFile $i$a$2$let = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    object = this.gitMergeProvider.resolveRebaseOntoBranch((VirtualFile)it4);
                    collection.add(object);
                }
                rebaseOntoBranches = (List)destination$iv$iv;
                $receiver$iv = rebaseOntoBranches;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv3 : $receiver$iv) {
                        it2 = (String)element$iv3;
                        if (!(it2 != null)) continue;
                        bl2 = true;
                        break block27;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                String singleCurrentBranch = this.gitMergeProvider.getSingleCurrentBranchName((Collection<VirtualFile>)filesByRoot.keySet());
                String singleOntoBranch = (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)rebaseOntoBranches));
                return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase$default(singleCurrentBranch, singleOntoBranch, false, 4, null);
            }
            Iterable $receiver$iv = filesByRoot.keySet();
            element$iv3 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator $i$a$3$any = $receiver$iv$iv.iterator();
            while ($i$a$3$any.hasNext()) {
                void it5;
                Object item$iv$iv = $i$a$3$any.next();
                VirtualFile $i$a$1$map = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                void v7 = it5;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
                object = this.loadCherryPickCommitDetails((VirtualFile)v7);
                collection.add(object);
            }
            cherryPickCommitDetails = (List)destination$iv$iv;
            $receiver$iv = cherryPickCommitDetails;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv4 : $receiver$iv) {
                    it = (CherryPickDetails)element$iv4;
                    if (!(it != null)) continue;
                    bl = true;
                    break block28;
                }
                bl = false;
            }
        }
        if (bl) {
            StringBuilder stringBuilder;
            List notNullCherryPickCommitDetails = CollectionsKt.filterNotNull((Iterable)cherryPickCommitDetails);
            Iterable $receiver$iv = notNullCherryPickCommitDetails;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $receiver$iv) {
                CherryPickDetails it = (CherryPickDetails)e$iv;
                String key$iv = it.getAuthorName() + it.getCommitMessage();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            CherryPickDetails singleCherryPick = (CherryPickDetails)CollectionsKt.singleOrNull((List)list$iv);
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            $receiver.append("<html>Conflicts during cherry-picking ");
            if (notNullCherryPickCommitDetails.size() == 1) {
                $receiver.append("commit <code>" + ((CherryPickDetails)CollectionsKt.single((List)notNullCherryPickCommitDetails)).getShortHash() + "</code> ");
            } else {
                $receiver.append("multiple commits ");
            }
            if (singleCherryPick != null) {
                $receiver.append("made by " + XmlStringUtil.escapeString((String)singleCherryPick.getAuthorName()) + "<br/>");
                $receiver.append("<code>" + XmlStringUtil.escapeString((String)singleCherryPick.getCommitMessage()) + "</code>");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
        String string = super.getMultipleFileMergeDescription(files);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getMultipleFileMergeDescription(files)");
        return string;
    }

    @NotNull
    public String getLeftPanelTitle(@NotNull VirtualFile file) {
        String string;
        String currentBranch;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFile(file);
        String string2 = currentBranch = gitRepository != null ? gitRepository.getCurrentBranchName() : null;
        if (currentBranch != null) {
            string = GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(currentBranch);
        } else {
            String string3 = super.getLeftPanelTitle(file);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"super.getLeftPanelTitle(file)");
        }
        return string;
    }

    @NotNull
    public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
        GitRevisionNumber gitRevisionNumber;
        String branchBeingMerged;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFile(file);
        if (gitRepository == null) {
            String string = super.getRightPanelTitle(file, revisionNumber);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getRightPanelTitle(file, revisionNumber)");
            return string;
        }
        GitRepository repository = gitRepository;
        String string = this.gitMergeProvider.resolveMergeBranch(repository);
        if (string == null) {
            GitRepository gitRepository2 = repository;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository2, (String)"repository");
            string = branchBeingMerged = this.gitMergeProvider.resolveRebaseOntoBranch(gitRepository2.getRoot());
        }
        if (branchBeingMerged != null) {
            return GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch$default(branchBeingMerged, revisionNumber, false, 4, null);
        }
        try {
            GitRepository gitRepository3 = repository;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository3, (String)"repository");
            gitRevisionNumber = GitRevisionNumber.resolve(this.project, gitRepository3.getRoot(), "CHERRY_PICK_HEAD");
        }
        catch (VcsException e) {
            gitRevisionNumber = null;
        }
        GitRevisionNumber cherryPickHead = gitRevisionNumber;
        if (cherryPickHead != null) {
            return "<html>Changes from cherry-pick <code>" + cherryPickHead.getShortRev() + "</code>";
        }
        if (revisionNumber instanceof GitRevisionNumber) {
            String string2 = DiffBundle.message((String)"merge.version.title.their.with.revision", (Object[])new Object[]{((GitRevisionNumber)revisionNumber).getShortRev()});
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DiffBundle.message(\"merg\u2026 revisionNumber.shortRev)");
            return string2;
        }
        String string3 = super.getRightPanelTitle(file, revisionNumber);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"super.getRightPanelTitle(file, revisionNumber)");
        return string3;
    }

    private final CherryPickDetails loadCherryPickCommitDetails(VirtualFile root) {
        List<? extends VcsCommitMetadata> shortDetails;
        GitRevisionNumber gitRevisionNumber;
        try {
            gitRevisionNumber = GitRevisionNumber.resolve(this.project, root, "CHERRY_PICK_HEAD");
        }
        catch (VcsException e) {
            return null;
        }
        GitRevisionNumber cherryPickHead = gitRevisionNumber;
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        GitRevisionNumber gitRevisionNumber2 = cherryPickHead;
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRevisionNumber2, (String)"cherryPickHead");
        List<? extends VcsCommitMetadata> list = shortDetails = GitLogUtil.collectShortDetails(this.project, gitVcs, root, CollectionsKt.listOf((Object)gitRevisionNumber2.getRev()));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"shortDetails");
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.singleOrNull(list);
        if (vcsCommitMetadata == null) {
            return null;
        }
        VcsCommitMetadata result2 = vcsCommitMetadata;
        String string = cherryPickHead.getShortRev();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cherryPickHead.shortRev");
        VcsUser vcsUser = result2.getAuthor();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsUser, (String)"result.author");
        String string2 = vcsUser.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.author.name");
        String string3 = result2.getSubject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"result.subject");
        return new CherryPickDetails(string, string2, string3);
    }

    public GitDefaultMergeDialogCustomizer(@NotNull GitMergeProvider gitMergeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)gitMergeProvider, (String)"gitMergeProvider");
        this.gitMergeProvider = gitMergeProvider;
        this.project = this.gitMergeProvider.getProject();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "", "shortHash", "", "authorName", "commitMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorName", "()Ljava/lang/String;", "getCommitMessage", "getShortHash", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class CherryPickDetails {
        @NotNull
        private final String shortHash;
        @NotNull
        private final String authorName;
        @NotNull
        private final String commitMessage;

        @NotNull
        public final String getShortHash() {
            return this.shortHash;
        }

        @NotNull
        public final String getAuthorName() {
            return this.authorName;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public CherryPickDetails(@NotNull String shortHash, @NotNull String authorName, @NotNull String commitMessage) {
            Intrinsics.checkParameterIsNotNull((Object)shortHash, (String)"shortHash");
            Intrinsics.checkParameterIsNotNull((Object)authorName, (String)"authorName");
            Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
            this.shortHash = shortHash;
            this.authorName = authorName;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final String component1() {
            return this.shortHash;
        }

        @NotNull
        public final String component2() {
            return this.authorName;
        }

        @NotNull
        public final String component3() {
            return this.commitMessage;
        }

        @NotNull
        public final CherryPickDetails copy(@NotNull String shortHash, @NotNull String authorName, @NotNull String commitMessage) {
            Intrinsics.checkParameterIsNotNull((Object)shortHash, (String)"shortHash");
            Intrinsics.checkParameterIsNotNull((Object)authorName, (String)"authorName");
            Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
            return new CherryPickDetails(shortHash, authorName, commitMessage);
        }

        @NotNull
        public static /* synthetic */ CherryPickDetails copy$default(CherryPickDetails cherryPickDetails, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = cherryPickDetails.shortHash;
            }
            if ((n & 2) != 0) {
                string2 = cherryPickDetails.authorName;
            }
            if ((n & 4) != 0) {
                string3 = cherryPickDetails.commitMessage;
            }
            return cherryPickDetails.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "CherryPickDetails(shortHash=" + this.shortHash + ", authorName=" + this.authorName + ", commitMessage=" + this.commitMessage + ")";
        }

        public int hashCode() {
            String string = this.shortHash;
            String string2 = this.authorName;
            String string3 = this.commitMessage;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CherryPickDetails)) break block3;
                    CherryPickDetails cherryPickDetails = (CherryPickDetails)object;
                    if (!Intrinsics.areEqual((Object)this.shortHash, (Object)cherryPickDetails.shortHash) || !Intrinsics.areEqual((Object)this.authorName, (Object)cherryPickDetails.authorName) || !Intrinsics.areEqual((Object)this.commitMessage, (Object)cherryPickDetails.commitMessage)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

