/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.GitProtectedBranchesKt;
import git4idea.rebase.GitCommitEditingAction;
import git4idea.rebase.GitRewordActionKt;
import git4idea.rebase.GitRewordOperation;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lgit4idea/rebase/GitRewordAction;", "Lgit4idea/rebase/GitCommitEditingAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCommitDataFromCache", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getFailureTitle", "", "getOrLoadDetails", "project", "Lcom/intellij/openapi/project/Project;", "loadCommitData", "rewordInBackground", "repository", "Lgit4idea/repo/GitRepository;", "newMessage", "update", "RewordDialog", "intellij.vcs.git"})
public final class GitRewordAction
extends GitCommitEditingAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        this.prohibitRebaseDuringRebase(e, "reword", true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.actionPerformed(e);
        VcsShortCommitDetails commit2 = this.getSelectedCommit(e);
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = project;
        GitRepository repository = this.getRepository(e);
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        VcsCommitMetadata details = this.getOrLoadDetails(project3, this.getLogData(e), commit2);
        new RewordDialog(project2, this.getLogData(e), details, repository).show();
    }

    private final VcsCommitMetadata getOrLoadDetails(Project project, VcsLogData data, VcsShortCommitDetails commit2) {
        VcsCommitMetadata vcsCommitMetadata;
        VcsCommitMetadata vcsCommitMetadata2;
        VcsShortCommitDetails vcsShortCommitDetails = commit2;
        if (!(vcsShortCommitDetails instanceof VcsCommitMetadata)) {
            vcsShortCommitDetails = null;
        }
        if ((vcsCommitMetadata2 = (VcsCommitMetadata)vcsShortCommitDetails) == null) {
            vcsCommitMetadata2 = vcsCommitMetadata = this.getCommitDataFromCache(data, commit2);
        }
        if (vcsCommitMetadata2 == null) {
            vcsCommitMetadata = this.loadCommitData(project, data, commit2);
        }
        if (vcsCommitMetadata == null) {
            throw (Throwable)new ProcessCanceledException();
        }
        return vcsCommitMetadata;
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return "Couldn't Reword Commit";
    }

    private final VcsCommitMetadata getCommitDataFromCache(VcsLogData data, VcsShortCommitDetails commit2) {
        String message;
        int commitIndex = data.getCommitIndex((Hash)commit2.getId(), commit2.getRoot());
        VcsFullCommitDetails commitData = (VcsFullCommitDetails)data.getCommitDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (commitData != null) {
            return (VcsCommitMetadata)commitData;
        }
        VcsLogIndex vcsLogIndex = data.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogIndex, (String)"data.index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        String string = message = indexDataGetter != null ? indexDataGetter.getFullMessage(commitIndex) : null;
        if (message != null) {
            return (VcsCommitMetadata)new VcsCommitMetadataImpl((Hash)commit2.getId(), commit2.getParents(), commit2.getCommitTime(), commit2.getRoot(), commit2.getSubject(), commit2.getAuthor(), message, commit2.getCommitter(), commit2.getAuthorTime());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VcsCommitMetadata loadCommitData(Project project, VcsLogData data, VcsShortCommitDetails commit2) {
        void commitData;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Ref.ObjectRef)commitData, data, commit2, project){
            final /* synthetic */ Ref.ObjectRef $commitData;
            final /* synthetic */ VcsLogData $data;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ Project $project;

            public final void run() {
                try {
                    this.$commitData.element = (VcsCommitMetadata)VcsLogUtil.getDetails((VcsLogData)this.$data, (VirtualFile)this.$commit.getRoot(), (Hash)((Hash)this.$commit.getId()));
                }
                catch (VcsException e) {
                    String error = "Couldn't load changes of " + ((Hash)this.$commit.getId()).asString();
                    GitRewordActionKt.access$getLOG$p().warn(error, (Throwable)e);
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", error, NotificationType.ERROR, null);
                    VcsNotifier.getInstance((Project)this.$project).notify(notification);
                }
            }
            {
                this.$commitData = objectRef;
                this.$data = vcsLogData;
                this.$commit = vcsShortCommitDetails;
                this.$project = project;
            }
        }, "Loading Commit Message", true, project);
        return (VcsCommitMetadata)commitData.element;
    }

    private final void rewordInBackground(Project project, VcsCommitMetadata commit2, GitRepository repository, String newMessage) {
        new Task.Backgroundable(repository, commit2, newMessage, project, project, "Rewording"){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsCommitMetadata $commit;
            final /* synthetic */ String $newMessage;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                new GitRewordOperation(this.$repository, this.$commit, this.$newMessage).execute();
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$newMessage = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\b\u0010\"\u001a\u00020\u0014H\u0014J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lgit4idea/rebase/GitRewordAction$RewordDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/rebase/GitRewordAction;Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsCommitMetadata;Lgit4idea/repo/GitRepository;)V", "getCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitEditor", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "getCommitEditor", "()Lcom/intellij/openapi/vcs/ui/CommitMessage;", "getData", "()Lcom/intellij/vcs/log/data/VcsLogData;", "originalHEAD", "", "getOriginalHEAD", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "createCenterPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "createCommitEditor", "doOKAction", "", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getDimensionServiceKey", "getPreferredFocusedComponent", "Lcom/intellij/ui/EditorTextField;", "intellij.vcs.git"})
    private final class RewordDialog
    extends DialogWrapper {
        @Nullable
        private final String originalHEAD;
        @NotNull
        private final CommitMessage commitEditor;
        @NotNull
        private final Project project;
        @NotNull
        private final VcsLogData data;
        @NotNull
        private final VcsCommitMetadata commit;
        @NotNull
        private final GitRepository repository;

        @Nullable
        public final String getOriginalHEAD() {
            return this.originalHEAD;
        }

        @NotNull
        public final CommitMessage getCommitEditor() {
            return this.commitEditor;
        }

        @NotNull
        protected BorderLayoutPanel createCenterPanel() {
            return JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)new JBLabel("Edit message for commit " + ((Hash)this.commit.getId()).toShortString() + " by " + VcsUserUtil.getShortPresentation((VcsUser)this.commit.getAuthor()))).addToCenter((Component)this.commitEditor);
        }

        @NotNull
        public EditorTextField getPreferredFocusedComponent() {
            return this.commitEditor.getEditorField();
        }

        @NotNull
        protected String getDimensionServiceKey() {
            return "GitRewordDialog";
        }

        private final CommitMessage createCommitEditor() {
            CommitMessage editor = new CommitMessage(this.project, false, false, true);
            editor.setText(this.commit.getFullMessage());
            editor.getEditorField().setCaretPosition(0);
            editor.getEditorField().addSettingsProvider(new EditorSettingsProvider(this){
                final /* synthetic */ RewordDialog this$0;

                public final void customizeSettings(EditorEx editor) {
                    int MIN_ROWS = 3;
                    EditorEx editorEx = editor;
                    if (editorEx == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                    }
                    if (((EditorImpl)editorEx).getVisibleLineCount() < MIN_ROWS) {
                        RewordDialog.access$setVerticalStretch(this.this$0, 1.5f);
                    }
                }
                {
                    this.this$0 = rewordDialog;
                }
            });
            return editor;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (Intrinsics.areEqual((Object)this.repository.getInfo().getCurrentRevision(), (Object)this.originalHEAD) ^ true || Disposer.isDisposed((Disposable)((Disposable)this.data))) {
                return new ValidationInfo("Can't reword commit: repository state was changed");
            }
            VirtualFile virtualFile = this.commit.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"commit.root");
            Hash hash = (Hash)this.commit.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"commit.id");
            List<String> branches2 = GitRewordAction.this.findContainingBranches(this.data, virtualFile, hash);
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(this.repository, (Collection<String>)branches2);
            if (protectedBranch != null) {
                return new ValidationInfo("Can't reword commit: " + GitRewordAction.this.commitPushedToProtectedBranchError(protectedBranch));
            }
            return null;
        }

        protected void doOKAction() {
            super.doOKAction();
            String string = this.commitEditor.getComment();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commitEditor.comment");
            GitRewordAction.this.rewordInBackground(this.project, this.commit, this.repository, string);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsLogData getData() {
            return this.data;
        }

        @NotNull
        public final VcsCommitMetadata getCommit() {
            return this.commit;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        public RewordDialog(@NotNull Project project, @NotNull VcsLogData data, @NotNull VcsCommitMetadata commit2, GitRepository repository) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)commit2, (String)"commit");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            super(project, true);
            this.project = project;
            this.data = data;
            this.commit = commit2;
            this.repository = repository;
            this.originalHEAD = this.repository.getInfo().getCurrentRevision();
            this.commitEditor = this.createCommitEditor();
            this.init();
            this.setModal(false);
            this.setTitle("Reword Commit");
        }

        public static final /* synthetic */ void access$setVerticalStretch(RewordDialog $this, float p0) {
            $this.setVerticalStretch(p0);
        }
    }
}

