/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.GitReferenceValidator;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitTagDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitTagDialog.class);
    private JPanel myPanel;
    private JComboBox myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JTextField myTagNameTextField;
    private JCheckBox myForceCheckBox;
    private JTextArea myMessageTextArea;
    private JTextField myCommitTextField;
    private JButton myValidateButton;
    private final GitReferenceValidator myCommitTextFieldValidator;
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    private final Set<String> myExistingTags;
    @NonNls
    private static final String MESSAGE_FILE_PREFIX = "git-tag-message-";
    @NonNls
    private static final String MESSAGE_FILE_SUFFIX = ".txt";
    @NonNls
    private static final String MESSAGE_FILE_ENCODING = "UTF-8";

    public GitTagDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myExistingTags = new HashSet<String>();
        this.setTitle(GitBundle.getString("tag.title"));
        this.setOKButtonText(GitBundle.getString("tag.button"));
        this.myProject = project;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myGit = Git.getInstance();
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitTagDialog.this.fetchTags();
                GitTagDialog.this.validateFields();
            }
        });
        this.fetchTags();
        this.myTagNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitTagDialog.this.validateFields();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/GitTagDialog$2", "textChanged"));
            }
        });
        this.myCommitTextFieldValidator = new GitReferenceValidator(project, this.myGitRootComboBox, this.myCommitTextField, this.myValidateButton, () -> this.validateFields());
        this.myForceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GitTagDialog.this.myForceCheckBox.isEnabled()) {
                    GitTagDialog.this.validateFields();
                }
            }
        });
        this.init();
        this.validateFields();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTagNameTextField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction() {
        File messageFile;
        boolean hasMessage;
        block18: {
            String message = this.myMessageTextArea.getText();
            boolean bl = hasMessage = message.trim().length() != 0;
            if (hasMessage) {
                try {
                    messageFile = FileUtil.createTempFile((String)MESSAGE_FILE_PREFIX, (String)MESSAGE_FILE_SUFFIX);
                    messageFile.deleteOnExit();
                    try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(messageFile), MESSAGE_FILE_ENCODING);){
                        out.write(message);
                        break block18;
                    }
                }
                catch (IOException ex) {
                    Messages.showErrorDialog((Project)this.myProject, (String)GitBundle.message("tag.error.creating.message.file.message", ex.toString()), (String)GitBundle.getString("tag.error.creating.message.file.title"));
                    return;
                }
            }
            messageFile = null;
        }
        try {
            GitCommandResult result2;
            GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.TAG);
            if (hasMessage) {
                h.addParameters("-a");
            }
            if (this.myForceCheckBox.isEnabled() && this.myForceCheckBox.isSelected()) {
                h.addParameters("-f");
            }
            if (hasMessage) {
                h.addParameters("-F", messageFile.getAbsolutePath());
            }
            h.addParameters(this.myTagNameTextField.getText());
            String object = this.myCommitTextField.getText().trim();
            if (object.length() != 0) {
                h.addParameters(object);
            }
            if ((result2 = this.myGit.runCommand(h)).success()) {
                this.myNotifier.notifySuccess(this.myTagNameTextField.getText(), "Created tag " + this.myTagNameTextField.getText() + " successfully.");
            } else {
                this.myNotifier.notifyError("Couldn't Create Tag", result2.getErrorOutputAsHtmlString());
            }
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.getGitRoot());
            if (repository != null) {
                repository.getRepositoryFiles().refresh();
            } else {
                LOG.error("No repository registered for root: " + this.getGitRoot());
            }
        }
        finally {
            if (messageFile != null) {
                messageFile.delete();
            }
        }
    }

    private void validateFields() {
        String text = this.myTagNameTextField.getText();
        if (this.myExistingTags.contains(text)) {
            this.myForceCheckBox.setEnabled(true);
            if (!this.myForceCheckBox.isSelected()) {
                this.setErrorText(GitBundle.getString("tag.error.tag.exists"));
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            this.myForceCheckBox.setEnabled(false);
            this.myForceCheckBox.setSelected(false);
        }
        if (this.myCommitTextFieldValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("tag.error.invalid.commit"));
            this.setOKActionEnabled(false);
            return;
        }
        if (text.length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void fetchTags() {
        this.myExistingTags.clear();
        try {
            this.myExistingTags.addAll((Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitBranchUtil.getAllTags(this.myProject, this.getGitRoot()), GitBundle.getString("tag.getting.existing.tags"), false, this.myProject));
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, GitBundle.getString("tag.getting.existing.tags"), e.getMessage());
            throw new ProcessCanceledException();
        }
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.TagFiles";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextArea jTextArea;
        JTextField jTextField2;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setText("");
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.name.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTagNameTextField = jTextField2 = new JTextField();
        jTextField2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.name.tooltip"));
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.message.label"));
        jLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myMessageTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(4);
        jTextArea.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.message.tooltip"));
        jBScrollPane.setViewportView(jTextArea);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.commit.label"));
        jPanel.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForceCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.force"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.force.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCommitTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.commit.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValidateButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.validate"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("tag.validate.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextArea);
        jLabel6.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

