/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="NodeJSRemoteInterpreters", storages={@Storage(value="nodeJsRemoteInterpreters.xml")})
public class RemoteInterpreters
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String INTERPRETER_PATH = "node-remote-interpreter";
    private final List<NodeJSRemoteSdkAdditionalData> myInterpreters;
    private final Object myLock = new Object();

    public RemoteInterpreters() {
        this.myInterpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        List children;
        if (state == null) {
            RemoteInterpreters.$$$reportNull$$$0(0);
        }
        if ((children = state.getChildren()) != null) {
            ArrayList<NodeJSRemoteSdkAdditionalData> list = new ArrayList<NodeJSRemoteSdkAdditionalData>();
            for (Element child : children) {
                String path = child.getAttributeValue(INTERPRETER_PATH);
                if (path == null) continue;
                list.add(NodeJSRemoteSdkAdditionalData.load((Element)child, (String)path));
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myInterpreters.clear();
                this.myInterpreters.addAll(list);
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Element getState() {
        ArrayList<NodeJSRemoteSdkAdditionalData> interpreters;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInterpreters.isEmpty()) {
                Element element = new Element("node-remote-interpreters");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
                if (element == null) {
                    RemoteInterpreters.$$$reportNull$$$0(1);
                }
                return element;
            }
            interpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters);
        }
        Element rootElement = new Element("node-remote-interpreters");
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            Element element = new Element("interpreter");
            rootElement.addContent(element);
            element.setAttribute(INTERPRETER_PATH, interpreter.getSdkId());
            interpreter.save(element);
        }
        Element element = rootElement;
        if (element == null) {
            RemoteInterpreters.$$$reportNull$$$0(2);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myInterpreters.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeJSRemoteSdkAdditionalData> getInterpreters() {
        Object object = this.myLock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            RemoteInterpreters.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(@NotNull String id) {
        if (id == null) {
            RemoteInterpreters.$$$reportNull$$$0(4);
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)id);
        Object object = this.myLock;
        synchronized (object) {
            Iterator<NodeJSRemoteSdkAdditionalData> iterator = this.myInterpreters.iterator();
            while (iterator.hasNext()) {
                NodeJSRemoteSdkAdditionalData data = iterator.next();
                if (!Comparing.equal((String)FileUtil.toSystemIndependentName((String)data.getSdkId()), (String)systemIndependentId)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/RemoteInterpreters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/RemoteInterpreters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

