/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class DockerFileTransfer
implements NodeFileTransfer {
    private final DockerCredentialsHolder myCredentials;
    private final NodeJsRunConfiguration myConfiguration;
    private final PathMappingSettings myMappings;
    private final NodeLocalFileTransfer myLocalFileTransfer;
    private RemoteDockerApplicationRuntime myContainer;

    public DockerFileTransfer(DockerCredentialsHolder credentials, NodeJsRunConfiguration configuration, PathMappingSettings mappings) {
        this.myCredentials = credentials;
        this.myConfiguration = configuration;
        this.myMappings = mappings;
        DockerContainerSettings data = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
        if (data != null && !data.getVolumeBindings().isEmpty()) {
            for (DockerVolumeBindingImpl binding : data.getVolumeBindings()) {
                this.myMappings.add(new PathMappingSettings.PathMapping(binding.getHostPath(), binding.getContainerPath()));
            }
        }
        this.myLocalFileTransfer = new NodeLocalFileTransfer();
    }

    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        if (remoteWorkingDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(0);
        }
        return this.myLocalFileTransfer.listDirectoryContents(this.myMappings.convertToLocal(remoteWorkingDir));
    }

    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(1);
        }
        if (names == null) {
            DockerFileTransfer.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(3);
        }
        this.myLocalFileTransfer.copy(this.myMappings.convertToLocal(sourceDir), names, this.myMappings.convertToLocal(targetDir));
    }

    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(4);
        }
        if (names == null) {
            DockerFileTransfer.$$$reportNull$$$0(5);
        }
        if (targetDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(6);
        }
        this.myLocalFileTransfer.fetch(this.myMappings.convertToLocal(sourceDir), names, this.myMappings.convertToLocal(targetDir));
    }

    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            DockerFileTransfer.$$$reportNull$$$0(7);
        }
        if (targetPath == null) {
            DockerFileTransfer.$$$reportNull$$$0(8);
        }
        try {
            String convertedToLocal = this.myMappings.convertToLocal(sourcePath);
            if (sourcePath.equals(convertedToLocal)) {
                if (this.myContainer == null) {
                    return;
                }
                File targetFile = new File(targetPath);
                int idx = (sourcePath = sourcePath.replace("\\", "/")).lastIndexOf("/");
                String dirPath = idx < 0 ? sourcePath : sourcePath.substring(0, idx);
                String sourceName = idx < 0 ? targetFile.getName() : sourcePath.substring(idx + 1);
                this.myContainer.downloadDirectory(dirPath, targetFile.getParentFile(), null, null);
                if (!sourceName.equals(targetFile.getName())) {
                    FileUtil.rename((File)new File(targetFile.getParentFile(), sourceName), (String)targetFile.getName());
                }
            } else {
                this.myLocalFileTransfer.fetch(convertedToLocal, this.myMappings.convertToLocal(targetPath));
            }
        }
        catch (ServerRuntimeException e) {
            throw new IOException(e);
        }
    }

    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(9);
        }
        return this.myMappings.convertToRemote(this.myLocalFileTransfer.copyToRemoteTmpFile(this.myMappings.convertToLocal(remoteDir), localFileName, content));
    }

    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(10);
        }
        return "/tmp/a" + UUID.randomUUID() + "/" + localFileName;
    }

    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            DockerFileTransfer.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            DockerFileTransfer.$$$reportNull$$$0(12);
        }
        this.myLocalFileTransfer.grouped(title, consumer);
    }

    public void deleteRemote(@NotNull String path) throws IOException {
        if (path == null) {
            DockerFileTransfer.$$$reportNull$$$0(13);
        }
        this.myLocalFileTransfer.deleteRemote(this.myMappings.convertToLocal(path));
    }

    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            DockerFileTransfer.$$$reportNull$$$0(14);
        }
        if (set == null) {
            DockerFileTransfer.$$$reportNull$$$0(15);
        }
        this.myLocalFileTransfer.delete(this.myMappings.convertToLocal(dir), set);
    }

    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            DockerFileTransfer.$$$reportNull$$$0(16);
        }
        return this.myLocalFileTransfer.mkDir(this.myMappings.convertToLocal(remoteDir), name);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasInternalMapping() {
        return true;
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            DockerFileTransfer.$$$reportNull$$$0(17);
        }
        return this.myMappings.convertToRemote(localPath);
    }

    public void setContainer(RemoteDockerApplicationRuntime container) {
        this.myContainer = container;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteWorkingDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/remote/docker/DockerFileTransfer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "listDirectoryContents";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fetch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToRemoteTmpFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathForTempFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "grouped";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemote";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "mkDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getMappingFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

