/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.run.runtime.DockerAgentBuildImageConfig;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SystemProperties;
import com.jetbrains.nodejs.remote.docker.DockerFileTransfer;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerRunner;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerUtil;
import com.jetbrains.nodejs.remote.docker.NodeJSRunDockerContainerSettingsEditor;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSDockerRunConfigurationExtension
extends NodeJSRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.docker.NodeJSDockerRunConfigurationExtension");

    @Nullable
    protected NodeJSRuntimeSession createLocalRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) {
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    protected NodeJSRuntimeSession createRemoteRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (fileTransfer == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(runConfiguration)) {
            return null;
        }
        ParametersWorker parametersWorker = new ParametersWorker(runConfiguration);
        DockerCredentialsHolder credentials = parametersWorker.getDockerCredentialsHolder();
        if (credentials == null) {
            return null;
        }
        boolean isDebug = DefaultDebugExecutor.EXECUTOR_ID.equals(environment.getExecutor().getId());
        return new MyRuntimeSessionHelper(runConfiguration.getProject(), parametersWorker, runConfiguration, isDebug, fileTransfer);
    }

    protected void readExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (element == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        DockerContainerSettings value = (DockerContainerSettings)XmlSerializer.deserialize((Element)element, DockerContainerSettings.class);
        runConfiguration.putCopyableUserData(DockerContainerSettings.KEY, (Object)value);
        Attribute generateImage = element.getAttribute(NodeJSDockerUtil.GENERATE_IMAGE.toString());
        try {
            if (generateImage != null && Boolean.TRUE.equals(generateImage.getBooleanValue())) {
                runConfiguration.putCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE, (Object)true);
            }
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
    }

    protected void writeExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) {
        DockerContainerSettings data;
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (element == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        if ((data = (DockerContainerSettings)runConfiguration.getCopyableUserData(DockerContainerSettings.KEY)) != null) {
            XmlSerializer.serializeObjectInto((Object)data, (Element)element);
            Iterator iterator = element.getChildren("option").iterator();
            while (iterator.hasNext()) {
                Element option = (Element)iterator.next();
                if (!"version".equals(option.getAttributeValue("name")) || !"1".equals(option.getAttributeValue("value"))) continue;
                iterator.remove();
                break;
            }
        }
        if (NodeJSDockerRunConfigurationExtension.isGenerateImage(runConfiguration)) {
            element.setAttribute(NodeJSDockerUtil.GENERATE_IMAGE.toString(), String.valueOf(Boolean.TRUE));
        }
    }

    @Nullable
    public NodeFileTransfer overrideFileTransfer(@NotNull NodeJsRunConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(configuration)) {
            return null;
        }
        ParametersWorker parametersWorker = new ParametersWorker(configuration);
        DockerCredentialsHolder credentials = parametersWorker.getDockerCredentialsHolder();
        if (credentials == null) {
            return null;
        }
        parametersWorker.getMappings().add(new PathMappingSettings.PathMapping(configuration.getProject().getBasePath(), "/opt/project"));
        return new DockerFileTransfer(credentials, configuration, parametersWorker.getMappings());
    }

    public boolean isApplicableFor(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        return true;
    }

    private static boolean isMatchingConfiguration(@NotNull NodeJsRunConfiguration configuration) {
        NodeJsRemoteInterpreter remoteInterpreter;
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        if ((remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)configuration.getInterpreter())) == null) {
            return false;
        }
        try {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(configuration.getProject(), remoteInterpreter.getRemoteUrl());
            return DockerCredentialsType.getInstance().equals(data.getRemoteConnectionType());
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public boolean isEnabledFor(@NotNull NodeJsRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(12);
        }
        return true;
    }

    protected boolean showEditorInMainPage(@NotNull NodeJsRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        return true;
    }

    @Nullable
    protected <P extends NodeJsRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration, Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        return new NodeJSRunDockerContainerSettingsEditor<P>(configuration, listenerRegistrar);
    }

    public void checkConfiguration(@NotNull NodeJsRunConfiguration configuration, String nodePath) throws RuntimeConfigurationException {
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        this.checkConfiguration(configuration);
    }

    public void checkConfiguration(@NotNull NodeJsRunConfiguration configuration) throws RuntimeConfigurationException {
        if (configuration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(configuration)) {
            return;
        }
        if (new ParametersWorker(configuration).getDockerCredentialsHolder() == null) {
            return;
        }
        DockerContainerSettings data = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
        if (!NodeJSDockerRunConfigurationExtension.isGenerateImage(configuration) && (data == null || data.getVolumeBindings().isEmpty())) {
            throw new RuntimeConfigurationException("Remote working directory and target file can not be determined.<br/>Currently you need to either define one or more volume bindings in Docker container settings, or choose 'Auto configure' option.");
        }
    }

    private static boolean isGenerateImage(@NotNull NodeJsRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(17);
        }
        return Boolean.TRUE.equals(runConfiguration.getCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE));
    }

    static VirtualFile[] sortByName(VirtualFile[] children) {
        Arrays.sort(children, Comparator.comparing(VirtualFile::getName));
        return children;
    }

    static String findName(@NotNull VirtualFile base, @NotNull String baseName, @NotNull String extensionWithDot) {
        if (base == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(18);
        }
        if (baseName == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(19);
        }
        if (extensionWithDot == null) {
            NodeJSDockerRunConfigurationExtension.$$$reportNull$$$0(20);
        }
        for (int i = 0; i < 1000; ++i) {
            String newName = baseName + (i == 0 ? "" : String.valueOf(i)) + extensionWithDot;
            if (base.findChild(newName) != null) continue;
            return newName;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTransfer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionWithDot";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLocalRuntimeSession";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemoteRuntimeSession";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "overrideFileTransfer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatchingConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorInMainPage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConfiguration";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isGenerateImage";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "findName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HelperFileCreator {
        @NotNull
        private final String myTemplateName;
        @NotNull
        private final String myTemplateContents;
        private VirtualFile myBase;

        private HelperFileCreator(@NotNull String templateName, @NotNull String templateContents) {
            if (templateName == null) {
                HelperFileCreator.$$$reportNull$$$0(0);
            }
            if (templateContents == null) {
                HelperFileCreator.$$$reportNull$$$0(1);
            }
            this.myTemplateName = templateName;
            this.myTemplateContents = templateContents;
        }

        public HelperFileCreator withSubdir(@NotNull VirtualFile dir) {
            if (dir == null) {
                HelperFileCreator.$$$reportNull$$$0(2);
            }
            this.myBase = dir;
            return this;
        }

        public File execute(@NotNull Project project) throws ExecutionException {
            if (project == null) {
                HelperFileCreator.$$$reportNull$$$0(3);
            }
            this.myBase = this.myBase == null ? project.getBaseDir() : this.myBase;
            int idx = this.myTemplateName.lastIndexOf(46);
            String name = idx > 0 ? this.myTemplateName.substring(0, idx) : this.myTemplateName;
            String extension = idx > 0 ? this.myTemplateName.substring(idx + 1) : "";
            try {
                VirtualFile[] children;
                for (VirtualFile child : children = NodeJSDockerRunConfigurationExtension.sortByName(this.myBase.getChildren())) {
                    if (!child.getName().startsWith(name) || !this.myTemplateContents.equals(FileUtil.loadFile((File)new File(child.getPath())))) continue;
                    return new File(child.getPath());
                }
                return this.createUtilFile(name, extension, new ByteArrayInputStream(this.myTemplateContents.getBytes(CharsetToolkit.UTF8_CHARSET)));
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private File createUtilFile(@NotNull String baseName, @NotNull String extension, @NotNull InputStream is) throws ExecutionException {
            File file;
            if (baseName == null) {
                HelperFileCreator.$$$reportNull$$$0(4);
            }
            if (extension == null) {
                HelperFileCreator.$$$reportNull$$$0(5);
            }
            if (is == null) {
                HelperFileCreator.$$$reportNull$$$0(6);
            }
            try {
                String newName = NodeJSDockerRunConfigurationExtension.findName(this.myBase, baseName, extension.isEmpty() ? "" : "." + extension);
                if (newName == null) {
                    File file2 = null;
                    return file2;
                }
                File toFile = new File(this.myBase.getPath(), newName);
                try (FileOutputStream fos = new FileOutputStream(toFile);){
                    FileUtil.copy((InputStream)is, (OutputStream)fos);
                }
                file = toFile;
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateContents";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "is";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withSubdir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createUtilFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRuntimeSessionHelper
    implements NodeJSRuntimeSession {
        public static final String DOCKERFILE = "JetBrains.Dockerfile";
        public static final String SHELL = "start.sh";
        private static final String JB_DIR = "JetBrainsHelpers";
        private static final String NODE_MODULES_MAP_FOLDER = "NodeJS.Docker.Node.modules.map.folder";
        private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
        @NotNull
        private final Project myProject;
        @NotNull
        private final ParametersWorker myParametersWorker;
        @NotNull
        private final NodeJsRunConfiguration myRunConfiguration;
        private final NodeJSDockerRunner.DockerInputParameters myDockerInputParameters;
        @Nullable
        private File myLocalDockerFile;
        @Nullable
        private File myLocalShellFile;
        private final boolean myGenerateImage;
        private VirtualFile myPackageJson;
        private DockerFileTransfer myFileTransfer;

        MyRuntimeSessionHelper(@NotNull Project project, @NotNull ParametersWorker parametersWorker, @NotNull NodeJsRunConfiguration runConfiguration, boolean isDebug, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
            if (project == null) {
                MyRuntimeSessionHelper.$$$reportNull$$$0(0);
            }
            if (parametersWorker == null) {
                MyRuntimeSessionHelper.$$$reportNull$$$0(1);
            }
            if (runConfiguration == null) {
                MyRuntimeSessionHelper.$$$reportNull$$$0(2);
            }
            if (fileTransfer == null) {
                MyRuntimeSessionHelper.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myParametersWorker = parametersWorker;
            this.myRunConfiguration = runConfiguration;
            this.myGenerateImage = NodeJSDockerRunConfigurationExtension.isGenerateImage(runConfiguration);
            this.myDockerInputParameters = new NodeJSDockerRunner.DockerInputParameters(this.myProject, this.myRunConfiguration, parametersWorker.getDockerCredentialsHolder());
            this.createHelperFilesUnderProjectRoot();
            if (fileTransfer instanceof DockerFileTransfer) {
                this.myFileTransfer = (DockerFileTransfer)fileTransfer;
            }
        }

        @Nullable
        public String getDebugHost() {
            return this.myDockerInputParameters.myDockerHost;
        }

        public ProcessHandler createProcessHandler(GeneralCommandLine commandLine, int debugPort, List<Integer> openPorts) throws ExecutionException {
            NodeJSDockerRunner runner = new NodeJSDockerRunner(this.myDockerInputParameters);
            if (this.myGenerateImage) {
                if (!((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        indicator.setIndeterminate(true);
                    }
                    DockerVolumeBindingImpl hardcodedBinding = NodeJSRunDockerContainerSettingsEditor.createHardcodedBinding(this.myProject);
                    runner.addVolumeMapping((DockerVolumeBinding)hardcodedBinding);
                    if (this.myLocalDockerFile != null && this.myLocalShellFile != null) {
                        String nodeModules = this.findNodeModules();
                        runner.withImage(this.buildNewImage(this.myDockerInputParameters.myDockerRuntime, true));
                        if (this.myLocalShellFile != null) {
                            FileUtil.delete((File)this.myLocalShellFile);
                        }
                        if (nodeModules != null) {
                            try {
                                runner.addTmpVolumeMapping(nodeModules, this.getTmpMappingPathForNodeModules(), this.myProject);
                            }
                            catch (IOException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        runner.withRemoteInterpreter("/tmp/project_modules/start.sh");
                    } else {
                        runner.withImage(this.myParametersWorker.getDockerCredentialsHolder().getImageName());
                    }
                    return true;
                }, "Building Project Image", true, this.myProject)).booleanValue()) {
                    throw new ProcessCanceledException();
                }
            } else {
                runner.withImage(this.myParametersWorker.getDockerCredentialsHolder().getImageName());
            }
            DockerExecProcess process = runner.execute(commandLine, openPorts);
            if (this.myFileTransfer != null) {
                this.myFileTransfer.setContainer(process.getApplicationRuntime());
            }
            return new KillableColoredProcessHandler((Process)process, commandLine.getCommandLineString());
        }

        @NotNull
        private String getTmpMappingPathForNodeModules() throws IOException {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String tmpPath = propertiesComponent.getValue(NODE_MODULES_MAP_FOLDER);
            if (tmpPath == null || !new File(tmpPath).isDirectory()) {
                File tmpDir = new File(PathManager.getTempPath());
                File homeDir = new File(SystemProperties.getUserHome());
                tmpPath = FileUtil.createTempDirectory((File)(FileUtil.isAncestor((File)homeDir, (File)tmpDir, (boolean)false) ? tmpDir : homeDir), (String)"node_modules", null, (boolean)true).getAbsolutePath();
                propertiesComponent.setValue(NODE_MODULES_MAP_FOLDER, tmpPath);
            }
            String string = tmpPath;
            if (string == null) {
                MyRuntimeSessionHelper.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        private String findNodeModules() {
            VirtualFile parent;
            VirtualFile nodeModules;
            if (this.myPackageJson != null && (nodeModules = (parent = this.myPackageJson.getParent()).findChild("node_modules")) != null) {
                return nodeModules.getPath();
            }
            return null;
        }

        private String buildNewImage(RemoteDockerRuntime dockerRuntime, boolean firstTime) throws ExecutionException {
            String tag = FileUtil.sanitizeFileName((String)StringUtil.toLowerCase((String)this.myProject.getName()));
            try {
                assert (this.myLocalDockerFile != null);
                DockerAgentBuildImageConfig config = new DockerAgentBuildImageConfig(tag, this.myLocalDockerFile, false);
                RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
                return applicationRuntime.getAgentApplication().getImageId();
            }
            catch (ServerRuntimeException e) {
                LOG.info((Throwable)e);
                if (firstTime && DockerUtil.isCanNotRetrieveImageIdCause((String)e.getMessage())) {
                    LOG.info(String.format("Doing the second attempt to build image '%s'", tag));
                    try {
                        Thread.sleep(TIMEOUT);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                    return this.buildNewImage(dockerRuntime, false);
                }
                throw new ExecutionException("Problem during building project image: " + e.getMessage(), (Throwable)e);
            }
        }

        private void createHelperFilesUnderProjectRoot() throws ExecutionException {
            try {
                if (this.myGenerateImage) {
                    this.myPackageJson = this.findPackageJson();
                    if (this.myPackageJson == null) {
                        return;
                    }
                    String shellContents = this.createShellScriptContents();
                    this.myLocalShellFile = new HelperFileCreator(SHELL, shellContents).execute(this.myProject);
                    FileUtil.setExecutableAttribute((String)this.myLocalShellFile.getAbsolutePath(), (boolean)true);
                    if (this.myLocalShellFile == null) {
                        throw new ExecutionException("Can not create start.sh");
                    }
                    String contents = this.createDockerfileContents();
                    this.myLocalDockerFile = new HelperFileCreator(DOCKERFILE, contents).execute(this.myProject);
                    if (this.myLocalDockerFile == null) {
                        throw new ExecutionException("Can not create JetBrains.Dockerfile");
                    }
                }
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private String createDockerfileContents() {
            assert (this.myLocalShellFile != null);
            return "# Created by " + ApplicationNamesInfo.getInstance().getFullProductName() + "\nFROM " + this.myParametersWorker.getDockerCredentialsHolder().getImageName() + "\nWORKDIR /tmp/project_modules\nCOPY package.json /tmp/project_modules/package.json\nRUN npm install .\nCOPY " + this.myLocalShellFile.getName() + " /tmp/project_modules/" + SHELL;
        }

        private String createShellScriptContents() {
            return "#!/bin/sh\n# Created by " + ApplicationNamesInfo.getInstance().getFullProductName() + "\ncp -r -L /tmp/project_modules/node_modules " + "/opt/project" + " || (echo 'Can not copy node_modules from image, installing locally' && npm --no-bin-links install .)\nexec " + this.myDockerInputParameters.mySdkAdditionalData.getInterpreterPath() + " \"$@\"";
        }

        private VirtualFile findPackageJson() throws ExecutionException {
            File ioWorkingDirectory = new File(this.myRunConfiguration.getWorkingDirectory());
            VirtualFile vfWorkingDirectory = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioWorkingDirectory);
            if (vfWorkingDirectory == null) {
                throw new ExecutionException("Can not find working directory: " + ioWorkingDirectory.getPath());
            }
            VirtualFile packageJson = vfWorkingDirectory.findChild("package.json");
            if (packageJson == null && !FileUtil.filesEqual((File)ioWorkingDirectory, (File)new File(this.myProject.getBasePath()))) {
                return this.myProject.getBaseDir().findChild("package.json");
            }
            return packageJson;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersWorker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTransfer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTmpMappingPathForNodeModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ParametersWorker {
        private final Project myProject;
        private RemoteSdkAdditionalData mySdkAdditionalData;
        private DockerCredentialsHolder myDockerCredentialsHolder;
        private PathMappingSettings myMappings;

        ParametersWorker(@NotNull NodeJsRunConfiguration configuration) {
            if (configuration == null) {
                ParametersWorker.$$$reportNull$$$0(0);
            }
            this.myProject = configuration.getProject();
            NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)configuration.getInterpreter());
            if (remoteInterpreter == null) {
                return;
            }
            try {
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
                assert (manager != null);
                this.mySdkAdditionalData = manager.getRemoteSdkAdditionalData(this.myProject, remoteInterpreter.getRemoteUrl());
                this.myDockerCredentialsHolder = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)this.mySdkAdditionalData);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        public PathMappingSettings getMappings() throws ExecutionException {
            if (this.myMappings != null) {
                return this.myMappings;
            }
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            this.myMappings = manager.setupMappings(this.myProject, this.mySdkAdditionalData);
            return this.myMappings;
        }

        public RemoteSdkAdditionalData getSdkAdditionalData() {
            return this.mySdkAdditionalData;
        }

        public DockerCredentialsHolder getDockerCredentialsHolder() {
            return this.myDockerCredentialsHolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$ParametersWorker", "<init>"));
        }
    }
}

