/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NodeJSDockerRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSDockerUtil");
    @NotNull
    private final ContainerData myContainerData;
    @NotNull
    private final DockerInputParameters myDockerInputParameters;
    private String myRemoteInterpreter;

    public NodeJSDockerRunner(@NotNull DockerInputParameters dockerInputParameters) {
        if (dockerInputParameters == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(0);
        }
        this.myDockerInputParameters = dockerInputParameters;
        this.myContainerData = new ContainerData();
        this.myRemoteInterpreter = null;
    }

    public NodeJSDockerRunner withImage(@NotNull String imageName) {
        if (imageName == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(1);
        }
        this.myContainerData.myImageName = imageName;
        return this;
    }

    public void addVolumeMapping(DockerVolumeBinding binding) {
        if (this.containsBinding(binding)) {
            return;
        }
        String hostPath = NodeJSDockerRunner.convertToDockerPath(binding.getHostPath());
        String containerPath = binding.getContainerPath();
        this.myContainerData.myVolumesBuilder.addBoundVolume(containerPath, hostPath, binding.isReadOnly());
        this.myDockerInputParameters.myPathMappingSettings.add(new PathMappingSettings.PathMapping(DockerUtil.toHostPath((String)hostPath), containerPath));
    }

    private boolean containsBinding(DockerVolumeBinding newBinding) {
        for (DockerVolumeBinding binding : this.myContainerData.myVolumesBuilder.build()) {
            if (!NodeJSDockerRunner.convertToDockerPath(StringUtil.notNullize((String)binding.getHostPath())).equals(NodeJSDockerRunner.convertToDockerPath(StringUtil.notNullize((String)newBinding.getHostPath()))) || !StringUtil.notNullize((String)binding.getContainerPath()).equals(StringUtil.notNullize((String)newBinding.getContainerPath()))) continue;
            return true;
        }
        return false;
    }

    public static String convertToDockerPath(@NotNull String path) {
        if (path == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(2);
        }
        return DockerUtil.toUnixPath((String)FileUtil.toSystemIndependentName((String)path));
    }

    public void addTmpVolumeMapping(@NotNull String localPath, @NotNull String localTmpPath, Project project) throws IOException {
        if (localPath == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(3);
        }
        if (localTmpPath == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(4);
        }
        String remote = this.myDockerInputParameters.myPathMappingSettings.convertToRemote(localPath);
        this.myContainerData.myVolumesBuilder.addBoundVolume(remote, DockerUtil.toUnixPath((String)FileUtil.toSystemIndependentName((String)localTmpPath)), false);
    }

    public NodeJSDockerRunner withRemoteInterpreter(@NotNull String path) {
        if (path == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(5);
        }
        this.myRemoteInterpreter = path;
        return this;
    }

    public DockerExecProcess execute(@NotNull GeneralCommandLine commandLine, List<Integer> ports) throws RemoteSdkException {
        if (commandLine == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(6);
        }
        this.myContainerData.myVolumesBuilder.addBoundVolumes((Iterable)this.myDockerInputParameters.myContainerSettings.getVolumeBindings());
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(this.myContainerData.myImageName, this.myContainerData.myVolumesBuilder.build());
        this.prepareCreateContainerCommandFromCommandLine(config, commandLine);
        ArrayList<DockerPortBinding> portBindings = new ArrayList<DockerPortBinding>();
        this.prepareCreateContainerCommandFromContainerSettings(config, portBindings);
        if (!(this.myDockerInputParameters.myContainerSettings.isPublishAllPorts() || ports.isEmpty() && portBindings.isEmpty())) {
            NodeJSDockerRunner.addPortsMappings(config, ports, portBindings);
        }
        try {
            RemoteDockerRuntime dockerRuntime = this.myDockerInputParameters.myDockerRuntime;
            return DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)this.myContainerData.myImageName);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
    }

    private static void addPortsMappings(@NotNull DockerAgentDeploymentConfigImpl config, @NotNull List<Integer> ports, List<DockerPortBinding> portBindings) {
        if (config == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(7);
        }
        if (ports == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(8);
        }
        portBindings.addAll(ports.stream().filter(portToAdd -> portBindings.stream().noneMatch(binding -> binding.getContainerPort() == portToAdd.intValue() || Objects.equals(binding.getHostPort(), portToAdd))).map(portToAdd -> {
            DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
            portBinding.setContainerPort(portToAdd.intValue());
            portBinding.setHostPort(portToAdd);
            return portBinding;
        }).collect(Collectors.toList()));
        PortsBuilder portsBuilder = PortsBuilder.builder();
        portsBuilder.addPortBindings(portBindings);
        config.withPortBindings(portsBuilder.buildPortBindings());
        config.withExposedPorts(portsBuilder.buildExposedPorts());
    }

    private void prepareCreateContainerCommandFromCommandLine(@NotNull DockerAgentDeploymentConfigImpl config, @NotNull GeneralCommandLine commandLine) {
        File directory;
        if (config == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(10);
        }
        if ((directory = commandLine.getWorkDirectory()) != null) {
            config.withWorkingDir(DockerUtil.toUnixPath((String)directory.getPath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.myRemoteInterpreter == null) {
            cmd.add(this.myDockerInputParameters.mySdkAdditionalData.getInterpreterPath());
        } else {
            cmd.add("/bin/sh");
            cmd.add(this.myRemoteInterpreter);
        }
        cmd.addAll(commandLine.getParametersList().getList());
        config.withCommand(ArrayUtil.toStringArray(cmd));
        this.myContainerData.myEnvironmentBuilder.addEnvs(commandLine.getEnvironment()).addEnv("JETBRAINS_REMOTE_RUN", "1");
    }

    private void prepareCreateContainerCommandFromContainerSettings(@NotNull DockerAgentDeploymentConfigImpl config, List<DockerPortBinding> ports) {
        if (config == null) {
            NodeJSDockerRunner.$$$reportNull$$$0(11);
        }
        this.myContainerData.myEnvironmentBuilder.addEnvs(this.myDockerInputParameters.myContainerSettings.getEnvVars());
        config.withEnvs(this.myContainerData.myEnvironmentBuilder.withPassParentEnvironment(true).buildEnvs());
        if (this.myDockerInputParameters.myContainerSettings.isPublishAllPorts()) {
            config.withPublishAllPorts(true);
        } else {
            ports.addAll(this.myDockerInputParameters.myContainerSettings.getPortBindings());
        }
        if (this.myDockerInputParameters.myContainerSettings.isNetworkDisabled()) {
            config.withNetworkDisabled(true);
        } else if (StringUtil.isNotEmpty((String)this.myDockerInputParameters.myContainerSettings.getNetworkMode())) {
            config.withNetworkMode(this.myDockerInputParameters.myContainerSettings.getNetworkMode());
        }
        config.withLinks(this.myDockerInputParameters.myContainerSettings.getLinks());
        config.withExtraHosts(ExtraHostsBuilder.builder().addExtraHosts(this.myDockerInputParameters.myContainerSettings.getExtraHosts()).build());
        List bindings = this.myDockerInputParameters.myContainerSettings.getVolumeBindings();
        for (DockerVolumeBindingImpl binding : bindings) {
            this.addVolumeMapping((DockerVolumeBinding)binding);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerInputParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTmpPath";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withImage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToDockerPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTmpVolumeMapping";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "withRemoteInterpreter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addPortsMappings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCreateContainerCommandFromCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCreateContainerCommandFromContainerSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContainerData {
        private String myImageName;
        private final VolumesBuilder myVolumesBuilder = VolumesBuilder.builder();
        private final EnvsBuilder myEnvironmentBuilder = EnvsBuilder.builder();

        ContainerData() {
        }
    }

    static class DockerInputParameters {
        @NotNull
        final RemoteSdkAdditionalData mySdkAdditionalData;
        @NotNull
        final DockerContainerSettings myContainerSettings;
        @NotNull
        final RemoteDockerRuntime myDockerRuntime;
        @NotNull
        final String myDockerHost;
        @NotNull
        final PathMappingSettings myPathMappingSettings;
        @NotNull
        final Project myProject;
        @NotNull
        final VolumesBuilder myVolumesBuilder;

        DockerInputParameters(@NotNull Project project, @NotNull NodeJsRunConfiguration configuration, @NotNull DockerCredentialsHolder credentials) throws ExecutionException {
            if (project == null) {
                DockerInputParameters.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                DockerInputParameters.$$$reportNull$$$0(1);
            }
            if (credentials == null) {
                DockerInputParameters.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            String rawExePath = configuration.getRawExePath();
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            this.mySdkAdditionalData = manager.getRemoteSdkAdditionalData(project, rawExePath);
            DockerContainerSettings containerSettings = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
            if (containerSettings == null) {
                containerSettings = new DockerContainerSettings();
                containerSettings.setVersion(1);
            }
            this.myContainerSettings = containerSettings;
            DockerCloudConfiguration account = NodeJSDockerUtil.getAccount(credentials);
            this.myDockerHost = DockerUtil.getDockerHost((DockerCloudConfiguration)account);
            if (StringUtil.isEmptyOrSpaces((String)this.myDockerHost)) {
                throw new ExecutionException("Docker API URL is not specified.");
            }
            try {
                this.myDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)account, (Project)this.myProject);
            }
            catch (ServerRuntimeException e) {
                throw new ExecutionException((Throwable)e);
            }
            this.myPathMappingSettings = manager.setupMappings(project, this.mySdkAdditionalData);
            this.myVolumesBuilder = VolumesBuilder.builder();
            List bindings = this.myContainerSettings.getVolumeBindings();
            for (DockerVolumeBindingImpl binding : bindings) {
                this.myVolumesBuilder.addBoundVolume(binding.getContainerPath(), binding.getHostPath(), binding.isReadOnly());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "credentials";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner$DockerInputParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

