/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.utils;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ArgumentHelper {
    private static final String EMPTY_ARG_MSG = "%s is empty";
    private static final String NOT_FILE_MSG = "%s expected to be a file";
    private static final String NOT_WRITEABLE_FILE_MSG = "%s must be writable";

    public static void checkNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(argName);
        }
    }

    public static void checkNotNullOrEmpty(List arg, String argName) {
        ArgumentHelper.checkNotNull(arg, argName);
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(String.format(EMPTY_ARG_MSG, argName));
        }
    }

    public static void checkNotEmptyString(String arg, String argName) {
        if (StringUtils.isEmpty((String)arg)) {
            throw new IllegalArgumentException(String.format(EMPTY_ARG_MSG, argName));
        }
    }

    public static void checkIfFile(File file) {
        ArgumentHelper.checkNotNull(file, "file");
        if (file.isDirectory()) {
            throw new IllegalArgumentException(String.format(NOT_FILE_MSG, file.getPath()));
        }
    }

    public static void checkIfFileWriteable(File file) {
        if (!file.canWrite()) {
            throw new IllegalArgumentException(String.format(NOT_WRITEABLE_FILE_MSG, file.getPath()));
        }
    }
}

