/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.tabs.TabInfo;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalSessionToEditorAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "activeToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "selectedContent", "Lcom/intellij/ui/content/Content;", "intellij.terminal"})
public final class MoveTerminalSessionToEditorAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow activeToolWindow, @Nullable Content selectedContent) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)activeToolWindow, (String)"activeToolWindow");
        Content content = selectedContent;
        if (content == null) {
            Intrinsics.throwNpe();
        }
        TabInfo tabInfo = new TabInfo(content.getComponent()).setText(selectedContent.getDisplayName());
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        TerminalView terminalView = TerminalView.getInstance(project);
        Object object = selectedContent.getUserData(TerminalView.TERMINAL_WIDGET_KEY);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        JBTerminalWidget terminalWidget = (JBTerminalWidget)object;
        TerminalView terminalView2 = terminalView;
        Intrinsics.checkExpressionValueIsNotNull((Object)terminalView2, (String)"terminalView");
        LocalTerminalDirectRunner localTerminalDirectRunner = terminalView2.getTerminalRunner();
        Intrinsics.checkExpressionValueIsNotNull((Object)localTerminalDirectRunner, (String)"terminalView.terminalRunner");
        TerminalSessionVirtualFileImpl file = new TerminalSessionVirtualFileImpl(tabInfo, terminalWidget, (TabbedSettingsProvider)localTerminalDirectRunner.getSettingsProvider());
        tabInfo.setObject((Object)file);
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, Boolean.TRUE);
        Project project2 = e.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Object[] objectArray = FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)file, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"FileEditorManager.getIns\u2026t!!).openFile(file, true)");
        FileEditor fileEditor = (FileEditor)ArraysKt.first((Object[])objectArray);
        terminalWidget.moveDisposable((Disposable)fileEditor);
        activeToolWindow.getContentManager().removeContent(selectedContent, true);
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
    }
}

