/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.docker.debug;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.execution.ExecutionException;
import com.jetbrains.rider.plugins.docker.debug.ImageInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"extractContainerOriginConfig", "Lcom/jetbrains/rider/plugins/docker/debug/ImageInfo;", "runtime", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "rider-plugins-appender"})
public final class DockerDeploymentUtilKt {
    @NotNull
    public static final ImageInfo extractContainerOriginConfig(@NotNull DockerApplicationRuntime runtime) {
        DockerAgentApplication dockerAgentApplication;
        String containerId;
        block8: {
            DockerAgentApplication[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)runtime, (String)"runtime");
            DockerApplicationRuntime dockerApplicationRuntime = runtime;
            if (!(dockerApplicationRuntime instanceof DockerDeploymentRuntime)) {
                dockerApplicationRuntime = null;
            }
            DockerDeploymentRuntime dockerDeploymentRuntime = (DockerDeploymentRuntime)dockerApplicationRuntime;
            if (dockerDeploymentRuntime == null) {
                throw (Throwable)new ExecutionException("Debugging of this docker application is not supported (" + runtime.getClass() + ')');
            }
            DockerDeploymentRuntime deploymentRuntime = dockerDeploymentRuntime;
            containerId = deploymentRuntime.getImageId();
            DockerAgentApplication[] images = deploymentRuntime.getAgent().getImages(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)images, (String)"images");
            DockerAgentApplication[] dockerAgentApplicationArray = $receiver$iv = images;
            int n = dockerAgentApplicationArray.length;
            for (int i = 0; i < n; ++i) {
                DockerAgentApplication element$iv;
                DockerAgentApplication it;
                DockerAgentApplication dockerAgentApplication2 = it = (element$iv = dockerAgentApplicationArray[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)dockerAgentApplication2, (String)"it");
                String string = dockerAgentApplication2.getImageId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.imageId");
                CharSequence charSequence = string;
                String string2 = containerId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"containerId");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                dockerAgentApplication = element$iv;
                break block8;
            }
            dockerAgentApplication = null;
        }
        if (dockerAgentApplication == null) {
            throw (Throwable)new ExecutionException("Unable to find image corresponding to the container " + containerId);
        }
        DockerAgentApplication image = dockerAgentApplication;
        String string = image.computeInspectJson();
        if (string == null) {
            throw (Throwable)new ExecutionException("Unable to get inspection JSON for image " + image.getImageId());
        }
        String imageJson = string;
        try {
            ImageInfo imageInfo = (ImageInfo)new Gson().fromJson(imageJson, ImageInfo.class);
            if (imageInfo == null) {
                throw (Throwable)new ExecutionException("Container inspection returned empty response");
            }
            return imageInfo;
        }
        catch (JsonSyntaxException e) {
            throw (Throwable)new ExecutionException("Container inspection returned unexpected result: " + e.getMessage(), (Throwable)e);
        }
    }
}

