/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.intelliLang.backend;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.util.Processor;
import com.jetbrains.rdclient.util.idea.DisposableExKt;
import com.jetbrains.rider.plugins.intelliLang.backend.BackendInjectionInfo;
import com.jetbrains.rider.plugins.intelliLang.backend.BackendInjectionInfoKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/intelliLang/backend/BackendInjectionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createListener", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "getBackendInjection", "Lcom/jetbrains/rider/plugins/intelliLang/backend/BackendInjectionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isInjected", "", "registerDocument", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "registerInjection", "injectionInfo", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "removeInjection", "Companion", "rider-plugins-appender"})
public final class BackendInjectionManager {
    private final Project project;
    public static final Companion Companion = new Companion(null);

    public final void registerDocument(@NotNull Lifetime lifetime, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)this.project, (boolean)true);
        if (markupModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        }
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        markupModel2.addMarkupModelListener(DisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"BackendInjectionManager"), this.createListener());
    }

    public final boolean isInjected(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.getBackendInjection(editor) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BackendInjectionInfo getBackendInjection(@NotNull Editor editor) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)this.project, (boolean)true);
        if (markupModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        }
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        markupModel2.processRangeHighlightersOverlappingWith(offset, offset, (Processor)new Processor<RangeHighlighterEx>((Ref.ObjectRef)result){
            final /* synthetic */ Ref.ObjectRef $result;

            public final boolean process(RangeHighlighterEx it) {
                RangeHighlighterEx rangeHighlighterEx = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighterEx, (String)"it");
                BackendInjectionInfo injectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)rangeHighlighterEx);
                if (injectionInfo != null) {
                    this.$result.element = injectionInfo;
                }
                return (BackendInjectionInfo)this.$result.element == null;
            }
            {
                this.$result = objectRef;
            }
        });
        return (BackendInjectionInfo)result.element;
    }

    public final void registerInjection(@NotNull BackendInjectionInfo injectionInfo, @NotNull RangeMarker rangeMarker) {
        Intrinsics.checkParameterIsNotNull((Object)injectionInfo, (String)"injectionInfo");
        Intrinsics.checkParameterIsNotNull((Object)rangeMarker, (String)"rangeMarker");
        if (injectionInfo.isInjected()) {
            // empty if block
        }
    }

    public final void removeInjection(@NotNull BackendInjectionInfo injectionInfo, @NotNull RangeMarker rangeMarker) {
        Intrinsics.checkParameterIsNotNull((Object)injectionInfo, (String)"injectionInfo");
        Intrinsics.checkParameterIsNotNull((Object)rangeMarker, (String)"rangeMarker");
    }

    private final MarkupModelListener createListener() {
        return new MarkupModelListener(this){
            final /* synthetic */ BackendInjectionManager this$0;

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)highlighter);
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
                this.this$0.registerInjection(injectionInfo, (RangeMarker)highlighter);
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)highlighter);
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
                this.this$0.removeInjection(injectionInfo, (RangeMarker)highlighter);
            }

            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)highlighter);
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public BackendInjectionManager(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/intelliLang/backend/BackendInjectionManager$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/intelliLang/backend/BackendInjectionManager;", "project", "Lcom/intellij/openapi/project/Project;", "rider-plugins-appender"})
    public static final class Companion {
        @NotNull
        public final BackendInjectionManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ComponentManager $receiver$iv = (ComponentManager)project;
            Object object = $receiver$iv.getComponent(BackendInjectionManager.class);
            if (object == null) {
                throw (Throwable)new IllegalStateException("Component " + BackendInjectionManager.class + " not found in container " + $receiver$iv);
            }
            return (BackendInjectionManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

