/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.intelliLang.backend;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rdclient.services.ProtocolLanguageManagerKt;
import com.jetbrains.rider.model.HighlighterModel;
import com.jetbrains.rider.model.InjectionMarkHighlighterModel;
import com.jetbrains.rider.model.RdLanguage;
import com.jetbrains.rider.plugins.intelliLang.backend.BackendInjectionInfo;
import com.jetbrains.rider.plugins.intelliLang.backend.BackendInjectionInfoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/intelliLang/backend/InjectionMarkHighlighterModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "()V", "accept", "", "model", "Lcom/jetbrains/rider/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "move", "startOffset", "", "endOffset", "rider-plugins-appender"})
public final class InjectionMarkHighlighterModelHandler
implements IProtocolHighlighterModelHandler {
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return model instanceof InjectionMarkHighlighterModel;
    }

    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
        InjectionMarkHighlighterModel cfr_ignored_0 = (InjectionMarkHighlighterModel)model;
        BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo(highlighter);
        if (backendInjectionInfo == null) {
            return false;
        }
        BackendInjectionInfo injectionInfo = backendInjectionInfo;
        Language registeredLanguage = ProtocolLanguageManagerKt.toIdeaLanguage((RdLanguage)((InjectionMarkHighlighterModel)model).getLanguage());
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter) && Intrinsics.areEqual((Object)injectionInfo.getLanguage(), (Object)registeredLanguage) && ((InjectionMarkHighlighterModel)model).isInjected() == injectionInfo.isInjected();
    }

    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        InjectionMarkHighlighterModel injectionMarkHighlighterModel;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        InjectionMarkHighlighterModel $receiver = injectionMarkHighlighterModel = (InjectionMarkHighlighterModel)model;
        return (HighlighterModel)new InjectionMarkHighlighterModel($receiver.getLanguage(), $receiver.isInjected(), $receiver.getLayer(), $receiver.isExactRange(), $receiver.getDocumentVersion(), $receiver.getTextToHighlight(), $receiver.getId(), $receiver.getAttributeId(), startOffset, endOffset);
    }

    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
        InjectionMarkHighlighterModel cfr_ignored_0 = (InjectionMarkHighlighterModel)model;
        ((RangeHighlighterEx)highlighter).setTextAttributes(TextAttributes.ERASE_MARKER);
        Language language = ProtocolLanguageManagerKt.toIdeaLanguage((RdLanguage)((InjectionMarkHighlighterModel)model).getLanguage());
        if (language == null) {
            return;
        }
        Language language2 = language;
        BackendInjectionInfoKt.setInjectionInfo(highlighter, new BackendInjectionInfo((RangeMarker)highlighter, language2, ((InjectionMarkHighlighterModel)model).isInjected()));
    }
}

