/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.javascript.nodejs;

import com.intellij.javascript.nodejs.packageJson.PackageJsonNotifierConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.plugins.RiderProjectModelWebFilesCollector;
import com.jetbrains.rider.plugins.javascript.nodejs.RiderPackageJsonConfigurator;
import com.jetbrains.rider.plugins.javascript.nodejs.RiderPackageJsonConfiguratorHandler;
import com.jetbrains.rider.projectView.ProjectModelViewHost;
import com.jetbrains.rider.projectView.actions.projectTemplating.ExtensionsKt;
import com.jetbrains.rider.projectView.indexing.contentModel.ContentModelUserStore;
import com.jetbrains.rider.projectView.nodes.ProjectModelNode;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.util.idea.ApplicationKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.OptProperty;
import com.jetbrains.rider.util.reactive.SourceExKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/javascript/nodejs/RiderPackageJsonConfigurator;", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonNotifierConfiguration;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "projectModelHost", "Lcom/jetbrains/rider/projectView/ProjectModelViewHost;", "store", "Lcom/jetbrains/rider/projectView/indexing/contentModel/ContentModelUserStore;", "fileTypeManager", "Lcom/intellij/openapi/fileTypes/FileTypeManager;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/projectView/ProjectModelViewHost;Lcom/jetbrains/rider/projectView/indexing/contentModel/ContentModelUserStore;Lcom/intellij/openapi/fileTypes/FileTypeManager;)V", "detectPackageJsonFiles", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findInDirectory", "file", "Ljava/io/File;", "findInProject", "projectModelNode", "Lcom/jetbrains/rider/projectView/nodes/ProjectModelNode;", "isEssential", "", "packageJson", "isNpmPackageJson", "Companion", "rider-plugins-appender"})
public final class RiderPackageJsonConfigurator
extends LifetimedProjectComponent
implements PackageJsonNotifierConfiguration {
    private final ProjectModelViewHost projectModelHost;
    private final ContentModelUserStore store;
    private final FileTypeManager fileTypeManager;
    private static final ExtensionPointName<RiderPackageJsonConfiguratorHandler> EP_NAME;
    public static final Companion Companion;

    @NotNull
    public Promise<List<VirtualFile>> detectPackageJsonFiles() {
        AsyncPromise result = new AsyncPromise();
        ApplicationKt.getApplication().invokeLater(new Runnable(this, result){
            final /* synthetic */ RiderPackageJsonConfigurator this$0;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                RiderProjectModelWebFilesCollector visitor2 = new RiderProjectModelWebFilesCollector(this.this$0.getProject(), RiderPackageJsonConfigurator.access$getProjectModelHost$p(this.this$0), RiderPackageJsonConfigurator.access$getStore$p(this.this$0));
                OptProperty<List<VirtualFile>> trigger2 = visitor2.collectAllFiles((Function1<? super File, ? extends VirtualFile>)((Function1)new Function1<File, VirtualFile>(this.this$0){

                    @Nullable
                    public final VirtualFile invoke(@NotNull File p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return RiderPackageJsonConfigurator.access$findInDirectory((RiderPackageJsonConfigurator)((Object)this.receiver), p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(RiderPackageJsonConfigurator.class);
                    }

                    public final String getName() {
                        return "findInDirectory";
                    }

                    public final String getSignature() {
                        return "findInDirectory(Ljava/io/File;)Lcom/intellij/openapi/vfs/VirtualFile;";
                    }
                }), (Function1<? super ProjectModelNode, ? extends VirtualFile>)((Function1)new Function1<ProjectModelNode, VirtualFile>(this.this$0){

                    @Nullable
                    public final VirtualFile invoke(@NotNull ProjectModelNode p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return RiderPackageJsonConfigurator.access$findInProject((RiderPackageJsonConfigurator)((Object)this.receiver), p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(RiderPackageJsonConfigurator.class);
                    }

                    public final String getName() {
                        return "findInProject";
                    }

                    public final String getSignature() {
                        return "findInProject(Lcom/jetbrains/rider/projectView/nodes/ProjectModelNode;)Lcom/intellij/openapi/vfs/VirtualFile;";
                    }
                }));
                SourceExKt.adviseOnce((ISource)((ISource)trigger2), (Lifetime)this.this$0.getComponentLifetime(), (Function1)((Function1)new Function1<List<? extends VirtualFile>, Unit>(this){
                    final /* synthetic */ detectPackageJsonFiles.1 this$0;

                    public final void invoke(@NotNull List<? extends VirtualFile> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.this$0.$result.setResult(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = riderPackageJsonConfigurator;
                this.$result = asyncPromise;
            }
        });
        return (Promise)result;
    }

    private final VirtualFile findInDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        while (!directory.is(VFileProperty.SYMLINK)) {
            VirtualFile virtualFile2 = directory;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directory");
            Object[] objectArray = virtualFile2.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"directory.children");
            VirtualFile virtualFile3 = (VirtualFile)ArraysKt.singleOrNull((Object[])objectArray);
            if (virtualFile3 == null) break;
            if (!virtualFile3.isDirectory()) break;
            directory = directory.getChildren()[0];
        }
        VirtualFile virtualFile4 = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
        if (virtualFile4 == null) {
            return null;
        }
        return virtualFile4;
    }

    private final VirtualFile findInProject(ProjectModelNode projectModelNode) {
        if (!ProjectModelNodeExtensionKt.isProject((ProjectModelNode)projectModelNode)) {
            return null;
        }
        VirtualFile virtualFile = projectModelNode.getVirtualFile();
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        VirtualFile packageJsonInProject = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
        if (packageJsonInProject != null) {
            return packageJsonInProject;
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory.findChild("ClientApp"));
    }

    public boolean isEssential(@NotNull VirtualFile packageJson) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)packageJson, (String)"packageJson");
            ProjectModelNode projectModelNode = (ProjectModelNode)ArraysKt.firstOrNull((Object[])this.projectModelHost.getItemsByVirtualFile(packageJson));
            if (projectModelNode == null) {
                return false;
            }
            ProjectModelNode fileNode = projectModelNode;
            ProjectModelNode projectNode2 = ExtensionsKt.findParent((ProjectModelNode)fileNode, (Function1)isEssential.projectNode.1.INSTANCE);
            if (projectNode2 != null && Intrinsics.areEqual((Object)this.findInProject(projectNode2), (Object)packageJson)) {
                return true;
            }
            Iterable $receiver$iv = this.store.getExplicitIncludes();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    if (!Intrinsics.areEqual((Object)packageJson, (Object)this.findInDirectory(it))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNpmPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkParameterIsNotNull((Object)packageJson, (String)"packageJson");
        for (RiderPackageJsonConfiguratorHandler handler : EP_NAME.getExtensionList((AreaInstance)this.getProject())) {
            ThreeState isPackageNpmJson = handler.isNpmPackageJson(packageJson);
            if (isPackageNpmJson == ThreeState.UNSURE) continue;
            return isPackageNpmJson.toBoolean();
        }
        return true;
    }

    public RiderPackageJsonConfigurator(@NotNull Project project, @NotNull ProjectModelViewHost projectModelHost, @NotNull ContentModelUserStore store, @NotNull FileTypeManager fileTypeManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectModelHost, (String)"projectModelHost");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)fileTypeManager, (String)"fileTypeManager");
        super(project);
        this.projectModelHost = projectModelHost;
        this.store = store;
        this.fileTypeManager = fileTypeManager;
    }

    static {
        Companion = new Companion(null);
        EP_NAME = ExtensionPointName.create((String)"JavaScript.packageJson.configuration.handler");
    }

    @NotNull
    public static final /* synthetic */ ProjectModelViewHost access$getProjectModelHost$p(RiderPackageJsonConfigurator $this) {
        return $this.projectModelHost;
    }

    @NotNull
    public static final /* synthetic */ ContentModelUserStore access$getStore$p(RiderPackageJsonConfigurator $this) {
        return $this.store;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$findInDirectory(RiderPackageJsonConfigurator $this, @NotNull File file) {
        return $this.findInDirectory(file);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$findInProject(RiderPackageJsonConfigurator $this, @NotNull ProjectModelNode projectModelNode) {
        return $this.findInProject(projectModelNode);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/javascript/nodejs/RiderPackageJsonConfigurator$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rider/plugins/javascript/nodejs/RiderPackageJsonConfiguratorHandler;", "kotlin.jvm.PlatformType", "rider-plugins-appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

