/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDialect {
    @NotNull
    public Dbms getDbms();

    @NotNull
    public String getDisplayName();

    public char closeQuote();

    public char openQuote();

    @Nullable
    public String getNameForKind(@NotNull ObjectKind var1);

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public String quoteIdentifier(String var1, boolean var2, boolean var3);

    @Contract(value="null->null;!null->!null")
    public String unquoteIdentifier(String var1);

    @Contract(value="null->false")
    public boolean isQuotedIdentifier(@Nullable String var1);

    public boolean supportsCorrelatedSubQuery();

    @NotNull
    public String getTypeName(DataType var1);

    public int getJavaTypeForNativeType(@NotNull String var1);

    public String getBinaryLiteralString(byte[] var1);

    @Deprecated
    public boolean supportsAutoIncrement();

    @Deprecated
    public boolean supportsAlterAutoIncrement();

    @Deprecated
    public boolean supportsCheckOptionsForViews();

    @Deprecated
    public boolean supportsEmptyTables();

    public boolean supportsMultipleRowInserts();

    public boolean supportsInsertInto();

    public boolean supportsProduct(@Nullable String var1, @NotNull String var2);

    @Deprecated
    public boolean supportsAlterColumnNull();

    @Deprecated
    public boolean supportsAlterColumnType();

    @Deprecated
    public boolean supportsAlterColumnDefault();

    public boolean supportsViewDefinition();

    public boolean supportsSystemViewDefinition();

    public boolean supportsTableDefinition();

    public boolean supportsTableInfo();

    public boolean supportsProcedureDefinition();

    public boolean supportsPackageDefinition();

    public boolean supportsSequenceDefinition();

    public boolean supportsSynonymDefinition();

    public boolean supportsQualifiedAsteriskInCalls();

    public boolean supportsCommonTableExpression();

    @Deprecated
    public boolean supportsNotNullColumns();

    @Deprecated
    public boolean supportsDefaults();

    @Deprecated
    public boolean supportsUniqueIndices();

    @Deprecated
    public boolean supportsIndexColumnOrdering();
}

