/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmsBean
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<DbmsBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.dbmsBean");
    @Attribute(value="dbms")
    public String dbmsStr;
    @Attribute(value="dekaf")
    public String dekafStr;
    @Attribute(value="sqlDialect")
    public String sqlDialectStr;
    @Attribute(value="dbDialect")
    public String dbDialectStr;
    public final NotNullLazyValue<SqlLanguageDialect> sqlDialect = NotNullLazyValue.createValue(() -> (SqlLanguageDialect)((Object)((Object)this.getInstanceField(this.sqlDialectStr))));
    public final NotNullLazyValue<DatabaseDialect> databaseDialect = NotNullLazyValue.createValue(() -> (DatabaseDialect)this.getInstanceField(this.dbDialectStr));
    public final NotNullLazyValue<Dbms> dbms = NotNullLazyValue.createValue(() -> (Dbms)ObjectUtils.notNull((Object)Dbms.byName(this.dbmsStr)));

    public String toString() {
        return "DbmsBean: " + this.dbmsStr + " (" + this.dekafStr + "/" + StringUtil.getShortName((String)this.sqlDialectStr) + "/" + StringUtil.getShortName((String)this.dbDialectStr) + ")";
    }

    @Nullable
    public static DbmsBean findByDbms(@Nullable Dbms dbms) {
        return dbms == null ? null : (DbmsBean)((Object)JBIterable.of((Object[])DbmsBean.getExtensions()).find(o -> dbms.equals(o.dbms.getValue())));
    }

    private <T> T getInstanceField(String className) {
        try {
            Class clazz = this.findClass(className);
            Field field = clazz.getField("INSTANCE");
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new AssertionError((Object)"INSTANCE field is not static");
            }
            return (T)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public <T> T getDialectClass(String suffix) {
        for (String str : (String[])ContainerUtil.ar((Object[])new String[]{this.sqlDialectStr, this.dbDialectStr, this.sqlDialectStr.replace(".sql.dialects.", ".database.dialects.")})) {
            Object object;
            try {
                object = ReflectionUtil.newInstance(Class.forName(str.replace("Dialect", suffix)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (object == null) {
                DbmsBean.$$$reportNull$$$0(0);
            }
            return (T)object;
        }
        throw new AssertionError((Object)(suffix + " class not found for " + this.dbmsStr));
    }

    @NotNull
    public static DbmsBean[] getExtensions() {
        if (Extensions.getRootArea().hasExtensionPoint(EP_NAME)) {
            DbmsBean[] dbmsBeanArray = (DbmsBean[])EP_NAME.getExtensions();
            if (dbmsBeanArray == null) {
                DbmsBean.$$$reportNull$$$0(1);
            }
            return dbmsBeanArray;
        }
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            DbmsBean[] dbmsBeanArray = TestHelper.getExtensions();
            if (dbmsBeanArray == null) {
                DbmsBean.$$$reportNull$$$0(2);
            }
            return dbmsBeanArray;
        }
        DbmsBean[] dbmsBeanArray = new DbmsBean[]{};
        if (dbmsBeanArray == null) {
            DbmsBean.$$$reportNull$$$0(3);
        }
        return dbmsBeanArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/dialects/DbmsBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TestHelper {
        static final DbmsBean[] ourBeans;

        private TestHelper() {
        }

        @NotNull
        public static DbmsBean[] getExtensions() {
            if (ourBeans == null) {
                TestHelper.$$$reportNull$$$0(0);
            }
            return ourBeans;
        }

        static {
            DbmsBean[] result = new DbmsBean[]{};
            URL xml = DbmsBean.class.getClassLoader().getResource("/META-INF/SqlDialects.xml");
            if (xml != null) {
                try (InputStream stream = xml.openStream();){
                    class MyOrderable
                    implements LoadingOrder.Orderable {
                        final DbmsBean bean;
                        final String orderId;
                        final LoadingOrder order;

                        MyOrderable(Element e) {
                            this.bean = (DbmsBean)((Object)XmlSerializer.deserialize((Element)e, DbmsBean.class));
                            this.orderId = e.getAttributeValue("id");
                            this.order = LoadingOrder.readOrder((String)e.getAttributeValue("order"));
                        }

                        @Nullable
                        public String getOrderId() {
                            return this.orderId;
                        }

                        public LoadingOrder getOrder() {
                            return this.order;
                        }
                    }
                    List contents = JDOMXIncluder.resolve((Element)JDOMUtil.load((InputStream)stream), (String)xml.toExternalForm());
                    List list = (List)JBIterable.from((Iterable)contents).filter(Element.class).flatten(e -> e.getChildren("extensions")).flatten(e -> e.getChildren()).filter(e -> e.getName().endsWith("dbmsBean")).map(x$0 -> new MyOrderable((Element)x$0)).addAllTo(new ArrayList());
                    LoadingOrder.sort((List)list);
                    result = JBIterable.from((Iterable)list).map(o -> o.bean).toList().toArray(result);
                }
                catch (Exception e2) {
                    throw new AssertionError("Failed to load dbms list", e2);
                }
            }
            ourBeans = result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/DbmsBean$TestHelper", "getExtensions"));
        }
    }
}

