/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ComponentElementProperties;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FieldPanel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001aH\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\nH\u0014J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020#H\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/configurationStore/ChooseComponentsToExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "fileToComponents", "", "Ljava/nio/file/Path;", "", "Lcom/intellij/configurationStore/ExportableItem;", "isShowFilePath", "", "title", "", "description", "(Ljava/util/Map;ZLjava/lang/String;Ljava/lang/String;)V", "chooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lcom/intellij/configurationStore/ComponentElementProperties;", "exportFile", "getExportFile$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "exportableComponents", "", "getExportableComponents$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "pathPanel", "Lcom/intellij/ui/FieldPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createNorthPanel", "Ljavax/swing/JLabel;", "createSouthPanel", "doOKAction", "", "getDimensionServiceKey", "getPreferredFocusedComponent", "Ljavax/swing/JTextField;", "updateControls", "intellij.platform.configurationStore.impl"})
public final class ChooseComponentsToExportDialog
extends DialogWrapper {
    private final ElementsChooser<ComponentElementProperties> chooser;
    private final FieldPanel pathPanel;
    private final boolean isShowFilePath;
    private final String description;

    @NotNull
    public final Set<ExportableItem> getExportableComponents$intellij_platform_configurationStore_impl() {
        THashSet components = new THashSet();
        for (ComponentElementProperties elementProperties : this.chooser.getMarkedElements()) {
            components.addAll((Collection)elementProperties.getItems());
        }
        return (Set)components;
    }

    @NotNull
    public final Path getExportFile$intellij_platform_configurationStore_impl() {
        Path path = Paths.get(this.pathPanel.getText(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(pathPanel.text)");
        return path;
    }

    private final void updateControls() {
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.pathPanel.getText()));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction selectAll2 = new AbstractAction(this, "Select &All"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(true);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        AbstractAction selectNone2 = new AbstractAction(this, "Select &None"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(false);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        AbstractAction invert2 = new AbstractAction(this, "&Invert"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).invertSelection();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        return new Action[]{selectAll2, selectNone2, invert2};
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.pathPanel.getText(), ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        StringBuilder builder2 = new StringBuilder();
        if (this.chooser.hasUnmarkedElements()) {
            List<ComponentElementProperties> marked = this.chooser.getElements(true);
            for (ComponentElementProperties element : marked) {
                builder2.append(element.getFileName());
                builder2.append("|");
            }
        }
        CharSequence charSequence = builder2;
        String string = "export.settings.marked";
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        boolean bl = charSequence.length() == 0;
        propertiesComponent.setValue(string, bl ? null : builder2.toString());
        super.doOKAction();
    }

    @Nullable
    public JTextField getPreferredFocusedComponent() {
        return this.pathPanel.getTextField();
    }

    @NotNull
    protected JLabel createNorthPanel() {
        return new JLabel(this.description);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.chooser;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.isShowFilePath) {
            JComponent jComponent = buttons;
            Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"buttons");
            return jComponent;
        }
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.add((Component)this.pathPanel);
        panel2.add(buttons);
        return panel2;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    public ChooseComponentsToExportDialog(@NotNull Map<Path, ? extends List<ExportableItem>> fileToComponents, boolean isShowFilePath, @NotNull String title, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull(fileToComponents, (String)"fileToComponents");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        super(false);
        this.isShowFilePath = isShowFilePath;
        this.description = description;
        this.pathPanel = new FieldPanel(IdeBundle.message((String)"editbox.export.settings.to", (Object[])new Object[0]), null, null, null);
        this.pathPanel.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                String string = pathPanel.getText();
                Component component = this.getWindow();
                String string2 = IdeBundle.message((String)"title.export.file.location", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"title.export.file.location\")");
                String string3 = IdeBundle.message((String)"prompt.choose.export.settings.file.path", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"promp\u2026port.settings.file.path\")");
                ChooseComponentsToExportDialogKt.chooseSettingsFile(string, component, string2, string3).onSuccess((Consumer)new Consumer<String>(){

                    @Override
                    public final void accept(String path) {
                        pathPanel.setText(FileUtil.toSystemDependentName((String)path));
                    }
                });
            }
        });
        LinkedHashMap componentToContainingListElement = new LinkedHashMap();
        for (List<ExportableItem> list2 : fileToComponents.values()) {
            for (ExportableItem item : list2) {
                if (ChooseComponentsToExportDialogKt.access$addToExistingListElement(item, componentToContainingListElement, fileToComponents)) continue;
                ComponentElementProperties componentElementProperties = new ComponentElementProperties();
                componentElementProperties.getItems().add((Object)item);
                Map map = componentToContainingListElement;
                map.put(item, componentElementProperties);
            }
        }
        this.chooser = new ElementsChooser(true);
        this.chooser.setColorUnmarkedElements(false);
        Set set = ChooseComponentsToExportDialogKt.access$getMarkedElementNames$p();
        for (ComponentElementProperties componentElementProperty : new LinkedHashSet(componentToContainingListElement.values())) {
            this.chooser.addElement(componentElementProperty, set.isEmpty() || set.contains(componentElementProperty.getFileName()), (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.chooser.sort(Comparator.comparing(2.INSTANCE));
        String exportPath = PropertiesComponent.getInstance().getValue("export.settings.path", ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        this.pathPanel.setText(exportPath);
        this.pathPanel.setChangeListener(new Runnable(){

            @Override
            public final void run() {
                this.updateControls();
            }
        });
        this.updateControls();
        this.setTitle(title);
        this.init();
    }

    @NotNull
    public static final /* synthetic */ ElementsChooser access$getChooser$p(ChooseComponentsToExportDialog $this) {
        return $this.chooser;
    }
}

