/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.SaveSessionAndFile;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u001a,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0000\u001a\u001b\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a \u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\b\u0010 \u001a\u00020\rH\u0000\u001a\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0005H\u0000\u001a\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$*\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0017H\u0000\u00a2\u0006\u0002\u0010%\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD", "", "NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT", "deprecatedComparator", "Ljava/util/Comparator;", "Lcom/intellij/openapi/components/Storage;", "getDeprecatedComparator", "()Ljava/util/Comparator;", "executeSave", "", "session", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "", "Lcom/intellij/openapi/components/impl/stores/SaveSessionAndFile;", "errors", "", "findNonDeprecated", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Lcom/intellij/openapi/components/Storage;", "notifyUnknownMacros", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "restoreDefaultNotRoamableComponentSaveThreshold", "setRoamableComponentSaveThreshold", "thresholdInSeconds", "sortByDeprecated", "", "([Lcom/intellij/openapi/components/Storage;)Ljava/util/List;", "intellij.platform.configurationStore.impl"})
public final class ComponentStoreImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    @NotNull
    private static final Comparator<Storage> deprecatedComparator = deprecatedComparator.1.INSTANCE;
    private static final int NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    private static int NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final Comparator<Storage> getDeprecatedComparator() {
        return deprecatedComparator;
    }

    public static final void restoreDefaultNotRoamableComponentSaveThreshold() {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    }

    public static final void setRoamableComponentSaveThreshold(int thresholdInSeconds) {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = thresholdInSeconds;
    }

    public static final void executeSave(@NotNull StateStorage.SaveSession session2, @NotNull List<SaveSessionAndFile> readonlyFiles, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        try {
            session2.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            StateStorage.SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session2;
            }
            readonlyFiles.add(new SaveSessionAndFile(saveSession, e.getFile()));
        }
        catch (Exception e) {
            errors.add(e);
        }
    }

    private static final Storage findNonDeprecated(Storage[] storages) {
        Storage storage2;
        block2: {
            Storage[] $receiver$iv;
            for (Storage element$iv : $receiver$iv = storages) {
                Storage it = element$iv;
                if (!(!it.deprecated())) continue;
                storage2 = element$iv;
                break block2;
            }
            storage2 = null;
        }
        if (storage2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"All storages are deprecated"));
        }
        return storage2;
    }

    @NotNull
    public static final List<Storage> sortByDeprecated(@NotNull Storage[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.length < 2) {
            return ArraysKt.toList((Object[])$receiver);
        }
        if (!((Storage)ArraysKt.first((Object[])$receiver)).deprecated()) {
            boolean othersAreDeprecated;
            block6: {
                boolean bl;
                Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)$receiver.length);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv = ((IntIterator)iterator).nextInt();
                        int it = element$iv;
                        if (!$receiver[it].deprecated()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = othersAreDeprecated = false;
                }
            }
            if (othersAreDeprecated) {
                return ArraysKt.toList((Object[])$receiver);
            }
        }
        return ArraysKt.sortedWith((Object[])$receiver, deprecatedComparator);
    }

    private static final void notifyUnknownMacros(IComponentStore store, Project project, String componentName) {
        PathMacroSubstitutor pathMacroSubstitutor = store.getStorageManager().getMacroSubstitutor();
        if (!(pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor)) {
            pathMacroSubstitutor = null;
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = (TrackingPathMacroSubstitutor)pathMacroSubstitutor;
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> immutableMacros = substitutor.getUnknownMacros(componentName);
        if (immutableMacros.isEmpty()) {
            return;
        }
        LinkedHashSet macros = new LinkedHashSet(immutableMacros);
        AppUIUtil.invokeOnEdt(new Runnable(project, macros, componentName, substitutor, store){
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashSet $macros;
            final /* synthetic */ String $componentName;
            final /* synthetic */ TrackingPathMacroSubstitutor $substitutor;
            final /* synthetic */ IComponentStore $store;

            public final void run() {
                List notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, this.$project)) {
                    if (notified == null) {
                        notified = (List)new SmartList();
                    }
                    UnknownMacroNotification unknownMacroNotification = notification;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)unknownMacroNotification), (String)"notification");
                    Collection<String> collection = unknownMacroNotification.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"notification.macros");
                    notified.addAll(collection);
                }
                if (!UtilKt.isNullOrEmpty((Collection)notified)) {
                    List list2 = notified;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$macros.removeAll(list2);
                }
                if (this.$macros.isEmpty()) {
                    return;
                }
                ComponentStoreImplKt.getLOG().debug("Reporting unknown path macros " + this.$macros + " in component " + this.$componentName);
                Set set = this.$macros;
                Map<TrackingPathMacroSubstitutor, IComponentStore> map = Collections.singletonMap(this.$substitutor, this.$store);
                Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.singletonMap(substitutor, store)");
                StorageUtilKt.doNotify(set, this.$project, map);
            }
            {
                this.$project = project;
                this.$macros = linkedHashSet;
                this.$componentName = string;
                this.$substitutor = trackingPathMacroSubstitutor;
                this.$store = iComponentStore;
            }
        }, project.getDisposed());
    }

    static {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT = (int)TimeUnit.MINUTES.toSeconds(4L);
    }

    public static final /* synthetic */ void access$notifyUnknownMacros(@NotNull IComponentStore store, @NotNull Project project, @NotNull String componentName) {
        ComponentStoreImplKt.notifyUnknownMacros(store, project, componentName);
    }

    public static final /* synthetic */ int access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p() {
        return NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD;
    }

    public static final /* synthetic */ void access$setNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p(int n) {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = n;
    }

    public static final /* synthetic */ int access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT$p() {
        return NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    }

    @NotNull
    public static final /* synthetic */ Storage access$findNonDeprecated(@NotNull Storage[] storages) {
        return ComponentStoreImplKt.findNonDeprecated(storages);
    }
}

