/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001<BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\n\u0010+\u001a\u0004\u0018\u00010,H\u0014J\n\u0010-\u001a\u0004\u0018\u00010,H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fJ\u0018\u00101\u001a\u00020/2\u000e\u00102\u001a\n\u0018\u000103j\u0004\u0018\u0001`4H\u0004J$\u00105\u001a\u0004\u0018\u0001H6\"\u0004\b\u0000\u001062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H608H\u0084\b\u00a2\u0006\u0002\u00109J\u001a\u0010\u0019\u001a\u00020/2\b\u0010$\u001a\u0004\u0018\u00010\u00152\b\u0010:\u001a\u0004\u0018\u00010\u0003J\b\u0010;\u001a\u00020\u0005H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006="}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSavingTheContent", "", "getBlockSavingTheContent", "()Z", "setBlockSavingTheContent", "(Z)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "getFile", "()Ljava/nio/file/Path;", "setFile", "(Ljava/nio/file/Path;)V", "isUseUnixLineSeparator", "isUseVfsForWrite", "isUseXmlProlog", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "getLineSeparator", "()Lcom/intellij/util/LineSeparator;", "setLineSeparator", "(Lcom/intellij/util/LineSeparator;)V", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "loadLocalData", "Lorg/jdom/Element;", "loadLocalDataUsingIo", "preloadStorageData", "", "isEmpty", "processReadException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runAndHandleExceptions", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ioFileIfChanged", "toString", "FileSaveSession", "intellij.platform.configurationStore.impl"})
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    @Nullable
    private LineSeparator lineSeparator;
    private boolean blockSavingTheContent;
    @NotNull
    private volatile Path file;
    private final boolean isUseXmlProlog = false;
    private final boolean isUseVfsForWrite = true;

    @Nullable
    protected final LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    protected final void setLineSeparator(@Nullable LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    protected final boolean getBlockSavingTheContent() {
        return this.blockSavingTheContent;
    }

    protected final void setBlockSavingTheContent(boolean bl) {
        this.blockSavingTheContent = bl;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    private final void setFile(Path path) {
        this.file = path;
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    protected boolean isUseVfsForWrite() {
        return this.isUseVfsForWrite;
    }

    private final boolean isUseUnixLineSeparator() {
        return !this.isUseXmlProlog();
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable Path ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            VirtualFile virtualFile = result2 = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.file));
            if (virtualFile != null) {
                virtualFile.setCharset(StandardCharsets.UTF_8);
            }
            this.cachedVirtualFile = result2;
        }
        return this.cachedVirtualFile;
    }

    @Nullable
    protected final <T> T runAndHandleExceptions(@NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (JDOMException e) {
            this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.processReadException(e);
        }
        return null;
    }

    public final void preloadStorageData(boolean isEmpty2) {
        if (isEmpty2) {
            this.getStorageDataRef().set(StateMap.Companion.getEMPTY());
        } else {
            StateStorageBase.getStorageData$default(this, false, 1, null);
        }
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        Element element;
        block3: {
            this.blockSavingTheContent = false;
            FileBasedStorage this_$iv = this;
            try {
                element = this.loadLocalDataUsingIo();
                break block3;
            }
            catch (JDOMException e$iv) {
                this_$iv.processReadException((Exception)((Object)e$iv));
            }
            catch (IOException e$iv) {
                this_$iv.processReadException(e$iv);
            }
            element = null;
        }
        return element;
    }

    private final Element loadLocalDataUsingIo() {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            Logger logger = ComponentStoreImplKt.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            Logger $receiver$iv = logger;
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger2 = $receiver$iv;
                String string = "Document was not loaded for " + this.getFileSpec() + ", doesn't exist";
                logger2.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        BasicFileAttributes basicFileAttributes = attributes;
        Intrinsics.checkExpressionValueIsNotNull((Object)basicFileAttributes, (String)"attributes");
        if (!basicFileAttributes.isRegularFile()) {
            Logger logger = ComponentStoreImplKt.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            Logger $receiver$iv = logger;
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger3 = $receiver$iv;
                String string = "Document was not loaded for " + this.getFileSpec() + ", not a file";
                logger3.debug(string, (Throwable)e$iv);
            }
        } else if (attributes.size() == 0L) {
            this.processReadException(null);
        } else {
            if (this.isUseUnixLineSeparator()) {
                this.lineSeparator = LineSeparator.LF;
                return JdomKt.loadElement((Path)this.file);
            }
            CharSequence data = PathKt.readChars((Path)this.file);
            this.lineSeparator = FileBasedStorageKt.detectLineSeparators(data, this.isUseXmlProlog() ? null : LineSeparator.LF);
            return JdomKt.loadElement((CharSequence)data);
        }
        return null;
    }

    protected final void processReadException(@Nullable Exception e) {
        Application app;
        boolean contentTruncated = e == null;
        boolean bl = this.blockSavingTheContent = !contentTruncated && (Intrinsics.areEqual((Object)"$PROJECT_FILE$", (Object)this.getFileSpec()) || StringsKt.startsWith$default((String)this.getFileSpec(), (String)"$PROJECT_CONFIG_DIR$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$MODULE_FILE$") || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"));
        if (e != null) {
            ComponentStoreImplKt.getLOG().warn((Throwable)e);
        }
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (!application.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            String string;
            if (contentTruncated) {
                string = "content truncated";
            } else {
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                string = exception.getMessage();
            }
            String reason = string;
            String action = this.blockSavingTheContent ? "Please correct the file content" : "File content will be recreated";
            new Notification("System Messages", "Load Settings", "Cannot load settings from file '" + this.file + "': " + reason + '\n' + action, NotificationType.WARNING).notify(null);
        }
    }

    @NotNull
    public String toString() {
        return PathKt.getSystemIndependentPath((Path)this.file);
    }

    public FileBasedStorage(@NotNull Path file2, @NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && StringsKt.startsWith$default((CharSequence)((Object)file2).toString(), (char)'$', (boolean)false, (int)2, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file2)));
        }
        this.isUseVfsForWrite = true;
    }

    public /* synthetic */ FileBasedStorage(Path path, String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(path, string, string2, pathMacroSubstitutor, roamingType, streamProvider);
    }

    @NotNull
    public static final /* synthetic */ Path access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, @NotNull Path path) {
        $this.file = path;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "save", "", "saveLocally", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "intellij.platform.configurationStore.impl"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        public void save() {
            if (((FileBasedStorage)this.getStorage()).getBlockSavingTheContent()) {
                ComponentStoreImplKt.getLOG().info("Save blocked for " + ((FileBasedStorage)this.getStorage()).getFileSpec());
            } else {
                super.save();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void saveLocally(@Nullable DataWriter dataWriter) {
            boolean isUseVfs;
            VirtualFile virtualFile;
            LineSeparator lineSeparator = ((FileBasedStorage)this.getStorage()).getLineSeparator();
            if (lineSeparator == null) {
                lineSeparator = ((FileBasedStorage)this.getStorage()).isUseUnixLineSeparator() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
                ((FileBasedStorage)this.getStorage()).setLineSeparator(lineSeparator);
            }
            VirtualFile virtualFile2 = virtualFile = (isUseVfs = ((FileBasedStorage)this.getStorage()).isUseVfsForWrite()) ? ((FileBasedStorage)this.getStorage()).getVirtualFile() : null;
            if (dataWriter == null) {
                if (isUseVfs && virtualFile == null) {
                    ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + virtualFile);
                }
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
                return;
            }
            if (isUseVfs) {
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = FileBasedStorageKt.writeFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile, dataWriter, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
                return;
            }
            Path file2 = ((FileBasedStorage)this.getStorage()).getFile();
            Logger logger = ComponentStoreImplKt.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            Logger $receiver$iv = logger;
            Exception e$iv = null;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode()) {
                Logger logger2 = $receiver$iv;
                String string = "Save " + file2;
                logger2.info(string);
            } else {
                Logger $receiver$iv$iv = $receiver$iv;
                if ($receiver$iv$iv.isDebugEnabled()) {
                    Logger logger3 = $receiver$iv$iv;
                    String string = "Save " + file2;
                    logger3.debug(string, (Throwable)e$iv);
                }
            }
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            XmlElementStorageKt.writeTo(dataWriter, file2, string);
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

