/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.SaveExecutor;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.SaveSessionAndFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectNameProvider;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J,\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0005H\u0004J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ProjectStoreBase;", "project", "Lcom/intellij/openapi/project/Project;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/components/PathMacroManager;)V", "lastSavedProjectName", "", "storageManager", "Lcom/intellij/configurationStore/ProjectStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ProjectStateStorageManager;", "beforeSave", "", "readonlyFiles", "", "Lcom/intellij/openapi/components/impl/stores/SaveSessionAndFile;", "doSave", "saveSession", "Lcom/intellij/configurationStore/SaveExecutor;", "errors", "", "getPathMacroManagerForDefaults", "getProjectName", "saveProjectName", "setPath", "path", "intellij.platform.configurationStore.impl"})
class ProjectStoreImpl
extends ProjectStoreBase {
    private String lastSavedProjectName;
    @NotNull
    private final ProjectStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    public ProjectStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.setPath(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getProjectName() {
        String string;
        String string2;
        String baseDir;
        block22: {
            Object object;
            Object $receiver$iv;
            if (!this.isDirectoryBased()) {
                String string3 = PathUtilRt.getFileName((String)this.getProjectFilePath());
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtilRt.getFileName(projectFilePath)");
                return StringsKt.removeSuffix((String)string3, (CharSequence)".ipr");
            }
            baseDir = this.getProjectBasePath();
            Path nameFile = ProjectStoreImplKt.getNameFile(this);
            if (PathKt.exists((Path)nameFile)) {
                Logger logger = ComponentStoreImplKt.getLOG();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                $receiver$iv = logger;
                try {
                    BufferedReader bufferedReader;
                    void $receiver$iv2;
                    object = PathKt.inputStream((Path)nameFile);
                    Object object2 = Charsets.UTF_8;
                    object = new InputStreamReader((InputStream)object, (Charset)object2);
                    object2 = $receiver$iv2;
                    int n = 8192;
                    object2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    Throwable throwable = null;
                    try {
                        String string4;
                        Object v2;
                        Object $receiver$iv3;
                        BufferedReader it$iv;
                        block20: {
                            Sequence line;
                            it$iv = (BufferedReader)object2;
                            $receiver$iv3 = line = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            for (Object element$iv : $receiver$iv3) {
                                String it = (String)element$iv;
                                CharSequence charSequence = it;
                                if (!(!(charSequence.length() == 0))) continue;
                                v2 = element$iv;
                                break block20;
                            }
                            v2 = null;
                        }
                        String string5 = v2;
                        if (string5 != null) {
                            Object object3 = $receiver$iv3 = string5;
                            if (object3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                        } else {
                            string4 = null;
                        }
                        it$iv = string4;
                        bufferedReader = it$iv;
                    }
                    catch (Throwable it$iv) {
                        throwable = it$iv;
                        throw it$iv;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    if (bufferedReader != null) {
                        Object it;
                        this.lastSavedProjectName = it = (object = bufferedReader);
                        return it;
                    }
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
            }
            ExtensionPointName<ProjectNameProvider> extensionPointName = ProjectNameProvider.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ProjectNameProvider.EP_NAME");
            List list2 = extensionPointName.getExtensionList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ProjectNameProvider.EP_NAME.extensionList");
            $receiver$iv = list2;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                String result$iv;
                String string6;
                Object item$iv = object.next();
                ProjectNameProvider it = (ProjectNameProvider)item$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)ComponentStoreImplKt.getLOG(), (String)"LOG");
                try {
                    string6 = it.getDefaultName(this.getProject$intellij_platform_configurationStore_impl());
                }
                catch (ProcessCanceledException e$iv) {
                    string6 = null;
                }
                catch (Throwable e$iv) {
                    Logger $receiver$iv4;
                    $receiver$iv4.error(e$iv);
                    string6 = null;
                }
                if ((result$iv = string6) == null) continue;
                string2 = result$iv;
                break block22;
            }
            string2 = string = null;
        }
        if (string2 == null) {
            String string7 = PathUtilRt.getFileName((String)baseDir);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"PathUtilRt.getFileName(baseDir)");
            string = StringsKt.replace$default((String)string7, (String)":", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    private final void saveProjectName() {
        if (!this.isDirectoryBased()) {
            return;
        }
        String currentProjectName = this.getProject$intellij_platform_configurationStore_impl().getName();
        if (Intrinsics.areEqual((Object)this.lastSavedProjectName, (Object)currentProjectName)) {
            return;
        }
        this.lastSavedProjectName = currentProjectName;
        String basePath = this.getProjectBasePath();
        if (Intrinsics.areEqual((Object)currentProjectName, (Object)PathUtilRt.getFileName((String)basePath))) {
            PathKt.delete((Path)ProjectStoreImplKt.getNameFile(this));
        } else {
            Path path = Paths.get(basePath, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(basePath)");
            if (PathKt.isDirectory((Path)path)) {
                Path path2 = ProjectStoreImplKt.getNameFile(this);
                String string = currentProjectName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentProjectName");
                String string2 = string;
                Path path3 = path2;
                Charset charset = Charsets.UTF_8;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                PathKt.write$default((Path)path3, (byte[])byArray2, (int)0, (int)0, (int)6, null);
            }
        }
    }

    @Override
    protected void doSave(@NotNull SaveExecutor saveSession, @NotNull List<SaveSessionAndFile> readonlyFiles, @NotNull List<Throwable> errors) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)saveSession, (String)"saveSession");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        try {
            this.saveProjectName();
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Unable to store project name", e);
        }
        this.beforeSave(readonlyFiles);
        super.doSave(saveSession, readonlyFiles, errors);
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, this.getProject$intellij_platform_configurationStore_impl());
        if (readonlyFiles.isEmpty()) {
            for (ProjectManagerImpl.UnableToSaveProjectNotification notification : notifications) {
                notification.expire();
            }
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)notifications, (String)"notifications");
        ProjectManagerImpl.UnableToSaveProjectNotification[] notification = notifications;
        if (!(notification.length == 0)) {
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        ReadonlyStatusHandler.OperationStatus status = (ReadonlyStatusHandler.OperationStatus)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, readonlyFiles){
            final /* synthetic */ ProjectStoreImpl this$0;
            final /* synthetic */ List $readonlyFiles$inlined;
            {
                this.this$0 = projectStoreImpl;
                this.$readonlyFiles$inlined = list2;
            }

            public final T compute() {
                VirtualFile[] virtualFileArray = ProjectStoreImplKt.access$getFilesList(this.$readonlyFiles$inlined);
                return (T)ReadonlyStatusHandler.getInstance((Project)this.this$0.getProject$intellij_platform_configurationStore_impl()).ensureFilesWritable(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            }
        });
        if (status.hasReadonlyFiles()) {
            Project project = this.getProject$intellij_platform_configurationStore_impl();
            ReadonlyStatusHandler.OperationStatus operationStatus = status;
            Intrinsics.checkExpressionValueIsNotNull((Object)operationStatus, (String)"status");
            VirtualFile[] virtualFileArray = operationStatus.getReadonlyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"status.readonlyFiles");
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(project, virtualFileArray);
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)readonlyFiles;
        SaveSessionAndFile[] saveSessionAndFileArray = thisCollection$iv.toArray(new SaveSessionAndFile[0]);
        if (saveSessionAndFileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        SaveSessionAndFile[] oldList = saveSessionAndFileArray;
        readonlyFiles.clear();
        for (SaveSessionAndFile entry : oldList) {
            ComponentStoreImplKt.executeSave(entry.getSession(), readonlyFiles, errors);
        }
        CompoundRuntimeException.throwIfNotEmpty(errors);
        if (!readonlyFiles.isEmpty()) {
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(this.getProject$intellij_platform_configurationStore_impl(), ProjectStoreImplKt.access$getFilesList(readonlyFiles));
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
    }

    protected void beforeSave(@NotNull List<SaveSessionAndFile> readonlyFiles) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
    }

    public ProjectStoreImpl(@NotNull Project project, @NotNull PathMacroManager pathMacroManager) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(project);
        this.pathMacroManager = pathMacroManager;
        boolean bl2 = bl = !project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.storageManager = new ProjectStateStorageManager(new TrackingPathMacroSubstitutorImpl(this.pathMacroManager), project, false, 4, null);
    }
}

