/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.SafeWriteUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.PathKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a0\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u0002\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\nH\u0000\u00a8\u0006\u0017"}, d2={"createDataWriterForElement", "Lcom/intellij/configurationStore/DataWriter;", "element", "Lorg/jdom/Element;", "save", "", "states", "Lcom/intellij/configurationStore/StateMap;", "newLiveStates", "", "", "getChangedComponentNames", "", "newStates", "normalizeRootName", "toBufferExposingByteArray", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "writeTo", "", "file", "Ljava/nio/file/Path;", "intellij.platform.configurationStore.impl"})
public final class XmlElementStorageKt {
    private static final List<Element> save(StateMap states, Map<String, ? extends Element> newLiveStates) {
        if (states.isEmpty()) {
            return null;
        }
        List result2 = null;
        for (String componentName : states.keys()) {
            Element element;
            try {
                Element element2 = states.getElement(componentName, newLiveStates);
                if (element2 == null || (element2 = element2.clone()) == null) {
                    continue;
                }
                element = element2;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error("Cannot save \"" + componentName + "\" data", (Throwable)e);
                continue;
            }
            List elementAttributes = element.getAttributes();
            Attribute nameAttribute = element.getAttribute("name");
            if (nameAttribute == null || nameAttribute != (Attribute)elementAttributes.get(0) || !Intrinsics.areEqual((Object)componentName, (Object)nameAttribute.getValue())) {
                if (nameAttribute == null) {
                    nameAttribute = new Attribute("name", componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue(componentName);
                    if (Intrinsics.areEqual((Object)((Attribute)elementAttributes.get(0)), (Object)nameAttribute) ^ true) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            if (result2 == null) {
                result2 = (List)new SmartList();
            }
            result2.add(element);
        }
        return result2;
    }

    static /* synthetic */ List save$default(StateMap stateMap, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return XmlElementStorageKt.save(stateMap, map);
    }

    @NotNull
    public static final Element normalizeRootName(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (JDOMInterner.isInterned((Element)$receiver)) {
            Element clone;
            if (Intrinsics.areEqual((Object)$receiver.getName(), (Object)"component")) {
                return $receiver;
            }
            Element element = clone = $receiver.clone();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"clone");
            element.setName("component");
            return clone;
        }
        if ($receiver.getParent() != null) {
            ComponentStoreImplKt.getLOG().warn("State element must not have parent: " + JDOMUtil.writeElement((Element)$receiver));
            $receiver.detach();
        }
        $receiver.setName("component");
        return $receiver;
    }

    private static final Set<String> getChangedComponentNames(@NotNull StateMap $receiver, StateMap newStates) {
        Set bothStates = ArraysKt.toMutableSet((Object[])$receiver.keys());
        CollectionsKt.retainAll((Collection)bothStates, (Object[])newStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])newStates.keys());
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])$receiver.keys());
        diffs.removeAll((Collection)bothStates);
        for (String componentName : bothStates) {
            $receiver.compare(componentName, newStates, (Set)diffs);
        }
        return (Set)diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeTo(@Nullable DataWriter $receiver, @NotNull Path file2, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if ($receiver == null) {
            PathKt.delete((Path)file2);
        } else {
            Closeable closeable = SafeWriteUtil.safeOutputStream((Path)file2, null);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                DataWriter.DefaultImpls.write$default($receiver, it, lineSeparator, null, 4, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public static /* synthetic */ void writeTo$default(DataWriter dataWriter, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = LineSeparator.LF.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"LineSeparator.LF.separatorString");
            string = string2;
        }
        XmlElementStorageKt.writeTo(dataWriter, path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(@NotNull DataWriter $receiver, @NotNull LineSeparator lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(1024);
        Closeable closeable = (Closeable)out;
        Throwable throwable = null;
        try {
            BufferExposingByteArrayOutputStream it = (BufferExposingByteArrayOutputStream)closeable;
            OutputStream outputStream = (OutputStream)out;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            DataWriter.DefaultImpls.write$default($receiver, outputStream, string, null, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return out;
    }

    @NotNull
    public static /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(DataWriter dataWriter, LineSeparator lineSeparator, int n, Object object) {
        if ((n & 1) != 0) {
            lineSeparator = LineSeparator.LF;
        }
        return XmlElementStorageKt.toBufferExposingByteArray(dataWriter, lineSeparator);
    }

    @NotNull
    public static final DataWriter createDataWriterForElement(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return new DataWriter(element){
            final /* synthetic */ Element $element;

            public boolean hasData(@NotNull DataWriterFilter filter) {
                Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                return filter.hasData(this.$element);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@NotNull OutputStream output, @NotNull String lineSeparator, @Nullable DataWriterFilter filter) {
                Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
                Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
                Closeable closeable = output;
                Object object = Charsets.UTF_8;
                Closeable closeable2 = closeable;
                closeable2 = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
                int n = 8192;
                closeable = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
                object = null;
                try {
                    BufferedWriter it = (BufferedWriter)closeable;
                    DataWriterFilter dataWriterFilter = filter;
                    new JbXmlOutputter(lineSeparator, (JDOMUtil.ElementOutputFilter)(dataWriterFilter != null ? dataWriterFilter.toElementFilter() : null), null, null).output(this.$element, (Writer)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            {
                this.$element = $captured_local_variable$0;
            }
        };
    }

    @Nullable
    public static final /* synthetic */ List access$save(@NotNull StateMap states, @Nullable Map newLiveStates) {
        return XmlElementStorageKt.save(states, newLiveStates);
    }

    @NotNull
    public static final /* synthetic */ Set access$getChangedComponentNames(@NotNull StateMap $receiver, @NotNull StateMap newStates) {
        return XmlElementStorageKt.getChangedComponentNames($receiver, newStates);
    }
}

