/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0014J\"\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J$\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter;", "", "()V", "defaultFilter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "logConfig", "", "groupId", "", "eventId", "data", "", "logConfigurationState", "componentName", "state", "project", "Lcom/intellij/openapi/project/Project;", "logDefaultConfigurationState", "clazz", "Ljava/lang/Class;", "toHash", "toHash$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
public class FeatureUsageSettingsEventPrinter {
    private final SkipDefaultsSerializationFilter defaultFilter = new SkipDefaultsSerializationFilter();

    public final void logDefaultConfigurationState(@NotNull String componentName, @NotNull Class<?> clazz, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            Object object = this.defaultFilter.getDefaultValue(clazz);
            this.logConfigurationState(componentName, object, project);
        }
        catch (Exception e) {
            FeatureUsageSettingsEventsKt.access$getLOG$p().warn("Cannot initialize default settings for '" + componentName + '\'');
        }
    }

    public final void logConfigurationState(@NotNull String componentName, @Nullable Object state, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        if (state == null || state instanceof Element) {
            return;
        }
        List accessors = BeanBinding.getAccessors(state.getClass());
        if (accessors.isEmpty()) {
            return;
        }
        Project project2 = project;
        boolean isDefaultProject = project2 != null && project2.isDefault();
        String hash = !isDefaultProject ? this.toHash$intellij_platform_configurationStore_impl(project) : null;
        Iterator iterator = accessors.iterator();
        while (iterator.hasNext()) {
            MutableAccessor accessor;
            MutableAccessor mutableAccessor = accessor = (MutableAccessor)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableAccessor, (String)"accessor");
            Type type = mutableAccessor.getGenericType();
            if (type != Boolean.TYPE) continue;
            Object value = accessor.read(state);
            boolean isNotDefault = this.defaultFilter.accepts((Accessor)accessor, state);
            HashMap content = new HashMap();
            Object object = content;
            String string = "name";
            String string2 = accessor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accessor.name");
            Object object2 = string2;
            object.put(string, object2);
            object = content;
            string = "value";
            Object object3 = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"value");
            object2 = object3;
            object.put(string, object2);
            if (isNotDefault) {
                object = content;
                string = "default";
                object2 = false;
                object.put(string, object2);
            }
            if (isDefaultProject) {
                object = content;
                string = "default_project";
                object2 = true;
                object.put(string, object2);
            } else {
                String string3 = hash;
                if (string3 != null) {
                    Object it = object = string3;
                    object2 = content;
                    String string4 = "project";
                    String string5 = hash;
                    object2.put(string4, string5);
                }
            }
            this.logConfig("settings", componentName, content);
        }
    }

    protected void logConfig(@NotNull String groupId, @NotNull String eventId, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        FeatureUsageLogger.INSTANCE.logState(groupId, eventId, data);
    }

    @Nullable
    public final String toHash$intellij_platform_configurationStore_impl(@Nullable Project project) {
        Project project2 = project;
        if (project2 != null) {
            Project project3;
            Project it = project3 = project2;
            return StatisticsUtilKt.getProjectId(project);
        }
        return null;
    }
}

