/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.NativeCredentialStoreWrapper;
import com.intellij.credentialStore.NativeCredentialStoreWrapperKt;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0096\u0002J\u001b\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0096\u0002RN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a$\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/credentialStore/NativeCredentialStoreWrapper;", "Lcom/intellij/credentialStore/CredentialStore;", "store", "(Lcom/intellij/credentialStore/CredentialStore;)V", "deniedItems", "Lcom/google/common/cache/Cache;", "Lcom/intellij/credentialStore/CredentialAttributes;", "kotlin.jvm.PlatformType", "", "fallbackStore", "Lkotlin/Lazy;", "Lcom/intellij/credentialStore/keePass/InMemoryCredentialStore;", "postponedCredentials", "postponedRemovedCredentials", "", "", "queueProcessor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lkotlin/Function0;", "", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "set", "credentials", "intellij.platform.credentialStore"})
final class NativeCredentialStoreWrapper
implements CredentialStore {
    private final Lazy<InMemoryCredentialStore> fallbackStore;
    private final QueueProcessor<Function0<Unit>> queueProcessor;
    private final InMemoryCredentialStore postponedCredentials;
    private final Set<CredentialAttributes> postponedRemovedCredentials;
    private final Cache<CredentialAttributes, Boolean> deniedItems;
    private final CredentialStore store;

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (this.postponedRemovedCredentials.contains(attributes)) {
            return null;
        }
        Credentials credentials = this.postponedCredentials.get(attributes);
        if (credentials != null) {
            Credentials credentials2;
            Credentials it = credentials2 = credentials;
            return it;
        }
        if (this.deniedItems.getIfPresent((Object)attributes) != null) {
            CredentialStoreKt.getLOG().warn("User denied access to " + attributes);
            return null;
        }
        CredentialStore store = this.fallbackStore.isInitialized() ? (CredentialStore)this.fallbackStore.getValue() : this.store;
        try {
            Credentials value = store.get(attributes);
            if (value == CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                this.deniedItems.put((Object)attributes, (Object)true);
            }
            return value;
        }
        catch (UnsatisfiedLinkError e) {
            store = (CredentialStore)this.fallbackStore.getValue();
            NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
            return store.get(attributes);
        }
        catch (Throwable e) {
            CredentialStoreKt.getLOG().error(e);
            return null;
        }
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Logger $receiver$iv = CredentialStoreKt.getLOG();
        try {
            if (this.fallbackStore.isInitialized()) {
                ((InMemoryCredentialStore)this.fallbackStore.getValue()).set(attributes, credentials);
                return;
            }
            if (credentials == null) {
                this.postponedRemovedCredentials.add(attributes);
            } else {
                this.postponedCredentials.set(attributes, credentials);
            }
            this.queueProcessor.add((Object)new Function0<Unit>(this, attributes, credentials){
                final /* synthetic */ NativeCredentialStoreWrapper this$0;
                final /* synthetic */ CredentialAttributes $attributes$inlined;
                final /* synthetic */ Credentials $credentials$inlined;
                {
                    this.this$0 = nativeCredentialStoreWrapper;
                    this.$attributes$inlined = credentialAttributes;
                    this.$credentials$inlined = credentials;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        CredentialStore store = NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).isInitialized() ? (CredentialStore)NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).getValue() : NativeCredentialStoreWrapper.access$getStore$p(this.this$0);
                        try {
                            store.set(this.$attributes$inlined, this.$credentials$inlined);
                        }
                        catch (UnsatisfiedLinkError e) {
                            store = (CredentialStore)NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).getValue();
                            NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
                            store.set(this.$attributes$inlined, this.$credentials$inlined);
                        }
                        catch (Throwable e) {
                            CredentialStoreKt.getLOG().error(e);
                        }
                    }
                    finally {
                        if (!NativeCredentialStoreWrapper.access$getPostponedRemovedCredentials$p(this.this$0).remove(this.$attributes$inlined)) {
                            NativeCredentialStoreWrapper.access$getPostponedCredentials$p(this.this$0).set(this.$attributes$inlined, null);
                        }
                    }
                }
            });
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
    }

    public NativeCredentialStoreWrapper(@NotNull CredentialStore store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
        this.fallbackStore = LazyKt.lazy((Function0)fallbackStore.1.INSTANCE);
        this.queueProcessor = new QueueProcessor((Consumer)queueProcessor.1.INSTANCE);
        this.postponedCredentials = new InMemoryCredentialStore();
        this.postponedRemovedCredentials = ContainerUtil.newConcurrentSet();
        this.deniedItems = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @NotNull
    public static final /* synthetic */ Lazy access$getFallbackStore$p(NativeCredentialStoreWrapper $this) {
        return $this.fallbackStore;
    }

    @NotNull
    public static final /* synthetic */ CredentialStore access$getStore$p(NativeCredentialStoreWrapper $this) {
        return $this.store;
    }

    @NotNull
    public static final /* synthetic */ Set access$getPostponedRemovedCredentials$p(NativeCredentialStoreWrapper $this) {
        return $this.postponedRemovedCredentials;
    }

    @NotNull
    public static final /* synthetic */ InMemoryCredentialStore access$getPostponedCredentials$p(NativeCredentialStoreWrapper $this) {
        return $this.postponedCredentials;
    }
}

