/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.Date;
import java.util.function.IntConsumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a2\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0019\u001a2\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a0\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"INTERVAL", "", "previousReport", "Lkotlin/Pair;", "", "onError", "", "e", "Ljava/lang/Exception;", "errorBean", "Lcom/intellij/diagnostic/ITNProxy$ErrorBean;", "parentComponent", "Ljava/awt/Component;", "callback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "project", "Lcom/intellij/openapi/project/Project;", "onSuccess", "threadId", "eventData", "", "setPluginInfo", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "Lcom/intellij/errorreport/bean/ErrorBean;", "showMessageDialog", "message", "", "title", "icon", "Ljavax/swing/Icon;", "submit", "", "intellij.platform.ide.impl"})
public final class ITNReporterKt {
    private static final long INTERVAL = 600000L;
    private static volatile Pair<Long, Integer> previousReport;

    public static final void setPluginInfo(@NotNull IdeaLoggingEvent event, @NotNull ErrorBean errorBean) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)errorBean, (String)"errorBean");
        com.intellij.openapi.util.Pair<String, String> pluginInfo = IdeErrorsDialog.getPluginInfo(event);
        if (pluginInfo != null) {
            errorBean.setPluginName((String)pluginInfo.first);
            errorBean.setPluginVersion((String)pluginInfo.second);
        }
    }

    private static final void showMessageDialog(Component parentComponent, Project project, String message, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            Messages.showMessageDialog((Component)parentComponent, (String)message, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)project, (String)message, (String)title, (Icon)icon);
        }
    }

    private static final boolean submit(ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer<SubmittedReportInfo> callback2, Project project) {
        Credentials credentials = ErrorReportConfigurable.Companion.getCredentials();
        if (CredentialAttributesKt.hasOnlyUserName((Credentials)credentials)) {
            if (!JetBrainsAccountDialogKt.showJetBrainsAccountDialog$default(parentComponent, null, 2, null).showAndGet()) {
                return false;
            }
            credentials = ErrorReportConfigurable.Companion.getCredentials();
        }
        Credentials credentials2 = credentials;
        Credentials credentials3 = credentials;
        ITNProxy.sendError(project, credentials2 != null ? credentials2.getUserName() : null, credentials3 != null ? credentials3.getPasswordAsString() : null, errorBean, new IntConsumer(errorBean, callback2, project){
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ Project $project;

            public final void accept(int threadId) {
                IdeaLoggingEvent ideaLoggingEvent = this.$errorBean.event;
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaLoggingEvent, (String)"errorBean.event");
                ITNReporterKt.access$onSuccess(threadId, ideaLoggingEvent.getData(), this.$callback, this.$project);
            }
            {
                this.$errorBean = errorBean;
                this.$callback = consumer;
                this.$project = project;
            }
        }, (java.util.function.Consumer<? super Exception>)new java.util.function.Consumer<Exception>(errorBean, parentComponent, callback2, project){
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ Project $project;

            public final void accept(Exception e) {
                Exception exception = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)exception, (String)"e");
                ITNReporterKt.access$onError(exception, this.$errorBean, this.$parentComponent, this.$callback, this.$project);
            }
            {
                this.$errorBean = errorBean;
                this.$parentComponent = component;
                this.$callback = consumer;
                this.$project = project;
            }
        });
        return true;
    }

    private static final void onSuccess(int threadId, Object eventData, Consumer<SubmittedReportInfo> callback2, Project project) {
        Pair pair;
        if (eventData instanceof AbstractMessage) {
            Date date = ((AbstractMessage)eventData).getDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"eventData.date");
            pair = TuplesKt.to((Object)date.getTime(), (Object)threadId);
        } else {
            pair = null;
        }
        previousReport = pair;
        String linkText = String.valueOf(threadId);
        SubmittedReportInfo reportInfo = new SubmittedReportInfo(ITNProxy.getBrowseUrl(threadId), linkText, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
        callback2.consume((Object)reportInfo);
        ApplicationManager.getApplication().invokeLater(new Runnable(reportInfo, project){
            final /* synthetic */ SubmittedReportInfo $reportInfo;
            final /* synthetic */ Project $project;

            public final void run() {
                StringBuilder text = new StringBuilder();
                IdeErrorsDialog.appendSubmissionInformation(this.$reportInfo, text);
                text.append('.').append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                String content = XmlStringUtil.wrapInHtml((CharSequence)text);
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, content, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(this.$project);
            }
            {
                this.$reportInfo = submittedReportInfo;
                this.$project = project;
            }
        });
    }

    private static final void onError(Exception e, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer<SubmittedReportInfo> callback2, Project project) {
        Logger.getInstance(ITNReporter.class).info("reporting failed: " + e);
        ApplicationManager.getApplication().invokeLater(new Runnable(e, parentComponent, project, callback2, errorBean){
            final /* synthetic */ Exception $e;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Project $project;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;

            public final void run() {
                if (this.$e instanceof UpdateAvailableException) {
                    String message;
                    String string = message = DiagnosticBundle.message("error.report.new.eap.build.message", this.$e.getMessage());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                    String string2 = CommonBundle.getWarningTitle();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CommonBundle.getWarningTitle()");
                    Icon icon = Messages.getWarningIcon();
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"Messages.getWarningIcon()");
                    ITNReporterKt.access$showMessageDialog(this.$parentComponent, this.$project, string, string2, icon);
                    this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                    return;
                }
                Exception exception = this.$e;
                String msg = exception instanceof NoSuchEAPUserException ? DiagnosticBundle.message("error.report.authentication.failed", new Object[0]) : (exception instanceof InternalEAPException ? DiagnosticBundle.message("error.report.posting.failed", this.$e.getMessage()) : DiagnosticBundle.message("error.report.sending.failure", new Object[0]));
                MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.yesNo((String)ReportMessages.ERROR_REPORT, (String)msg).project(this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDialogBuilder, (String)"MessageDialogBuilder.yes\u2026RT, msg).project(project)");
                if (!((MessageDialogBuilder.YesNo)messageDialogBuilder).isYes()) {
                    this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                } else {
                    if (this.$e instanceof NoSuchEAPUserException) {
                        JetBrainsAccountDialogKt.showJetBrainsAccountDialog(this.$parentComponent, this.$project).show();
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ onError.1 this$0;

                        public final void run() {
                            ITNReporterKt.access$submit(this.this$0.$errorBean, this.this$0.$parentComponent, this.this$0.$callback, this.this$0.$project);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.$e = exception;
                this.$parentComponent = component;
                this.$project = project;
                this.$callback = consumer;
                this.$errorBean = errorBean;
            }
        });
    }

    @Nullable
    public static final /* synthetic */ Pair access$getPreviousReport$p() {
        return previousReport;
    }

    public static final /* synthetic */ void access$setPreviousReport$p(@Nullable Pair pair) {
        previousReport = pair;
    }

    public static final /* synthetic */ boolean access$submit(@NotNull ITNProxy.ErrorBean errorBean, @NotNull Component parentComponent, @NotNull Consumer callback2, @Nullable Project project) {
        return ITNReporterKt.submit(errorBean, parentComponent, (Consumer<SubmittedReportInfo>)callback2, project);
    }

    public static final /* synthetic */ void access$onSuccess(int threadId, @Nullable Object eventData, @NotNull Consumer callback2, @Nullable Project project) {
        ITNReporterKt.onSuccess(threadId, eventData, (Consumer<SubmittedReportInfo>)callback2, project);
    }

    public static final /* synthetic */ void access$onError(@NotNull Exception e, @NotNull ITNProxy.ErrorBean errorBean, @NotNull Component parentComponent, @NotNull Consumer callback2, @Nullable Project project) {
        ITNReporterKt.onError(e, errorBean, parentComponent, (Consumer<SubmittedReportInfo>)callback2, project);
    }

    public static final /* synthetic */ void access$showMessageDialog(@NotNull Component parentComponent, @Nullable Project project, @NotNull String message, @NotNull String title, @NotNull Icon icon) {
        ITNReporterKt.showMessageDialog(parentComponent, project, message, title, icon);
    }
}

