/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TokenBuffer {
    static final TokenInfo CR_TOKEN = new TokenInfo(ConsoleViewContentType.SYSTEM_OUTPUT, "\r", null);
    private final int maxCapacity;
    private final Queue<TokenInfo> tokens = new Queue(10);
    private int size;
    private int startIndex;

    TokenBuffer(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    void print(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (text == null) {
            TokenBuffer.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            TokenBuffer.$$$reportNull$$$0(1);
        }
        int start2 = 0;
        while (start2 < text.length()) {
            TokenInfo tokenInfo;
            int crIndex;
            if (this.hasTrailingCR()) {
                this.combineTrailingCRWith(text);
            }
            if ((crIndex = text.indexOf(13, start2)) == -1 || crIndex == text.length() - 1) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2), info);
                this.tokens.addLast((Object)tokenInfo);
                this.size += tokenInfo.length();
                break;
            }
            if (start2 != crIndex) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2, crIndex), info);
                this.tokens.addLast((Object)tokenInfo);
                this.size += tokenInfo.length();
            }
            this.removeLastLine();
            start2 = crIndex + 1;
        }
        this.trim();
    }

    private boolean hasTrailingCR() {
        return !this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN && StringUtil.endsWithChar((CharSequence)((TokenInfo)this.tokens.peekLast()).getText(), (char)'\r');
    }

    private void combineTrailingCRWith(@NotNull String currentText) {
        if (currentText == null) {
            TokenBuffer.$$$reportNull$$$0(2);
        }
        if (StringUtil.startsWith((CharSequence)currentText, (CharSequence)"\n")) {
            TokenInfo last = (TokenInfo)this.tokens.removeLast();
            String lastTextWithNoCR = last.getText().substring(0, last.length() - 1);
            if (!lastTextWithNoCR.isEmpty()) {
                TokenInfo newLast = new TokenInfo(last.contentType, lastTextWithNoCR, last.getHyperlinkInfo());
                this.tokens.addLast((Object)newLast);
                --this.size;
            }
            return;
        }
        this.removeLastLine();
    }

    private void removeLastLine() {
        while (!this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN) {
            TokenInfo last = (TokenInfo)this.tokens.removeLast();
            String text = last.getText();
            int lfIndex = text.lastIndexOf(10);
            if (lfIndex != -1) {
                TokenInfo newToken = new TokenInfo(last.contentType, text.substring(0, lfIndex + 1), last.getHyperlinkInfo());
                this.tokens.addLast((Object)newToken);
                this.size -= text.length() - newToken.length();
                return;
            }
            this.size -= text.length();
        }
        if (this.tokens.isEmpty()) {
            this.tokens.addLast((Object)CR_TOKEN);
            ++this.size;
        }
    }

    private void trim() {
        while (this.size - this.startIndex > this.maxCapacity) {
            TokenInfo info = (TokenInfo)this.tokens.peekFirst();
            int length = info.length() - this.startIndex;
            if (length > this.size - this.maxCapacity) {
                this.startIndex += this.size - this.maxCapacity;
                break;
            }
            this.startIndex = 0;
            this.tokens.pullFirst();
            this.size -= info.length();
        }
    }

    int length() {
        return this.size - this.startIndex;
    }

    void clear() {
        this.tokens.clear();
        this.startIndex = 0;
        this.size = 0;
    }

    @NotNull
    CharSequence getText() {
        if (this.hasTrailingCR()) {
            this.removeLastLine();
        }
        CharSequence charSequence = this.getInfos().stream().map(TokenInfo::getText).collect(Collectors.joining(""));
        if (charSequence == null) {
            TokenBuffer.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @NotNull
    List<TokenInfo> drain() {
        if (this.hasTrailingCR()) {
            this.removeLastLine();
        }
        List<TokenInfo> list2 = this.getInfos();
        List<TokenInfo> list3 = list2;
        if (list3 == null) {
            TokenBuffer.$$$reportNull$$$0(4);
        }
        return list3;
        finally {
            this.clear();
        }
    }

    @NotNull
    private List<TokenInfo> getInfos() {
        List list2 = this.tokens.toList();
        if (this.startIndex != 0) {
            TokenInfo first = (TokenInfo)list2.get(0);
            TokenInfo sliced = new TokenInfo(first.contentType, first.getText().substring(this.startIndex), first.getHyperlinkInfo());
            List list3 = ContainerUtil.concat(Collections.singletonList(sliced), list2.subList(1, list2.size()));
            if (list3 == null) {
                TokenBuffer.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List list4 = list2;
        if (list4 == null) {
            TokenBuffer.$$$reportNull$$$0(6);
        }
        return list4;
    }

    int getCycleBufferSize() {
        return this.maxCapacity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/TokenBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/TokenBuffer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "drain";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineTrailingCRWith";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TokenInfo {
        @NotNull
        final ConsoleViewContentType contentType;
        private final String text;
        private final HyperlinkInfo myHyperlinkInfo;

        TokenInfo(@NotNull ConsoleViewContentType contentType, @NotNull String text, @Nullable HyperlinkInfo hyperlinkInfo) {
            if (contentType == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            this.contentType = contentType;
            this.myHyperlinkInfo = hyperlinkInfo;
            this.text = text;
        }

        int length() {
            return this.text.length();
        }

        public String toString() {
            return this.contentType + "[" + this.length() + "]";
        }

        HyperlinkInfo getHyperlinkInfo() {
            return this.myHyperlinkInfo;
        }

        @NotNull
        String getText() {
            String string = this.text;
            if (string == null) {
                TokenInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/TokenBuffer$TokenInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/TokenBuffer$TokenInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

