/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.GeneralSettingsConfigurableEP;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public class GeneralSettingsConfigurable
extends CompositeConfigurable<SearchableConfigurable>
implements SearchableConfigurable {
    private static final ExtensionPointName<GeneralSettingsConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.generalOptionsProvider");
    private MyComponent myComponent = new MyComponent();

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setReopenLastProject(this.myComponent.myChkReopenLastProject.isSelected());
        settings.setSyncOnFrameActivation(this.myComponent.myChkSyncOnFrameActivation.isSelected());
        settings.setSaveOnFrameDeactivation(this.myComponent.myChkSaveOnFrameDeactivation.isSelected());
        settings.setConfirmExit(this.myComponent.myConfirmExit.isSelected());
        settings.setShowWelcomeScreen(this.myComponent.myShowWelcomeScreen.isSelected());
        settings.setConfirmOpenNewProject(this.getConfirmOpenNewProject());
        settings.setProcessCloseConfirmation(this.getProcessCloseConfirmation());
        settings.setAutoSaveIfInactive(this.myComponent.myChkAutoSaveIfInactive.isSelected());
        try {
            settings.setInactiveTimeout(Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.setUseSafeWrite(this.myComponent.myChkUseSafeWrite.isSelected());
        settings.setDefaultProjectDirectory(this.myComponent.myProjectDirectoryTextField.getText());
    }

    private GeneralSettings.ProcessCloseConfirmation getProcessCloseConfirmation() {
        if (this.myComponent.myTerminateProcessJBRadioButton.isSelected()) {
            return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        }
        if (this.myComponent.myDisconnectJBRadioButton.isSelected()) {
            return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
        }
        return GeneralSettings.ProcessCloseConfirmation.ASK;
    }

    @GeneralSettings.OpenNewProjectOption
    private int getConfirmOpenNewProject() {
        if (this.myComponent.myConfirmWindowToOpenProject.isSelected()) {
            return -1;
        }
        if (this.myComponent.myOpenProjectInNewWindow.isSelected()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        boolean isModified = settings.isReopenLastProject() != this.myComponent.myChkReopenLastProject.isSelected();
        isModified |= settings.isSyncOnFrameActivation() != this.myComponent.myChkSyncOnFrameActivation.isSelected();
        isModified |= settings.isSaveOnFrameDeactivation() != this.myComponent.myChkSaveOnFrameDeactivation.isSelected();
        isModified |= settings.isAutoSaveIfInactive() != this.myComponent.myChkAutoSaveIfInactive.isSelected();
        isModified |= settings.isConfirmExit() != this.myComponent.myConfirmExit.isSelected();
        isModified |= settings.isShowWelcomeScreen() != this.myComponent.myShowWelcomeScreen.isSelected();
        isModified |= settings.getConfirmOpenNewProject() != this.getConfirmOpenNewProject();
        isModified |= settings.getProcessCloseConfirmation() != this.getProcessCloseConfirmation();
        isModified |= this.isModified(this.myComponent.myTfInactiveTimeout, settings.getInactiveTimeout(), GeneralSettings.SAVE_FILES_AFTER_IDLE_SEC);
        isModified |= settings.isUseSafeWrite() != this.myComponent.myChkUseSafeWrite.isSelected();
        return isModified |= !settings.getDefaultProjectDirectory().equals(this.myComponent.myProjectDirectoryTextField.getText());
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        this.myComponent.myShowWelcomeScreen.setVisible(PlatformUtils.isDataGrip());
        this.myComponent.myChkAutoSaveIfInactive.addChangeListener(e -> this.myComponent.myTfInactiveTimeout.setEditable(this.myComponent.myChkAutoSaveIfInactive.isSelected()));
        List list2 = this.getConfigurables();
        if (!list2.isEmpty()) {
            this.myComponent.myPluginOptionsPanel.setLayout(new GridLayout(list2.size(), 1));
            for (Configurable c : list2) {
                this.myComponent.myPluginOptionsPanel.add(c.createComponent());
            }
        }
        return this.myComponent.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.general", (Object[])new Object[0]);
    }

    @Override
    public void reset() {
        super.reset();
        GeneralSettings settings = GeneralSettings.getInstance();
        this.myComponent.myChkReopenLastProject.setSelected(settings.isReopenLastProject());
        this.myComponent.myChkSyncOnFrameActivation.setSelected(settings.isSyncOnFrameActivation());
        this.myComponent.myChkSaveOnFrameDeactivation.setSelected(settings.isSaveOnFrameDeactivation());
        this.myComponent.myChkAutoSaveIfInactive.setSelected(settings.isAutoSaveIfInactive());
        this.myComponent.myTfInactiveTimeout.setText(Integer.toString(settings.getInactiveTimeout()));
        this.myComponent.myTfInactiveTimeout.setEditable(settings.isAutoSaveIfInactive());
        this.myComponent.myChkUseSafeWrite.setSelected(settings.isUseSafeWrite());
        this.myComponent.myConfirmExit.setSelected(settings.isConfirmExit());
        this.myComponent.myShowWelcomeScreen.setSelected(settings.isShowWelcomeScreen());
        switch (settings.getConfirmOpenNewProject()) {
            case -1: {
                this.myComponent.myConfirmWindowToOpenProject.setSelected(true);
                break;
            }
            case 0: {
                this.myComponent.myOpenProjectInNewWindow.setSelected(true);
                break;
            }
            case 1: {
                this.myComponent.myOpenProjectInSameWindow.setSelected(true);
            }
        }
        switch (settings.getProcessCloseConfirmation()) {
            case TERMINATE: {
                this.myComponent.myTerminateProcessJBRadioButton.setSelected(true);
                break;
            }
            case DISCONNECT: {
                this.myComponent.myDisconnectJBRadioButton.setSelected(true);
                break;
            }
            case ASK: {
                this.myComponent.myAskJBRadioButton.setSelected(true);
            }
        }
        this.myComponent.myProjectDirectoryTextField.setText(settings.getDefaultProjectDirectory());
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.general" == null) {
            GeneralSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return "preferences.general";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            GeneralSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<SearchableConfigurable> createConfigurables() {
        List<SearchableConfigurable> list2 = ConfigurableWrapper.createConfigurables(EP_NAME);
        if (list2 == null) {
            GeneralSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/GeneralSettingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyComponent {
        private JPanel myPanel;
        private JCheckBox myChkReopenLastProject;
        private JCheckBox myChkSyncOnFrameActivation;
        private JCheckBox myChkSaveOnFrameDeactivation;
        private JCheckBox myChkAutoSaveIfInactive;
        private JTextField myTfInactiveTimeout;
        private JCheckBox myChkUseSafeWrite;
        private JCheckBox myConfirmExit;
        private JCheckBox myShowWelcomeScreen;
        private JPanel myPluginOptionsPanel;
        private JBRadioButton myOpenProjectInNewWindow;
        private JBRadioButton myOpenProjectInSameWindow;
        private JBRadioButton myConfirmWindowToOpenProject;
        private JBRadioButton myTerminateProcessJBRadioButton;
        private JBRadioButton myDisconnectJBRadioButton;
        private JBRadioButton myAskJBRadioButton;
        private TextFieldWithBrowseButton myProjectDirectoryTextField;
        private JPanel myProjectOpeningPanel;

        MyComponent() {
            this.$$$setupUI$$$();
            String conceptName = IdeUICustomization.getInstance().getProjectConceptName();
            this.myChkReopenLastProject.setText(IdeBundle.message((String)"checkbox.reopen.last.project.on.startup", (Object[])new Object[]{conceptName}));
            ((TitledBorder)this.myProjectOpeningPanel.getBorder()).setTitle(IdeBundle.message((String)"border.title.project.opening", (Object[])new Object[]{StringUtil.capitalize((String)conceptName)}));
            this.myOpenProjectInNewWindow.setText(IdeBundle.message((String)"radio.button.open.project.in.the.new.window", (Object[])new Object[]{conceptName}));
            this.myOpenProjectInSameWindow.setText(IdeBundle.message((String)"radio.button.open.project.in.the.same.window", (Object[])new Object[]{conceptName}));
            this.myConfirmWindowToOpenProject.setText(IdeBundle.message((String)"radio.button.confirm.window.to.open.project.in", (Object[])new Object[]{conceptName}));
        }

        private void createUIComponents() {
            this.myProjectDirectoryTextField = new TextFieldWithBrowseButton();
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, (Object)false);
            this.myProjectDirectoryTextField.addBrowseFolderListener(null, null, null, descriptor);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBRadioButton jBRadioButton;
            JBRadioButton jBRadioButton2;
            JBRadioButton jBRadioButton3;
            JBRadioButton jBRadioButton4;
            JBRadioButton jBRadioButton5;
            JBRadioButton jBRadioButton6;
            JPanel jPanel;
            JPanel jPanel2;
            JCheckBox jCheckBox;
            JTextField jTextField;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JPanel jPanel3;
            this.createUIComponents();
            this.myPanel = jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Startup/Shutdown", (int)0, (int)0, null, null));
            this.myChkReopenLastProject = jCheckBox7 = new JCheckBox();
            jCheckBox7.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.reopen.last.project.on.startup"));
            jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel4.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myConfirmExit = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.confirm.application.exit"));
            jPanel4.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowWelcomeScreen = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.welcome.screen"));
            jPanel4.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Synchronization", (int)0, (int)0, null, null));
            this.myChkSyncOnFrameActivation = jCheckBox4 = new JCheckBox();
            jCheckBox4.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.synchronize.files.on.frame.activation"));
            jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel5.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myChkSaveOnFrameDeactivation = jCheckBox3 = new JCheckBox();
            jCheckBox3.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.on.frame.deactivation"));
            jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkAutoSaveIfInactive = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.automatically"));
            jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel6, new GridConstraints(2, 1, 1, 1, 8, 2, 0, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.inactive.timeout.sec"));
            jPanel6.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfInactiveTimeout = jTextField = new JTextField();
            jTextField.setColumns(10);
            jTextField.setMargin(new Insets(1, 5, 1, 5));
            jPanel6.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
            this.myChkUseSafeWrite = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            jCheckBox.setText("Use \"safe write\" (save changes to a temporary file first)");
            jCheckBox.setToolTipText("<html>If this check box is selected, a changed file will be first saved to a temporary file;<br>if the save operation is completed successfully, the original file is deleted, and the temporary file is renamed.</html> ");
            jPanel5.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            Spacer spacer5 = new Spacer();
            jPanel3.add((Component)spacer5, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myPluginOptionsPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(0, 0));
            jPanel3.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myProjectOpeningPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("border.title.project.opening"), (int)0, (int)0, null, null));
            this.myOpenProjectInSameWindow = jBRadioButton6 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton6, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.button.open.project.in.the.same.window"));
            jPanel.add((Component)jBRadioButton6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myConfirmWindowToOpenProject = jBRadioButton5 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton5, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.button.confirm.window.to.open.project.in"));
            jPanel.add((Component)jBRadioButton5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer6 = new Spacer();
            jPanel.add((Component)spacer6, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myOpenProjectInNewWindow = jBRadioButton4 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton4, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.button.open.project.in.the.new.window"));
            jPanel.add((Component)jBRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Default directory:");
            jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.myProjectDirectoryTextField;
            jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
            JBLabel jBLabel = new JBLabel();
            jBLabel.setBackground(new Color(-8882056));
            jBLabel.setForeground(new Color(-8882056));
            jBLabel.setText("Selected by default in the \"Open File or Project\" dialog and for new projects. To remove, clear the field.");
            jPanel7.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.settings.process.tab.close"), (int)0, (int)0, null, null));
            this.myTerminateProcessJBRadioButton = jBRadioButton3 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.terminate"));
            jPanel8.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDisconnectJBRadioButton = jBRadioButton2 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.disaconnect"));
            jPanel8.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAskJBRadioButton = jBRadioButton = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.ask"));
            jPanel8.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2 = new ButtonGroup();
            buttonGroup2.add((AbstractButton)jBRadioButton4);
            buttonGroup2.add((AbstractButton)jBRadioButton6);
            buttonGroup2.add((AbstractButton)jBRadioButton5);
            buttonGroup2 = new ButtonGroup();
            buttonGroup2.add((AbstractButton)jBRadioButton3);
            buttonGroup2.add((AbstractButton)jBRadioButton2);
            buttonGroup2.add((AbstractButton)jBRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

