/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.LaunchBrowserBeforeRunTask;
import com.intellij.ide.browsers.LaunchBrowserBeforeRunTaskState;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\r\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00020\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTask;", "()V", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "task", "createTask", "executeTask", "configuration", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getIcon", "Ljavax/swing/Icon;", "getId", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "getName", "", "isConfigurable", "Companion", "intellij.xml.impl"})
public final class LaunchBrowserBeforeRunTaskProvider
extends BeforeRunTaskProvider<LaunchBrowserBeforeRunTask> {
    @NotNull
    private static final Key<LaunchBrowserBeforeRunTask> ID;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return "Launch Web Browser";
    }

    @NotNull
    public Key<LaunchBrowserBeforeRunTask> getId() {
        return ID;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.PpWeb;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Nodes.PpWeb");
        return icon;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public LaunchBrowserBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)runConfiguration, (String)"runConfiguration");
        return new LaunchBrowserBeforeRunTask();
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration runConfiguration, @NotNull LaunchBrowserBeforeRunTask task) {
        LayoutBuilder this_$iv$iv;
        Row row$iv$iv;
        LayoutBuilder this_$iv;
        LayoutBuilder builder$iv;
        LayoutBuilder $receiver;
        JCheckBox jCheckBox;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        LaunchBrowserBeforeRunTaskState state = task.getState();
        long modificationCount = state.getModificationCount();
        BrowserSelector browserSelector = new BrowserSelector();
        JComponent browserComboBox = browserSelector.getMainComponent();
        if (UIUtil.isUnderAquaLookAndFeel()) {
            JComponent jComponent = browserComboBox;
            Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"browserComboBox");
            jComponent.setBorder(new EmptyBorder(3, 0, 0, 0));
        }
        WebBrowser webBrowser = state.getBrowser();
        if (webBrowser != null) {
            WebBrowser webBrowser2;
            it = webBrowser2 = webBrowser;
            browserSelector.setSelected((WebBrowser)it);
        }
        TextFieldWithBrowseButton url = new TextFieldWithBrowseButton();
        String string = state.getUrl();
        if (string != null) {
            Object it2 = it = string;
            url.setText((String)it2);
        }
        StartBrowserPanel.setupUrlField(url, runConfiguration.getProject());
        if (JavaScriptDebuggerStarter.Util.hasStarters()) {
            String string2 = XmlBundle.message((String)"start.browser.with.js.debugger", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"XmlBundle.message(\"start\u2026rowser.with.js.debugger\")");
            jCheckBox = ComponentsKt.CheckBox$default(string2, state.getWithDebugger(), null, 4, null);
        } else {
            jCheckBox = null;
        }
        JCheckBox startJavaScriptDebuggerCheckBox = jCheckBox;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        LayoutBuilder layoutBuilder = $receiver = (builder$iv = LayoutImplKt.createLayoutBuilder(!ArraysKt.contains((Object[])constraints$iv, (Object)((Object)LCFlags.disableMagic))));
        String label$iv = "Browser:";
        void var19_17 = this_$iv;
        JLabel label$iv$iv = ComponentsKt.Label$default(label$iv, null, null, false, 14, null);
        boolean separated$iv$iv = false;
        Row $receiver2 = row$iv$iv = this_$iv$iv.getBuilder().newRow(label$iv$iv, this_$iv$iv.getButtonGroup(), separated$iv$iv);
        JComponent jComponent = browserComboBox;
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"browserComboBox");
        Cell.invoke$default($receiver2, jComponent, new CCFlags[0], 0, null, null, 14, null);
        JCheckBox jCheckBox2 = startJavaScriptDebuggerCheckBox;
        if (jCheckBox2 != null) {
            Cell.invoke$default($receiver2, jCheckBox2, new CCFlags[0], 0, null, null, 14, null);
        }
        this_$iv = $receiver;
        label$iv = "Url:";
        this_$iv$iv = this_$iv;
        label$iv$iv = ComponentsKt.Label$default(label$iv, null, null, false, 14, null);
        separated$iv$iv = false;
        $receiver2 = row$iv$iv = this_$iv$iv.getBuilder().newRow(label$iv$iv, this_$iv$iv.getButtonGroup(), separated$iv$iv);
        String string3 = null;
        CCFlags[] cCFlagsArray = new CCFlags[]{};
        int n = 0;
        GrowPolicy growPolicy = GrowPolicy.MEDIUM_TEXT;
        Cell.invoke$default($receiver2, (JComponent)url, cCFlagsArray, n, growPolicy, string3, 10, null);
        JPanel panel$iv = ComponentsKt.Panel(title$iv, null);
        builder$iv.getBuilder().build(panel$iv, constraints$iv);
        JPanel panel2 = panel$iv;
        ComponentsKt.dialog$default("Launch Web Browser", panel2, true, (JComponent)url, false, null, null, null, null, null, null, 2032, null).show();
        state.setBrowser(browserSelector.getSelected());
        state.setUrl(url.getText());
        if (startJavaScriptDebuggerCheckBox != null) {
            state.setWithDebugger(startJavaScriptDebuggerCheckBox.isSelected());
        }
        Promise promise2 = Promise.resolve((Object)(modificationCount != state.getModificationCount() ? 1 : 0));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(modifica\u2026 state.modificationCount)");
        return promise2;
    }

    public boolean executeTask(@Nullable DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull LaunchBrowserBeforeRunTask task) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)env.getProject()), (Disposable)disposable);
        long executionId = env.getExecutionId();
        Project project = env.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"env.project");
        project.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(disposable, executionId, task, configuration){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ long $executionId;
            final /* synthetic */ LaunchBrowserBeforeRunTask $task;
            final /* synthetic */ RunConfiguration $configuration;

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
                Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
                Disposer.dispose((Disposable)this.$disposable);
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
                Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
                Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
                if (env.getExecutionId() != this.$executionId) {
                    return;
                }
                Disposer.dispose((Disposable)this.$disposable);
                StartBrowserSettings settings = new StartBrowserSettings();
                settings.setBrowser(this.$task.getState().getBrowser());
                settings.setStartJavaScriptDebugger(this.$task.getState().getWithDebugger());
                settings.setUrl(this.$task.getState().getUrl());
                settings.setSelected(true);
                new BrowserStarter(this.$configuration, settings, handler2).start();
            }
            {
                this.$disposable = $captured_local_variable$0;
                this.$executionId = $captured_local_variable$1;
                this.$task = $captured_local_variable$2;
                this.$configuration = $captured_local_variable$3;
            }
        });
        return true;
    }

    static {
        Companion = new Companion(null);
        ID = Key.create((String)"LaunchBrowser.Before.Run");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTaskProvider$Companion;", "", "()V", "ID", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTask;", "kotlin.jvm.PlatformType", "getID", "()Lcom/intellij/openapi/util/Key;", "intellij.xml.impl"})
    public static final class Companion {
        @NotNull
        public final Key<LaunchBrowserBeforeRunTask> getID() {
            return ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

